/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.alipaysecuritysdk.api.service.model;

import com.alipay.alipaysecuritysdk.api.tool.MapTool;
import com.alipay.alipaysecuritysdk.api.tool.StringTool;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class DeviceRpcResponse {
    public static final int CODE_SUCCESS = 1;
    public static final int CODE_NETWORK = 2;
    public static final int CODE_ILLEGAL = 3;
    public static final String SERVER_STATUS_ILLEGAL = "APPKEY_ERROR";
    public static final String SERVER_STATUS_SUCCESS = "CODE_SUCCESS";
    private boolean success = false;
    private String resultCode = "";
    private String apdid;
    private String token;
    private String lastTime;
    public String vkeySwitch;
    private String bugTrackSwitch;
    private String dynamicKey;
    private Map<String, String> resultData;

    public int getStatus() {
        if (this.isSuccess()) {
            return 1;
        }
        if (SERVER_STATUS_ILLEGAL.equals(this.getResultCode())) {
            return 3;
        }
        return 2;
    }

    public String getApseDegrade() {
        return MapTool.getString(this.resultData, "apse_degrade");
    }

    public String getWebRtcUrl() {
        return MapTool.getString(this.resultData, "webrtcUrl");
    }

    public String getTimeInterval() {
        return MapTool.getString(this.resultData, "timeInterval");
    }

    public String getResultDataToJson() {
        return MapTool.map2jsonString(this.resultData);
    }

    public String toString() {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("success", this.success);
            jSONObject.put("token", (Object)this.token);
            jSONObject.put("apdid", (Object)this.apdid);
            jSONObject.put("lastTime", (Object)this.lastTime);
            jSONObject.put("vkeySwitch", (Object)this.vkeySwitch);
            jSONObject.put("bugTrackSwitch", (Object)this.bugTrackSwitch);
            jSONObject.put("dynamicKey", (Object)this.dynamicKey);
            jSONObject.put("resultData", (Object)MapTool.map2json(this.resultData));
            return jSONObject.toString();
        }
        catch (JSONException jSONException) {
            return "{}";
        }
    }

    public boolean isSuccess() {
        return this.success;
    }

    /*
     * WARNING - void declaration
     */
    public void setSuccess(boolean success) {
        void var1_1;
        this.success = var1_1;
    }

    public String getResultCode() {
        return this.resultCode;
    }

    /*
     * WARNING - void declaration
     */
    public void setResultCode(String resultCode) {
        void var1_1;
        this.resultCode = var1_1;
    }

    public String getApdid() {
        return this.apdid;
    }

    /*
     * WARNING - void declaration
     */
    public void setApdid(String apdid) {
        void var1_1;
        this.apdid = StringTool.getNonNullString((String)var1_1);
    }

    public String getToken() {
        return this.token;
    }

    /*
     * WARNING - void declaration
     */
    public void setToken(String token) {
        void var1_1;
        this.token = StringTool.getNonNullString((String)var1_1);
    }

    public String getLastTime() {
        return this.lastTime;
    }

    /*
     * WARNING - void declaration
     */
    public void setLastTime(String lastTime) {
        void var1_1;
        this.lastTime = StringTool.getNonNullString((String)var1_1);
    }

    public String getVkeySwitch() {
        return this.vkeySwitch;
    }

    /*
     * WARNING - void declaration
     */
    public void setVkeySwitch(String vkeySwitch) {
        void var1_1;
        this.vkeySwitch = var1_1;
    }

    public boolean getBugTrackSwitch() {
        return "1".equals(this.bugTrackSwitch);
    }

    /*
     * WARNING - void declaration
     */
    public void setBugTrackSwitch(String bugTrackSwitch) {
        if (StringTool.isNotBlank(bugTrackSwitch)) {
            if (bugTrackSwitch.length() > 0) {
                void var1_1;
                this.bugTrackSwitch = "" + var1_1.charAt(0);
                return;
            }
            this.bugTrackSwitch = "0";
            return;
        }
        this.bugTrackSwitch = "0";
    }

    public String getDynamicKey() {
        return this.dynamicKey;
    }

    /*
     * WARNING - void declaration
     */
    public void setDynamicKey(String dynamicKey) {
        void var1_1;
        this.dynamicKey = StringTool.getNonNullString((String)var1_1);
    }

    public Map<String, String> getResultData() {
        return this.resultData;
    }

    /*
     * WARNING - void declaration
     */
    public void setResultData(Map<String, String> resultData) {
        void var1_1;
        this.resultData = var1_1;
    }
}

