/*
 * Decompiled with CFR 0.152.
 */
package net.security.device.api;

import android.text.TextUtils;
import android.util.Base64;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.SimpleTimeZone;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.security.device.api.LogUtil;
import net.security.device.api.SecurityDevice;
import okhttp3.Call;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class SecurityUtil {
    private static final int MAX_TIME_OUT_CONNECT = 20;
    private static final int MAX_TIME_OUT_READ = 20;
    private static final int MAX_TIME_OUT_WRITE = 20;
    public static final int NET_EXCEPTION_CODE = -1;
    public static Field artMethodField;
    private static final OkHttpClient okHttpClient;
    private static final OkHttpClient downloadClient;

    public static String spr(String url, Map<String, String> headers, Map<String, String> parameters) {
        HashMap<String, String> paramsForPOP = new HashMap<String, String>();
        paramsForPOP.put("TimestampKeep", SecurityUtil.fd(new Date()));
        paramsForPOP.put("SignatureNonce", UUID.randomUUID().toString());
        if (parameters != null) {
            parameters.remove("Signature");
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                String k = entry.getKey();
                String v = entry.getValue();
                if (TextUtils.isEmpty((CharSequence)k) || TextUtils.isEmpty((CharSequence)v)) continue;
                paramsForPOP.put(k, v);
            }
            String version = parameters.get("Version");
            if (version != null && !version.isEmpty() && version.equals("2020-04-25")) {
                paramsForPOP.put("Timestamp", SecurityUtil.fd(new Date()));
            }
        }
        try {
            String signature = SecurityUtil.cs(paramsForPOP, "UTF-8");
            paramsForPOP.put("Signature", signature);
        }
        catch (Throwable e) {
            paramsForPOP.put("Signature", "null");
        }
        return SecurityUtil.httpPost(url, headers, paramsForPOP);
    }

    private static String fd(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        df.setTimeZone(new SimpleTimeZone(0, "GMT"));
        return df.format(date);
    }

    public static String cs(Map<String, String> parameters, String encoding) throws Exception {
        Object[] sortedKeys = parameters.keySet().toArray(new String[0]);
        Arrays.sort(sortedKeys);
        String separator = "&";
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        for (Object key : sortedKeys) {
            if (first) {
                first = false;
            } else {
                sb.append("&");
            }
            sb.append(SecurityUtil.encode((String)key, encoding)).append("=").append(SecurityUtil.encode(parameters.get(key), encoding));
        }
        StringBuilder toSign = new StringBuilder();
        toSign.append("POST").append(separator);
        toSign.append(SecurityUtil.encode("/", encoding)).append(separator);
        toSign.append(SecurityUtil.encode(sb.toString(), encoding));
        return SecurityDevice.gsRaw(toSign.toString());
    }

    private static String encode(String value, String encoding) throws UnsupportedEncodingException {
        if (value == null) {
            return null;
        }
        return URLEncoder.encode(value, encoding).replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
    }

    private static String httpPost(String url, Map<String, String> headers, Map<String, String> paramsForPOP) {
        FormBody.Builder bodyBuilder = new FormBody.Builder();
        for (Map.Entry<String, String> entry : paramsForPOP.entrySet()) {
            bodyBuilder.add(entry.getKey(), entry.getValue());
        }
        Request.Builder requestBuilder = new Request.Builder();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            String headerK = entry.getKey();
            String headerV = entry.getValue();
            requestBuilder = requestBuilder.addHeader(headerK, headerV);
        }
        Request request = requestBuilder.url(url).post((RequestBody)bodyBuilder.build()).build();
        Call call = okHttpClient.newCall(request);
        try {
            Response httpRes = call.execute();
            String resContent = "";
            ResponseBody responseBody = httpRes.body();
            if (null != responseBody) {
                resContent = responseBody.string();
            }
            return httpRes.code() + "#" + Base64.encodeToString((byte[])resContent.getBytes(), (int)2);
        }
        catch (Exception e) {
            return "-1#" + Base64.encodeToString((byte[])e.getMessage().getBytes(), (int)2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int dw(String url, String savePath) {
        int ret = -1;
        if (url.isEmpty() || savePath.isEmpty()) {
            return ret;
        }
        File fileTmp = new File(savePath);
        if (!fileTmp.exists()) {
            LogUtil.d("savePath not exists, start mkdir, savePath: " + savePath);
            if (!fileTmp.mkdir()) {
                LogUtil.d("mkdir savePath error, savaPath: " + savePath);
                return ret;
            }
        }
        Request request = new Request.Builder().url(url).addHeader("Connection", "close").build();
        InputStream is = null;
        FileOutputStream fos = null;
        try {
            byte[] buf = new byte[4096];
            int len = 0;
            Response response = downloadClient.newCall(request).execute();
            ResponseBody body = response.body();
            if (body == null) {
                int n = ret;
                return n;
            }
            is = body.byteStream();
            File file = new File(savePath, url.substring(url.lastIndexOf("/") + 1));
            fos = new FileOutputStream(file);
            while ((len = is.read(buf)) != -1) {
                fos.write(buf, 0, len);
            }
            fos.flush();
            ret = 0;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            int n = ret;
            return n;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException iOException) {}
        }
        return ret;
    }

    public static String gsi(String appKey) {
        if (null == appKey || appKey.isEmpty()) {
            return "";
        }
        String uuid = UUID.randomUUID().toString();
        if (uuid.isEmpty()) {
            return "";
        }
        uuid = uuid.replace("-", "");
        long nowMs = System.currentTimeMillis();
        String codePrefix = String.format("%s-%s-%d-%s", appKey, "h", nowMs, uuid);
        codePrefix = codePrefix.substring(0, codePrefix.length() - 4);
        StringBuilder sb = new StringBuilder();
        sb.append(codePrefix).append("7849478494");
        int hashCode = Math.abs(sb.toString().hashCode());
        String hashCodeStr = String.valueOf(hashCode);
        String codePostfix = null;
        codePostfix = hashCodeStr.length() > 4 ? hashCodeStr.substring(hashCodeStr.length() - 4) : (hashCodeStr.length() < 4 ? String.format("%4d", hashCode) : hashCodeStr);
        return codePrefix + codePostfix;
    }

    public static void utilInit() {
        try {
            artMethodField = SecurityUtil.getField(Method.class, "artMethod");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Field getField(Class topClass, String fieldName) {
        while (topClass != null && topClass != Object.class) {
            try {
                Field field = topClass.getDeclaredField(fieldName);
                field.setAccessible(true);
                return field;
            }
            catch (Exception exception) {
                topClass = topClass.getSuperclass();
            }
        }
        return null;
    }

    public static long getArtMethod(Member member) {
        if (artMethodField == null) {
            return 0L;
        }
        try {
            return (Long)artMethodField.get(member);
        }
        catch (IllegalAccessException e) {
            return 0L;
        }
    }

    static {
        okHttpClient = new OkHttpClient.Builder().connectTimeout(20L, TimeUnit.SECONDS).readTimeout(20L, TimeUnit.SECONDS).writeTimeout(20L, TimeUnit.SECONDS).build();
        downloadClient = new OkHttpClient();
    }
}

