/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.lds.icao;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IllegalFormatConversionException;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.scuba.tlv.TLVInputStream;
import net.sf.scuba.tlv.TLVOutputStream;
import org.jmrtd.lds.AbstractTaggedLDSFile;
import org.jmrtd.lds.LDSFileUtil;

public class COMFile
extends AbstractTaggedLDSFile {
    public static final long serialVersionUID = 2002455279067170063L;
    public static final int TAG_LIST_TAG = 92;
    public static final int VERSION_UNICODE_TAG = 24374;
    public static final int VERSION_LDS_TAG = 24321;
    public String versionLDS;
    public String updateLevelLDS;
    public String majorVersionUnicode;
    public String minorVersionUnicode;
    public String releaseLevelUnicode;
    public List<Integer> tagList;

    public COMFile(String string, String string2, String string3, String string4, String string5, int[] nArray) {
        super(96);
        this.initialize(string, string2, string3, string4, string5, nArray);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public COMFile(String object, String object2, int[] nArray) {
        super(96);
        StringTokenizer stringTokenizer;
        StringTokenizer stringTokenizer2;
        Integer n2;
        Integer n3;
        if (n3 == null) throw new IllegalArgumentException("Null versionLDS");
        if (n2 == null) throw new IllegalArgumentException("Null versionUnicode");
        Object object3 = stringTokenizer2;
        if (new StringTokenizer((String)((Object)n3), ".").countTokens() != 2) throw new IllegalArgumentException("Could not parse LDS version. Expecting 2 level version number x.y.");
        StringTokenizer stringTokenizer3 = object3;
        StringTokenizer stringTokenizer4 = stringTokenizer3;
        n3 = Integer.parseInt(stringTokenizer3.nextToken().trim());
        object3 = Integer.parseInt(stringTokenizer4.nextToken().trim());
        Object object4 = stringTokenizer;
        if (new StringTokenizer((String)((Object)n2), ".").countTokens() != 3) throw new IllegalArgumentException("Could not parse unicode version. Expecting 3 level version number x.y.z.");
        COMFile cOMFile = this;
        StringTokenizer stringTokenizer5 = object4;
        StringTokenizer stringTokenizer6 = stringTokenizer5;
        StringTokenizer stringTokenizer7 = stringTokenizer5;
        Integer n4 = Integer.parseInt(stringTokenizer5.nextToken().trim());
        n2 = Integer.parseInt(stringTokenizer7.nextToken().trim());
        object4 = Integer.parseInt(stringTokenizer6.nextToken().trim());
        String string = String.format("%02d", n3);
        String string2 = String.format("%02d", object3);
        String string3 = String.format("%02d", n4);
        String string4 = String.format("%02d", n2);
        try {
            void var3_7;
            cOMFile.initialize(string, string2, string3, string4, String.format("%02d", object4), (int[])var3_7);
            return;
        }
        catch (IllegalFormatConversionException illegalFormatConversionException) {
            throw new IllegalArgumentException("Could not parse version number", illegalFormatConversionException);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Could not parse version number", numberFormatException);
        }
    }

    public COMFile(InputStream inputStream) {
        super(96, inputStream);
    }

    private void initialize(String string, String string2, String string3, String string4, String string5, int[] nArray) {
        if (nArray != null) {
            if (string != null && string.length() == 2 && string2 != null && string2.length() == 2 && string3 != null && string3.length() == 2 && string4 != null && string4.length() == 2 && string5 != null && string5.length() == 2 && nArray != null) {
                COMFile cOMFile = this;
                this.versionLDS = string;
                this.updateLevelLDS = string2;
                this.majorVersionUnicode = string3;
                this.minorVersionUnicode = string4;
                cOMFile.releaseLevelUnicode = string5;
                cOMFile.tagList = new ArrayList<Integer>(nArray.length);
                for (int n2 : nArray) {
                    this.tagList.add(n2);
                }
                return;
            }
            throw new IllegalArgumentException();
        }
        throw new IllegalArgumentException("Null tag list");
    }

    @Override
    public void readContent(InputStream inputStream) {
        Object object;
        if (inputStream instanceof TLVInputStream) {
            inputStream = (TLVInputStream)inputStream;
            object = inputStream;
        } else {
            TLVInputStream tLVInputStream;
            object = tLVInputStream;
            tLVInputStream = new TLVInputStream(inputStream);
        }
        int n2 = object.readTag();
        if (n2 == 24321) {
            if (object.readLength() == 4) {
                COMFile cOMFile = this;
                byte[] byArray = object.readValue();
                cOMFile.versionLDS = new String(byArray, 0, 2);
                cOMFile.updateLevelLDS = new String(byArray, 2, 2);
                int n3 = object.readTag();
                if (n3 == 24374) {
                    if (object.readLength() == 6) {
                        COMFile cOMFile2 = this;
                        byte[] byArray2 = object.readValue();
                        cOMFile2.majorVersionUnicode = new String(byArray2, 0, 2);
                        cOMFile2.minorVersionUnicode = new String(byArray2, 2, 2);
                        cOMFile2.releaseLevelUnicode = new String(byArray2, 4, 2);
                        int n4 = object.readTag();
                        if (n4 == 92) {
                            Object object2 = object;
                            object2.readLength();
                            byte[] byArray3 = object2.readValue();
                            this.tagList = new ArrayList<Integer>();
                            int n5 = byArray3.length;
                            for (int i2 = 0; i2 < n5; ++i2) {
                                int n6 = byArray3[i2] & 0xFF;
                                this.tagList.add(n6);
                            }
                            return;
                        }
                        throw new IllegalArgumentException("Expected TAG_LIST_TAG (" + Integer.toHexString(92) + "), found " + Integer.toHexString(n4));
                    }
                    throw new IllegalArgumentException("Wrong length of LDS version object");
                }
                throw new IllegalArgumentException("Expected VERSION_UNICODE_TAG (" + Integer.toHexString(24374) + "), found " + Integer.toHexString(n3));
            }
            throw new IllegalArgumentException("Wrong length of LDS version object");
        }
        throw new IllegalArgumentException("Excepected VERSION_LDS_TAG (" + Integer.toHexString(24321) + "), found " + Integer.toHexString(n2));
    }

    public String getLDSVersion() {
        int n2;
        COMFile cOMFile = object;
        Object object = ((COMFile)object).versionLDS + "." + ((COMFile)object).updateLevelLDS;
        try {
            n2 = Integer.parseInt(cOMFile.versionLDS);
        }
        catch (NumberFormatException numberFormatException) {}
        int n3 = Integer.parseInt(cOMFile.updateLevelLDS);
        object = n2 + "." + n3;
        return object;
    }

    public String getUnicodeVersion() {
        int n2;
        COMFile cOMFile = object;
        Object object = ((COMFile)object).majorVersionUnicode + "." + ((COMFile)object).minorVersionUnicode + "." + ((COMFile)object).releaseLevelUnicode;
        try {
            n2 = Integer.parseInt(cOMFile.majorVersionUnicode);
        }
        catch (NumberFormatException numberFormatException) {}
        int n3 = Integer.parseInt(cOMFile.minorVersionUnicode);
        int n4 = Integer.parseInt(cOMFile.releaseLevelUnicode);
        object = n2 + "." + n3 + "." + n4;
        return object;
    }

    public int[] getTagList() {
        COMFile cOMFile = object;
        Object object = new int[cOMFile.tagList.size()];
        int n2 = 0;
        Iterator<Integer> iterator = cOMFile.tagList.iterator();
        while (iterator.hasNext()) {
            object[n2++] = iterator.next();
        }
        return object;
    }

    public void insertTag(Integer n2) {
        if (!this.tagList.contains(n2)) {
            COMFile cOMFile = this;
            cOMFile.tagList.add(n2);
            Collections.sort(cOMFile.tagList);
        }
    }

    @Override
    public void writeContent(OutputStream outputStream) {
        Object object;
        if (outputStream instanceof TLVOutputStream) {
            outputStream = (TLVOutputStream)outputStream;
            object = outputStream;
        } else {
            TLVOutputStream tLVOutputStream;
            object = tLVOutputStream;
            tLVOutputStream = new TLVOutputStream(outputStream);
        }
        Object object2 = object;
        object2.writeTag(24321);
        object2.writeValue((((COMFile)((Object)iterator)).versionLDS + ((COMFile)((Object)iterator)).updateLevelLDS).getBytes());
        object2.writeTag(24374);
        object2.writeValue((((COMFile)((Object)iterator)).majorVersionUnicode + ((COMFile)((Object)iterator)).minorVersionUnicode + ((COMFile)((Object)iterator)).releaseLevelUnicode).getBytes());
        object2.writeTag(92);
        object.writeLength(((COMFile)((Object)iterator)).tagList.size());
        Iterator<Integer> iterator = ((COMFile)((Object)iterator)).tagList.iterator();
        while (iterator.hasNext()) {
            object.write((int)((byte)((Integer)iterator.next()).intValue()));
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder;
        COMFile cOMFile = this;
        StringBuilder stringBuilder2 = stringBuilder;
        new StringBuilder().append("COMFile ");
        stringBuilder2.append("LDS " + this.versionLDS + "." + this.updateLevelLDS);
        stringBuilder2.append(", ");
        stringBuilder2.append("Unicode " + this.majorVersionUnicode + "." + this.minorVersionUnicode + "." + this.releaseLevelUnicode);
        stringBuilder2.append(", ");
        int n2 = 0;
        stringBuilder2.append("[");
        int n3 = cOMFile.tagList.size();
        Iterator<Integer> iterator = cOMFile.tagList.iterator();
        while (iterator.hasNext()) {
            stringBuilder2.append("DG" + LDSFileUtil.lookupDataGroupNumberByTag(iterator.next()));
            if (n2 < n3 - 1) {
                stringBuilder2.append(", ");
            }
            ++n2;
        }
        StringBuilder stringBuilder3 = stringBuilder2;
        stringBuilder3.append("]");
        return stringBuilder3.toString();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!object.getClass().equals(COMFile.class)) {
            return false;
        }
        object = (COMFile)object;
        return this.versionLDS.equals(((COMFile)object).versionLDS) && this.updateLevelLDS.equals(((COMFile)object).updateLevelLDS) && this.majorVersionUnicode.equals(((COMFile)object).majorVersionUnicode) && this.minorVersionUnicode.equals(((COMFile)object).minorVersionUnicode) && this.releaseLevelUnicode.equals(((COMFile)object).releaseLevelUnicode) && this.tagList.equals(((COMFile)object).tagList);
    }

    public int hashCode() {
        return this.versionLDS.hashCode() * 3 + this.updateLevelLDS.hashCode() * 5 + this.majorVersionUnicode.hashCode() * 7 + this.minorVersionUnicode.hashCode() * 11 + this.releaseLevelUnicode.hashCode() * 13 + this.tagList.hashCode() * 17;
    }
}

