/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.lds.icao;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eid_bc.bouncycastle.asn1.ASN1Encodable;
import org.eid_bc.bouncycastle.asn1.ASN1EncodableVector;
import org.eid_bc.bouncycastle.asn1.ASN1InputStream;
import org.eid_bc.bouncycastle.asn1.ASN1Set;
import org.eid_bc.bouncycastle.asn1.DLSet;
import org.jmrtd.lds.ActiveAuthenticationInfo;
import org.jmrtd.lds.ChipAuthenticationInfo;
import org.jmrtd.lds.ChipAuthenticationPublicKeyInfo;
import org.jmrtd.lds.DataGroup;
import org.jmrtd.lds.SecurityInfo;
import org.jmrtd.lds.TerminalAuthenticationInfo;

public class DG14File
extends DataGroup {
    public static final long serialVersionUID = -3536507558193769953L;
    public static final Logger LOGGER = Logger.getLogger("org.jmrtd");
    public Set<SecurityInfo> securityInfos;

    public DG14File(Collection<SecurityInfo> collection) {
        super(110);
        if (collection != null) {
            this.securityInfos = new HashSet<SecurityInfo>(collection);
            return;
        }
        throw new IllegalArgumentException("Null securityInfos");
    }

    public DG14File(InputStream inputStream) {
        super(110, inputStream);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void readContent(InputStream inputStream) {
        this.securityInfos = new HashSet<SecurityInfo>();
        inputStream = (ASN1Set)new ASN1InputStream(inputStream).readObject();
        int n2 = 0;
        while (true) {
            block6: {
                if (n2 >= inputStream.size()) {
                    return;
                }
                try {
                    SecurityInfo securityInfo = SecurityInfo.getInstance(inputStream.getObjectAt(n2).toASN1Primitive());
                    if (securityInfo == null) {
                        LOGGER.warning("Skipping this unsupported SecurityInfo");
                        break block6;
                    }
                    this.securityInfos.add(securityInfo);
                }
                catch (Exception exception) {
                    LOGGER.log(Level.WARNING, "Skipping Security Info", exception);
                }
            }
            ++n2;
        }
    }

    @Override
    public void writeContent(OutputStream outputStream) {
        ASN1EncodableVector aSN1EncodableVector;
        DG14File dG14File = dG14File2;
        DG14File dG14File2 = aSN1EncodableVector;
        aSN1EncodableVector = new ASN1EncodableVector();
        Iterator<SecurityInfo> iterator = dG14File.securityInfos.iterator();
        while (iterator.hasNext()) {
            dG14File2.add((ASN1Encodable)iterator.next().getDERObject());
        }
        outputStream.write(new DLSet((ASN1EncodableVector)dG14File2).getEncoded("DER"));
    }

    @Deprecated
    public List<TerminalAuthenticationInfo> getTerminalAuthenticationInfos() {
        ArrayList arrayList;
        DG14File dG14File = serializable;
        Serializable serializable = arrayList;
        arrayList = new ArrayList();
        for (SecurityInfo securityInfo : dG14File.securityInfos) {
            if (!(securityInfo instanceof TerminalAuthenticationInfo)) continue;
            serializable.add((TerminalAuthenticationInfo)securityInfo);
        }
        return serializable;
    }

    @Deprecated
    public List<ChipAuthenticationInfo> getChipAuthenticationInfos() {
        ArrayList arrayList;
        DG14File dG14File = serializable;
        Serializable serializable = arrayList;
        arrayList = new ArrayList();
        for (SecurityInfo securityInfo : dG14File.securityInfos) {
            if (!(securityInfo instanceof ChipAuthenticationInfo)) continue;
            securityInfo = (ChipAuthenticationInfo)securityInfo;
            serializable.add(securityInfo);
            if (((ChipAuthenticationInfo)securityInfo).getKeyId() != null) continue;
            return serializable;
        }
        return serializable;
    }

    @Deprecated
    public List<ChipAuthenticationPublicKeyInfo> getChipAuthenticationPublicKeyInfos() {
        ArrayList arrayList;
        DG14File dG14File = serializable;
        Serializable serializable = arrayList;
        arrayList = new ArrayList();
        for (SecurityInfo securityInfo : dG14File.securityInfos) {
            if (!(securityInfo instanceof ChipAuthenticationPublicKeyInfo)) continue;
            serializable.add((ChipAuthenticationPublicKeyInfo)securityInfo);
        }
        return serializable;
    }

    @Deprecated
    public List<ActiveAuthenticationInfo> getActiveAuthenticationInfos() {
        ArrayList arrayList;
        DG14File dG14File = serializable;
        Serializable serializable = arrayList;
        arrayList = new ArrayList();
        for (SecurityInfo securityInfo : dG14File.securityInfos) {
            if (!(securityInfo instanceof ActiveAuthenticationInfo)) continue;
            serializable.add((ActiveAuthenticationInfo)securityInfo);
        }
        return serializable;
    }

    public Collection<SecurityInfo> getSecurityInfos() {
        return this.securityInfos;
    }

    @Override
    public String toString() {
        return "DG14File [" + this.securityInfos.toString() + "]";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object set) {
        if (set == null) {
            return false;
        }
        if (!set.getClass().equals(DG14File.class)) {
            return false;
        }
        DG14File dG14File = set2;
        Set<SecurityInfo> set2 = (DG14File)((Object)set);
        set = dG14File.securityInfos;
        if (set == null) {
            if (((DG14File)((Object)set2)).securityInfos != null) return false;
            return true;
        }
        set2 = ((DG14File)((Object)set2)).securityInfos;
        if (set2 == null) {
            if (set != null) return false;
            return true;
        }
        boolean bl = set.equals(set2);
        return bl;
    }

    public int hashCode() {
        return this.securityInfos.hashCode() * 5 + 41;
    }
}

