/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.lds.icao;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.scuba.data.Country;

public class ICAOCountry
extends Country {
    public static final long serialVersionUID = 2942942609311086138L;
    public static final Logger LOGGER = Logger.getLogger("org.jmrtd");
    public static final ICAOCountry DE = new ICAOCountry("DE", "D<<", "Germany", "German");
    public static final ICAOCountry GBD = new ICAOCountry("GB", "GBD", "British Dependent territories citizen");
    public static final ICAOCountry GBN = new ICAOCountry("GB", "GBN", "British National (Overseas)");
    public static final ICAOCountry GBO = new ICAOCountry("GB", "GBO", "British Overseas citizen");
    public static final ICAOCountry GBP = new ICAOCountry("GB", "GBP", "British Protected person");
    public static final ICAOCountry GBS = new ICAOCountry("GB", "GBS", "British Subject");
    public static final ICAOCountry XXA = new ICAOCountry("XX", "XXA", "Stateless person", "Stateless");
    public static final ICAOCountry XXB = new ICAOCountry("XX", "XXB", "Refugee", "Refugee");
    public static final ICAOCountry XXC = new ICAOCountry("XX", "XXC", "Refugee (other)", "Refugee (other)");
    public static final ICAOCountry XXX = new ICAOCountry("XX", "XXX", "Unspecified", "Unspecified");
    public static final ICAOCountry EUE = new ICAOCountry("EU", "EUE", "Europe", "European");
    public static final ICAOCountry UNO = new ICAOCountry("UN", "UNO", "United Nations Organization");
    public static final ICAOCountry UNA = new ICAOCountry("UN", "UNA", "United Nations Agency");
    public static final ICAOCountry UNK = new ICAOCountry("UN", "UNK", "United Nations Interim Administration Mission in Kosovo");
    public static final ICAOCountry XBA = new ICAOCountry("XX", "XBA", "African Development Bank (ADB)");
    public static final ICAOCountry XIM = new ICAOCountry("XX", "XIM", "African Export-Import Bank (AFREXIM bank)");
    public static final ICAOCountry XCC = new ICAOCountry("XC", "XCC", "Carribean Community or one of its emissaries (CARICOM)");
    public static final ICAOCountry XCO = new ICAOCountry("XX", "XCO", "Common Market for Eastern an Southern Africa (COMESA)");
    public static final ICAOCountry XEC = new ICAOCountry("XX", "XEC", "Economic Community of West African States (ECOWAS)");
    public static final ICAOCountry XPO = new ICAOCountry("XP", "XPO", "International Criminal Police Organization (INTERPOL)");
    public static final ICAOCountry XOM = new ICAOCountry("XO", "XOM", "Sovereign Military Order of Malta or one of its emissaries");
    public static final ICAOCountry[] VALUES = new ICAOCountry[]{DE, GBD, GBN, GBO, GBP, GBS, XXA, XXB, XXC, XXX, EUE, UNO, UNA, UNK, XBA, XIM, XCC, XCO, XEC, XPO, XOM};
    public String name;
    public String nationality;
    public String alpha2Code;
    public String alpha3Code;

    public ICAOCountry() {
    }

    public ICAOCountry(String string, String string2, String string3) {
        String string4 = string3;
        this(string, string2, string4, string4);
    }

    public ICAOCountry(String string, String string2, String string3, String string4) {
        this.alpha2Code = string;
        this.alpha3Code = string2;
        this.name = string3;
        this.nationality = string4;
    }

    public static Country getInstance(String string) {
        ICAOCountry[] iCAOCountryArray = VALUES;
        int n2 = VALUES.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            ICAOCountry iCAOCountry = iCAOCountryArray[i2];
            if (!iCAOCountry.alpha3Code.equals(string)) continue;
            return iCAOCountry;
        }
        try {
            return Country.getInstance((String)string);
        }
        catch (Exception exception) {
            LOGGER.log(Level.FINE, "Unknown country", exception);
            throw new IllegalArgumentException("Illegal ICAO country alpha 3 code " + string);
        }
    }

    public int valueOf() {
        return -1;
    }

    public String getName() {
        return this.name;
    }

    public String getNationality() {
        return this.nationality;
    }

    public String toAlpha2Code() {
        return this.alpha2Code;
    }

    public String toAlpha3Code() {
        return this.alpha3Code;
    }
}

