/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.lds.iso19794;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.jmrtd.lds.AbstractImageInfo;
import org.jmrtd.lds.iso19794.FingerInfo;

public class FingerImageInfo
extends AbstractImageInfo {
    public static final long serialVersionUID = -6625447389275461027L;
    public static final int POSITION_UNKNOWN_FINGER = 0;
    public static final int POSITION_RIGHT_THUMB = 1;
    public static final int POSITION_RIGHT_INDEX_FINGER = 2;
    public static final int POSITION_RIGHT_MIDDLE_FINGER = 3;
    public static final int POSITION_RIGHT_RING_FINGER = 4;
    public static final int POSITION_RIGHT_LITTLE_FINGER = 5;
    public static final int POSITION_LEFT_THUMB = 6;
    public static final int POSITION_LEFT_INDEX_FINGER = 7;
    public static final int POSITION_LEFT_MIDDLE_FINGER = 8;
    public static final int POSITION_LEFT_RING_FINGER = 9;
    public static final int POSITION_LEFT_LITTLE_FINGER = 10;
    public static final int POSITION_PLAIN_RIGHT_FOUR_FINGERS = 13;
    public static final int POSITION_PLAIN_LEFT_FOUR_FINGERS = 14;
    public static final int POSITION_PLAIN_THUMBS = 15;
    public static final int POSITION_UNKNOWN_PALM = 20;
    public static final int POSITION_RIGHT_FULL_PALM = 21;
    public static final int POSITION_RIGHT_WRITER_S_PALM = 22;
    public static final int POSITION_LEFT_FULL_PALM = 23;
    public static final int POSITION_LEFT_WRITER_S_PALM = 24;
    public static final int POSITION_RIGHT_LOWER_PALM = 25;
    public static final int POSITION_RIGHT_UPPER_PALM = 26;
    public static final int POSITION_LEFT_LOWER_PALM = 27;
    public static final int POSITION_LEFT_UPPER_PALM = 28;
    public static final int POSITION_RIGHT_OTHER = 29;
    public static final int POSITION_LEFT_OTHER = 30;
    public static final int POSITION_RIGHT_INTERDIGITAL = 31;
    public static final int POSITION_RIGHT_THENAR = 32;
    public static final int POSITION_RIGHT_HYPOTHENAR = 33;
    public static final int POSITION_LEFT_INTERDIGITAL = 34;
    public static final int POSITION_LEFT_THENAR = 35;
    public static final int POSITION_LEFT_HYPOTHENAR = 36;
    public static final int IMPRESSION_TYPE_LIVE_SCAN_PLAIN = 0;
    public static final int IMPRESSION_TYPE_LIVE_SCAN_ROLLED = 1;
    public static final int IMPRESSION_TYPE_NON_LIVE_SCAN_PLAIN = 2;
    public static final int IMPRESSION_TYPE_NON_LIVE_SCAN_ROLLED = 3;
    public static final int IMPRESSION_TYPE_LATENT = 7;
    public static final int IMPRESSION_TYPE_SWIPE = 8;
    public static final int IMPRESSION_TYPE_LIVE_SCAN_CONTACTLESS = 9;
    public static final byte[] FORMAT_TYPE_VALUE = new byte[]{0, 9};
    public long recordLength;
    public int position;
    public int viewCount;
    public int viewNumber;
    public int quality;
    public int impressionType;
    public int compressionAlgorithm;

    public FingerImageInfo(int n2, int n3, int n4, int n5, int n6, int n7, int n8, InputStream inputStream, int n9, int n10) {
        long l2 = n9;
        String string = FingerInfo.toMimeType(n10);
        super(2, n7, n8, inputStream, l2, string);
        if (n5 >= 0 && n5 <= 100) {
            if (inputStream != null) {
                this.position = n2;
                this.viewCount = n3;
                this.viewNumber = n4;
                this.quality = n5;
                this.impressionType = n6;
                this.compressionAlgorithm = n10;
                this.recordLength = l2 + 14L;
                return;
            }
            throw new IllegalArgumentException("Null image");
        }
        throw new IllegalArgumentException("Quality needs to be a number between 0 and 100");
    }

    public FingerImageInfo(InputStream inputStream, int n2) {
        super(2, FingerInfo.toMimeType(n2));
        this.compressionAlgorithm = n2;
        this.compressionAlgorithm = n2;
        this.readObject(inputStream);
    }

    public static String positionToString(int n2) {
        switch (n2) {
            default: {
                return null;
            }
            case 36: {
                return "Left hypothenar";
            }
            case 35: {
                return "Left thenar";
            }
            case 34: {
                return "Left interdigital";
            }
            case 33: {
                return "Right hypothenar";
            }
            case 32: {
                return "Right thenar";
            }
            case 31: {
                return "Right interdigital";
            }
            case 30: {
                return "Left other";
            }
            case 29: {
                return "Right other";
            }
            case 28: {
                return "Left upper palm";
            }
            case 27: {
                return "Left lower palm";
            }
            case 26: {
                return "Right upper palm";
            }
            case 25: {
                return "Right lower palm";
            }
            case 24: {
                return "Left writer's palm";
            }
            case 23: {
                return "Left full palm";
            }
            case 22: {
                return "Right writer's palm";
            }
            case 21: {
                return "Right full palm";
            }
            case 20: {
                return "Unknown palm";
            }
            case 15: {
                return "Plain thumbs";
            }
            case 14: {
                return "Left four fingers";
            }
            case 13: {
                return "Right four fingers";
            }
            case 10: {
                return "Left little finger";
            }
            case 9: {
                return "Left ring finger";
            }
            case 8: {
                return "Left middle finger";
            }
            case 7: {
                return "Left index finger";
            }
            case 6: {
                return "Left thumb";
            }
            case 5: {
                return "Right little finger";
            }
            case 4: {
                return "Right ring finger";
            }
            case 3: {
                return "Right middle finger";
            }
            case 2: {
                return "Right index finger";
            }
            case 1: {
                return "Right thumb";
            }
            case 0: 
        }
        return "Unknown finger";
    }

    public static String impressionTypeToString(int n2) {
        switch (n2) {
            default: {
                return null;
            }
            case 9: {
                return "Live scan contactless";
            }
            case 8: {
                return "Swipe";
            }
            case 7: {
                return "Latent";
            }
            case 3: {
                return "Non-live scan rolled";
            }
            case 2: {
                return "Non-live scan plain";
            }
            case 1: {
                return "Live scan rolled";
            }
            case 0: 
        }
        return "Live scan plain";
    }

    public static int toBiometricSubtype(int n2) {
        switch (n2) {
            default: {
                return 0;
            }
            case 36: {
                return 2;
            }
            case 35: {
                return 2;
            }
            case 34: {
                return 2;
            }
            case 33: {
                return 1;
            }
            case 32: {
                return 1;
            }
            case 31: {
                return 1;
            }
            case 30: {
                return 2;
            }
            case 29: {
                return 1;
            }
            case 28: {
                return 2;
            }
            case 27: {
                return 2;
            }
            case 26: {
                return 1;
            }
            case 25: {
                return 1;
            }
            case 24: {
                return 2;
            }
            case 23: {
                return 2;
            }
            case 22: {
                return 0;
            }
            case 21: {
                return 1;
            }
            case 20: {
                return 0;
            }
            case 15: {
                return 4;
            }
            case 14: {
                return 2;
            }
            case 13: {
                return 1;
            }
            case 10: {
                return 22;
            }
            case 9: {
                return 18;
            }
            case 8: {
                return 14;
            }
            case 7: {
                return 10;
            }
            case 6: {
                return 6;
            }
            case 5: {
                return 21;
            }
            case 4: {
                return 17;
            }
            case 3: {
                return 13;
            }
            case 2: {
                return 9;
            }
            case 1: {
                return 5;
            }
            case 0: 
        }
        return 0;
    }

    public int getQuality() {
        return this.quality;
    }

    public int getPosition() {
        return this.position;
    }

    public int getCompressionAlgorithm() {
        return this.compressionAlgorithm;
    }

    public int getViewCount() {
        return this.viewCount;
    }

    public int getViewNumber() {
        return this.viewNumber;
    }

    public int getImpressionType() {
        return this.impressionType;
    }

    @Override
    public void readObject(InputStream inputStream) {
        DataInputStream dataInputStream;
        if (inputStream instanceof DataInputStream) {
            dataInputStream = (DataInputStream)inputStream;
        } else {
            DataInputStream dataInputStream2;
            dataInputStream = dataInputStream2;
            dataInputStream2 = new DataInputStream(inputStream);
        }
        this.recordLength = (long)dataInputStream.readInt() & 0xFFFFFFFFL;
        this.position = dataInputStream.readUnsignedByte();
        this.viewCount = dataInputStream.readUnsignedByte();
        this.viewNumber = dataInputStream.readUnsignedByte();
        this.quality = dataInputStream.readUnsignedByte();
        this.impressionType = dataInputStream.readUnsignedByte();
        this.setWidth(dataInputStream.readUnsignedShort());
        this.setHeight(dataInputStream.readUnsignedShort());
        dataInputStream.readUnsignedByte();
        this.readImage(inputStream, this.recordLength - 14L);
    }

    @Override
    public void writeObject(OutputStream outputStream) {
        OutputStream outputStream2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.writeImage(byteArrayOutputStream);
        byteArrayOutputStream.flush();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        long l2 = (long)byArray.length + 14L;
        if (outputStream instanceof DataOutputStream) {
            outputStream2 = outputStream = (DataOutputStream)outputStream;
        } else {
            DataOutputStream dataOutputStream;
            outputStream2 = dataOutputStream;
            dataOutputStream = new DataOutputStream(outputStream);
        }
        OutputStream outputStream3 = outputStream2;
        OutputStream outputStream4 = outputStream2;
        ((DataOutputStream)outputStream2).writeInt((int)(l2 & 0xFFFFFFFFL));
        ((DataOutputStream)outputStream2).writeByte(this.position);
        ((DataOutputStream)outputStream2).writeByte(this.viewCount);
        ((DataOutputStream)outputStream2).writeByte(this.viewNumber);
        ((DataOutputStream)outputStream2).writeByte(this.quality);
        ((DataOutputStream)outputStream2).writeByte(this.impressionType);
        ((DataOutputStream)outputStream2).writeShort(this.getWidth());
        ((DataOutputStream)outputStream4).writeShort(this.getHeight());
        ((DataOutputStream)outputStream4).writeByte(0);
        ((FilterOutputStream)outputStream3).write(byArray);
        ((DataOutputStream)outputStream3).flush();
    }

    @Override
    public long getRecordLength() {
        return this.recordLength;
    }

    public byte[] getFormatType() {
        return FORMAT_TYPE_VALUE;
    }

    public int getBiometricSubtype() {
        return FingerImageInfo.toBiometricSubtype(this.position);
    }

    @Override
    public int hashCode() {
        long l2 = this.recordLength;
        return ((((((super.hashCode() * 31 + this.compressionAlgorithm) * 31 + this.impressionType) * 31 + this.position) * 31 + this.quality) * 31 + (int)(l2 ^ l2 >>> 32)) * 31 + this.viewCount) * 31 + this.viewNumber;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (FingerImageInfo.class != object.getClass()) {
            return false;
        }
        object = (FingerImageInfo)object;
        return this.compressionAlgorithm == ((FingerImageInfo)object).compressionAlgorithm && this.impressionType == ((FingerImageInfo)object).impressionType && this.position == ((FingerImageInfo)object).position && this.quality == ((FingerImageInfo)object).quality && this.recordLength == ((FingerImageInfo)object).recordLength && this.viewCount == ((FingerImageInfo)object).viewCount && this.viewNumber == ((FingerImageInfo)object).viewNumber;
    }

    @Override
    public String toString() {
        return "FingerImageInfo [quality: " + this.quality + ", position: " + FingerImageInfo.positionToString(this.position) + ", impression type: " + FingerImageInfo.impressionTypeToString(this.impressionType) + ", horizontal line length: " + this.getWidth() + ", vertical line length: " + this.getHeight() + ", image: " + this.getWidth() + " x " + this.getHeight() + " \"" + FingerInfo.toMimeType(this.compressionAlgorithm) + "\"]";
    }
}

