/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.protocol;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.scuba.smartcards.APDUWrapper;
import net.sf.scuba.smartcards.CardService;
import net.sf.scuba.smartcards.CardServiceException;
import net.sf.scuba.smartcards.CommandAPDU;
import net.sf.scuba.tlv.TLVUtil;
import org.jmrtd.APDULevelEACCACapable;
import org.jmrtd.Util;
import org.jmrtd.protocol.SecureMessagingAPDUSender;

public class EACCAAPDUSender
implements APDULevelEACCACapable {
    public static final Logger LOGGER = Logger.getLogger("org.jmrtd.protocol");
    public static final byte INS_BSI_GENERAL_AUTHENTICATE = -122;
    public SecureMessagingAPDUSender secureMessagingSender;

    public EACCAAPDUSender(CardService cardService) {
        this.secureMessagingSender = new SecureMessagingAPDUSender(cardService);
    }

    @Override
    public synchronized byte[] sendInternalAuthenticate(APDUWrapper aPDUWrapper, byte[] byArray) {
        if (byArray != null && byArray.length == 8) {
            CommandAPDU commandAPDU;
            EACCAAPDUSender eACCAAPDUSender = eACCAAPDUSender2;
            EACCAAPDUSender eACCAAPDUSender2 = commandAPDU;
            commandAPDU = new CommandAPDU(0, -120, 0, 0, byArray, 256);
            return eACCAAPDUSender.secureMessagingSender.transmit(aPDUWrapper, (CommandAPDU)eACCAAPDUSender2).getData();
        }
        throw new IllegalArgumentException("rndIFD wrong length");
    }

    @Override
    public synchronized void sendMSEKAT(APDUWrapper aPDUWrapper, byte[] byArray, byte[] byArray2) {
        CommandAPDU commandAPDU;
        int n2 = byArray.length;
        int n3 = byArray2 != null ? byArray2.length : 0;
        byte[] byArray3 = new byte[n2 + n3];
        n3 = byArray.length;
        System.arraycopy(byArray, 0, byArray3, 0, n3);
        if (byArray2 != null) {
            int n4 = byArray.length;
            int n5 = byArray2.length;
            System.arraycopy(byArray2, 0, byArray3, n4, n5);
        }
        EACCAAPDUSender eACCAAPDUSender = eACCAAPDUSender2;
        EACCAAPDUSender eACCAAPDUSender2 = commandAPDU;
        commandAPDU = new CommandAPDU(0, 34, 65, 166, byArray3);
        short s2 = (short)eACCAAPDUSender.secureMessagingSender.transmit(aPDUWrapper, (CommandAPDU)eACCAAPDUSender2).getSW();
        if (s2 == -28672) {
            return;
        }
        throw new CardServiceException("Sending MSE KAT failed", (int)s2);
    }

    @Override
    public synchronized void sendMSESetATIntAuth(APDUWrapper aPDUWrapper, String object, BigInteger object2) {
        EACCAAPDUSender eACCAAPDUSender;
        int n2 = 65;
        int n3 = 164;
        if (object2 != null && ((BigInteger)object2).compareTo(BigInteger.ZERO) >= 0) {
            CommandAPDU commandAPDU;
            ByteArrayOutputStream byteArrayOutputStream;
            object = Util.toOIDBytes((String)object);
            object2 = TLVUtil.wrapDO((int)132, (byte[])Util.i2os((BigInteger)object2));
            ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
            byteArrayOutputStream2();
            try {
                byteArrayOutputStream2.write((byte[])object);
                byteArrayOutputStream.write((byte[])object2);
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, "Exception", iOException);
            }
            EACCAAPDUSender eACCAAPDUSender2 = eACCAAPDUSender;
            eACCAAPDUSender = commandAPDU;
            object = byteArrayOutputStream2.toByteArray();
            commandAPDU = new CommandAPDU(0, 34, n2, n3, (byte[])object);
            eACCAAPDUSender = eACCAAPDUSender2.secureMessagingSender.transmit(aPDUWrapper, (CommandAPDU)eACCAAPDUSender);
        } else {
            CommandAPDU commandAPDU;
            EACCAAPDUSender eACCAAPDUSender3 = eACCAAPDUSender;
            eACCAAPDUSender = commandAPDU;
            object = Util.toOIDBytes((String)object);
            commandAPDU = new CommandAPDU(0, 34, 65, 164, (byte[])object);
            eACCAAPDUSender = eACCAAPDUSender3.secureMessagingSender.transmit(aPDUWrapper, (CommandAPDU)eACCAAPDUSender);
        }
        int n4 = eACCAAPDUSender == null ? -1 : (int)((short)eACCAAPDUSender.getSW());
        if (n4 == -28672) {
            return;
        }
        throw new CardServiceException("Sending MSE AT failed", n4);
    }

    @Override
    public synchronized byte[] sendGeneralAuthenticate(APDUWrapper aPDUWrapper, byte[] byArray, boolean bl) {
        int n2 = bl ? 0 : 16;
        CommandAPDU commandAPDU = new CommandAPDU(n2, -122, 0, 0, byArray = TLVUtil.wrapDO((int)124, (byte[])byArray), 256);
        EACCAAPDUSender eACCAAPDUSender = eACCAAPDUSender.secureMessagingSender.transmit(aPDUWrapper, commandAPDU);
        short s2 = (short)eACCAAPDUSender.getSW();
        if (s2 == -28672) {
            return TLVUtil.unwrapDO((int)124, (byte[])eACCAAPDUSender.getData());
        }
        throw new CardServiceException("Sending general authenticate failed", (int)s2);
    }
}

