/*
 * Decompiled with CFR 0.152.
 */
package net.security.device.api.id.oaid;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.IBinder;
import android.os.Parcel;
import net.security.device.api.LogUtil;
import net.security.device.api.id.IOAID;
import net.security.device.api.id.IOAIDGetter;

public class MsaImpl
implements IOAID {
    private final Context context;

    public MsaImpl(Context context) {
        this.context = context;
    }

    @Override
    public boolean supportOAID() {
        if (this.context == null) {
            return false;
        }
        try {
            PackageManager pm = this.context.getPackageManager();
            if (pm != null) {
                PackageInfo pi = pm.getPackageInfo("com.mdid.msa", 0);
                return pi != null;
            }
        }
        catch (Exception e) {
            LogUtil.e(e.toString());
        }
        return false;
    }

    @Override
    public void doGet(final IOAIDGetter getter) {
        if (this.context == null) {
            getter.onOAIDGetError(new NullPointerException("OAID context is null"));
            return;
        }
        this.startMsaKlService();
        Intent intent = new Intent("com.bun.msa.action.bindto.service");
        intent.setClassName("com.mdid.msa", "com.mdid.msa.service.MsaIdService");
        intent.putExtra("com.bun.msa.param.pkgname", this.context.getPackageName());
        try {
            boolean isBinded = this.context.bindService(intent, new ServiceConnection(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onServiceConnected(ComponentName name, IBinder service) {
                    LogUtil.d("MsaIdService connected");
                    try {
                        String oaid = null;
                        Parcel obtain = Parcel.obtain();
                        Parcel obtain2 = Parcel.obtain();
                        try {
                            obtain.writeInterfaceToken("com.bun.lib.MsaIdInterface");
                            if (service.transact(3, obtain, obtain2, 0)) {
                                obtain2.readException();
                                oaid = obtain2.readString();
                            }
                            if (oaid == null || oaid.length() == 0) {
                                throw new RuntimeException("Msa oaid get failed");
                            }
                            getter.onOAIDGetComplete(oaid);
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                        finally {
                            obtain.recycle();
                            obtain2.recycle();
                            MsaImpl.this.context.unbindService((ServiceConnection)this);
                        }
                    }
                    catch (Exception e) {
                        LogUtil.e(e.toString());
                        getter.onOAIDGetError(e);
                    }
                }

                public void onServiceDisconnected(ComponentName name) {
                    LogUtil.d("MsaIdService disconnected");
                }
            }, 1);
            if (!isBinded) {
                throw new RuntimeException("MsaIdService bind failed");
            }
        }
        catch (Exception e) {
            getter.onOAIDGetError(e);
        }
    }

    private void startMsaKlService() {
        if (this.context == null) {
            return;
        }
        try {
            Intent intent = new Intent("com.bun.msa.action.start.service");
            intent.setClassName("com.mdid.msa", "com.mdid.msa.service.MsaKlService");
            intent.putExtra("com.bun.msa.param.pkgname", this.context.getPackageName());
            intent.putExtra("com.bun.msa.param.runinset", true);
            this.context.startService(intent);
        }
        catch (Exception e) {
            LogUtil.e(e.toString());
        }
    }
}

