/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.protocol;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.util.Arrays;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.sf.scuba.smartcards.CardServiceException;
import net.sf.scuba.tlv.TLVInputStream;
import net.sf.scuba.tlv.TLVOutputStream;
import net.sf.scuba.tlv.TLVUtil;
import net.sf.scuba.util.Hex;
import org.eid_bc.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.eid_bc.bouncycastle.math.ec.ECPoint;
import org.jmrtd.APDULevelPACECapable;
import org.jmrtd.AccessKeySpec;
import org.jmrtd.BACKeySpec;
import org.jmrtd.PACEException;
import org.jmrtd.PACEKeySpec;
import org.jmrtd.PACESecretKeySpec;
import org.jmrtd.Util;
import org.jmrtd.lds.PACEInfo;
import org.jmrtd.protocol.AESSecureMessagingWrapper;
import org.jmrtd.protocol.DESedeSecureMessagingWrapper;
import org.jmrtd.protocol.PACECAMResult;
import org.jmrtd.protocol.PACEGMMappingResult;
import org.jmrtd.protocol.PACEGMWithDHMappingResult;
import org.jmrtd.protocol.PACEGMWithECDHMappingResult;
import org.jmrtd.protocol.PACEIMMappingResult;
import org.jmrtd.protocol.PACEMappingResult;
import org.jmrtd.protocol.PACEResult;
import org.jmrtd.protocol.SecureMessagingWrapper;

public class PACEProtocol {
    public static final Logger LOGGER = Logger.getLogger("org.jmrtd");
    public static final Provider BC_PROVIDER = Util.getBouncyCastleProvider();
    public static final byte[] IV_FOR_PACE_CAM_DECRYPTION = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    public static final byte[] C0_LENGTH_128 = new byte[]{-90, 104, -119, 42, 124, 65, -29, -54, 115, -97, 64, -80, 87, -40, 89, 4};
    public static final byte[] C1_LENGTH_128 = new byte[]{-92, -31, 54, -84, 114, 95, 115, -117, 1, -63, -10, 2, 23, -63, -120, -83};
    public static final byte[] C0_LENGTH_256 = new byte[]{-44, 99, -42, 82, 52, 18, 78, -9, -119, 112, 84, -104, 109, -54, 10, 23, 78, 40, -33, 117, -116, -70, -96, 63, 36, 6, 22, 65, 77, 90, 22, 118};
    public static final byte[] C1_LENGTH_256 = new byte[]{84, -67, 114, 85, -16, -86, -8, 49, -66, -61, 66, 63, -49, 57, -42, -101, 108, -65, 6, 102, 119, -48, -6, -82, 90, -83, -39, -99, -8, -27, 53, 23};
    public APDULevelPACECapable service;
    public SecureMessagingWrapper wrapper;
    public int maxTranceiveLength;
    public boolean shouldCheckMAC;
    public Random random;

    public PACEProtocol(APDULevelPACECapable aPDULevelPACECapable, SecureMessagingWrapper secureMessagingWrapper, int n2, boolean bl) {
        PACEProtocol pACEProtocol = this;
        this.service = aPDULevelPACECapable;
        this.wrapper = secureMessagingWrapper;
        this.maxTranceiveLength = n2;
        pACEProtocol.shouldCheckMAC = bl;
        pACEProtocol.random = new SecureRandom();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PACEResult doPACE(AccessKeySpec accessKeySpec, SecretKey serializable, String object, AlgorithmParameterSpec object2) {
        Cipher cipher;
        byte[] byArray;
        byte[] byArray2;
        byte[] byArray3;
        PACEMappingResult pACEMappingResult;
        PACEInfo.MappingType mappingType;
        void v4;
        PACEProtocol pACEProtocol;
        PACEProtocol pACEProtocol2;
        byte by;
        SecretKey secretKey;
        Object object3;
        KeyPair keyPair;
        Object object4;
        void v0 = object4;
        PACEInfo.MappingType mappingType2 = PACEInfo.toMappingType((String)v0);
        String string = PACEInfo.toKeyAgreementAlgorithm((String)v0);
        String string2 = PACEInfo.toCipherAlgorithm((String)object4);
        String string3 = PACEInfo.toDigestAlgorithm((String)object4);
        int n2 = PACEInfo.toKeyLength((String)object4);
        this.checkConsistency(string, string2, string3, n2, (AlgorithmParameterSpec)((Object)keyPair));
        try {
            object3 = Cipher.getInstance(string2 + "/CBC/NoPadding");
            secretKey = null;
            by = 1;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new PACEException("PCD side error in static cipher construction during key derivation step", generalSecurityException);
        }
        try {
            if (serializable instanceof PACESecretKeySpec) {
                by = ((PACESecretKeySpec)serializable).getKeyReference();
            }
            PACEProtocol pACEProtocol3 = this;
            pACEProtocol2 = pACEProtocol3;
            pACEProtocol = pACEProtocol3;
            v4 = object4;
            mappingType = mappingType2;
            this.service.sendMSESetATMutualAuth(this.wrapper, (String)object4, by, (byte[])secretKey);
            pACEMappingResult = this.doPACEStep2(mappingType2, string, (AlgorithmParameterSpec)((Object)keyPair), this.doPACEStep1((SecretKey)serializable, (Cipher)object3), (Cipher)object3);
            object4 = pACEMappingResult.getEphemeralParameters();
            keyPair = this.doPACEStep3GenerateKeyPair(string, (AlgorithmParameterSpec)object4);
            object4 = this.doPACEStep3ExchangePublicKeys(keyPair.getPublic(), (AlgorithmParameterSpec)object4);
            byArray3 = this.doPACEStep3KeyAgreement(string, keyPair.getPrivate(), (PublicKey)object4);
        }
        catch (CardServiceException cardServiceException) {
            int n3 = cardServiceException.getSW();
            throw new PACEException("PICC side error in static PACE key derivation step", cardServiceException, n3);
        }
        object3 = byArray3;
        try {
            object3 = Util.deriveKey((byte[])object3, string2, n2, 1);
            secretKey = Util.deriveKey(byArray3, string2, n2, 2);
            byArray2 = pACEProtocol2.doPACEStep4((String)v4, mappingType, keyPair, (PublicKey)object4, secretKey);
            byArray = null;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new PACEException("Security exception during secure messaging key derivation", generalSecurityException);
        }
        try {
            long l2 = pACEProtocol.wrapper == null ? 0L : this.wrapper.getSendSequenceCounter();
            if (string2.startsWith("DESede")) {
                this.wrapper = new DESedeSecureMessagingWrapper((SecretKey)object3, secretKey, this.maxTranceiveLength, this.shouldCheckMAC, 0L);
            } else if (string2.startsWith("AES")) {
                this.wrapper = new AESSecureMessagingWrapper((SecretKey)object3, secretKey, this.maxTranceiveLength, this.shouldCheckMAC, l2);
            } else {
                LOGGER.warning("Unsupported cipher algorithm " + string2);
            }
            if (!PACEInfo.MappingType.CAM.equals((Object)mappingType2)) return new PACEResult(accessKeySpec, mappingType2, string, string2, string3, n2, pACEMappingResult, keyPair, (PublicKey)object4, this.wrapper);
            if (byArray2 == null) {
                LOGGER.warning("Encrypted Chip Authentication data is null");
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IllegalStateException("Security exception in secure messaging establishment", generalSecurityException);
        }
        try {
            cipher = Cipher.getInstance("AES/CBC/NoPadding");
        }
        catch (GeneralSecurityException generalSecurityException) {
            LOGGER.log(Level.WARNING, "Could not decrypt Chip Authentication data", generalSecurityException);
            return new PACECAMResult(accessKeySpec, string, string2, string3, n2, pACEMappingResult, keyPair, (PublicKey)object4, byArray2, byArray, this.wrapper);
        }
        {
            cipher.init(2, (Key)object3, new IvParameterSpec(IV_FOR_PACE_CAM_DECRYPTION));
            byArray = Util.unpad(cipher.doFinal(byArray2));
            return new PACECAMResult(accessKeySpec, string, string2, string3, n2, pACEMappingResult, keyPair, (PublicKey)object4, byArray2, byArray, this.wrapper);
        }
    }

    public static SecretKey deriveStaticPACEKey(AccessKeySpec accessKeySpec, String string) {
        AccessKeySpec accessKeySpec2 = accessKeySpec;
        String string2 = string;
        string = PACEInfo.toCipherAlgorithm(string2);
        int n2 = PACEInfo.toKeyLength(string2);
        byte[] byArray = PACEProtocol.computeKeySeedForPACE(accessKeySpec2);
        byte by = 0;
        if (accessKeySpec2 instanceof PACEKeySpec) {
            by = ((PACEKeySpec)accessKeySpec).getKeyReference();
        }
        return Util.deriveKey(byArray, string, n2, null, 3, by);
    }

    public static byte[] computeKeySeedForPACE(AccessKeySpec object) {
        if (object != null) {
            if (object instanceof BACKeySpec) {
                object = (BACKeySpec)object;
                String string = object.getDocumentNumber();
                String string2 = object.getDateOfBirth();
                object = object.getDateOfExpiry();
                if (string2 != null && string2.length() == 6) {
                    if (object != null && ((String)object).length() == 6) {
                        if (string != null) {
                            return PACEProtocol.computeKeySeedForPACE(PACEProtocol.fixDocumentNumber(string), string2, (String)object);
                        }
                        throw new IllegalArgumentException("Wrong document number. Found " + string);
                    }
                    throw new IllegalArgumentException("Wrong date format used for date of expiry. Expected yyMMdd, found " + (String)object);
                }
                throw new IllegalArgumentException("Wrong date format used for date of birth. Expected yyMMdd, found " + string2);
            }
            if (object instanceof PACEKeySpec) {
                return ((PACEKeySpec)object).getKey();
            }
            LOGGER.warning("JMRTD doesn't recognize this type of access key, best effort key derivation!");
            return object.getKey();
        }
        throw new IllegalArgumentException("Access key cannot be null");
    }

    public static ECParameterSpec mapNonceGMWithECDH(byte[] object, java.security.spec.ECPoint object2, ECParameterSpec eCParameterSpec) {
        ECFieldFp eCFieldFp;
        EllipticCurve ellipticCurve;
        byte[] byArray = object;
        ECParameterSpec eCParameterSpec2 = eCParameterSpec;
        object = eCParameterSpec2.getGenerator();
        EllipticCurve ellipticCurve2 = eCParameterSpec2.getCurve();
        BigInteger bigInteger = ellipticCurve2.getA();
        BigInteger bigInteger2 = ellipticCurve2.getB();
        BigInteger bigInteger3 = ((ECFieldFp)ellipticCurve2.getField()).getP();
        BigInteger bigInteger4 = eCParameterSpec2.getOrder();
        int n2 = eCParameterSpec2.getCofactor();
        java.security.spec.ECPoint eCPoint = Util.add(Util.multiply(Util.os2i(byArray), (java.security.spec.ECPoint)object, eCParameterSpec), (java.security.spec.ECPoint)object2, eCParameterSpec);
        object = eCPoint;
        if (!Util.toBouncyCastleECPoint(eCPoint, eCParameterSpec).isValid()) {
            LOGGER.info("ephemeralGenerator is not a valid point");
        }
        object2 = ellipticCurve;
        Object object3 = object;
        object = eCFieldFp;
        object(bigInteger3);
        ((EllipticCurve)object2)(eCFieldFp, bigInteger, bigInteger2);
        return new ECParameterSpec(ellipticCurve, (java.security.spec.ECPoint)object3, bigInteger4, n2);
    }

    public static DHParameterSpec mapNonceGMWithDH(byte[] object, BigInteger bigInteger, DHParameterSpec dHParameterSpec) {
        DHParameterSpec dHParameterSpec2 = dHParameterSpec;
        BigInteger bigInteger2 = dHParameterSpec2.getP();
        object = dHParameterSpec2.getG().modPow(Util.os2i(object), bigInteger2).multiply(bigInteger).mod(bigInteger2);
        return new DHParameterSpec(bigInteger2, (BigInteger)object, dHParameterSpec.getL());
    }

    public static AlgorithmParameterSpec mapNonceIMWithECDH(byte[] object, byte[] object2, String string, ECParameterSpec object3) {
        ECFieldFp eCFieldFp;
        EllipticCurve ellipticCurve;
        byte[] byArray = object;
        byte[] byArray2 = object2;
        BigInteger bigInteger = Util.getPrime((AlgorithmParameterSpec)object3);
        object = bigInteger;
        ECParameterSpec eCParameterSpec = object3;
        object2 = eCParameterSpec.getOrder();
        int n2 = eCParameterSpec.getCofactor();
        BigInteger bigInteger2 = eCParameterSpec.getCurve().getA();
        BigInteger bigInteger3 = eCParameterSpec.getCurve().getB();
        object3 = PACEProtocol.icartPointEncode(Util.os2i(PACEProtocol.pseudoRandomFunction(byArray, byArray2, bigInteger, string)), (ECParameterSpec)object3);
        EllipticCurve ellipticCurve2 = ellipticCurve;
        Object object4 = object2;
        object2 = eCFieldFp;
        object2((BigInteger)object);
        ellipticCurve2(eCFieldFp, bigInteger2, bigInteger3);
        return new ECParameterSpec(ellipticCurve, (java.security.spec.ECPoint)object3, (BigInteger)object4, n2);
    }

    public static AlgorithmParameterSpec mapNonceIMWithDH(byte[] object, byte[] byArray, String string, DHParameterSpec dHParameterSpec) {
        BigInteger bigInteger = dHParameterSpec.getG();
        if (bigInteger != null && !bigInteger.equals(BigInteger.ONE)) {
            DHParameterSpec dHParameterSpec2 = dHParameterSpec;
            bigInteger = dHParameterSpec2.getP();
            BigInteger bigInteger2 = dHParameterSpec2 instanceof PACEInfo.DHCParameterSpec ? ((PACEInfo.DHCParameterSpec)dHParameterSpec).getQ() : BigInteger.ONE;
            object = Util.os2i(PACEProtocol.pseudoRandomFunction(object, byArray, bigInteger, string)).modPow(bigInteger.subtract(BigInteger.ONE).divide(bigInteger2), bigInteger);
            return new DHParameterSpec(bigInteger, (BigInteger)object, dHParameterSpec.getL());
        }
        throw new IllegalArgumentException("Invalid generator: " + bigInteger);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] pseudoRandomFunction(byte[] byArray, byte[] object, BigInteger bigInteger, String string) {
        Throwable throwable2222222;
        block16: {
            Object object2;
            ByteArrayOutputStream byteArrayOutputStream;
            SecretKeySpec secretKeySpec;
            IvParameterSpec ivParameterSpec;
            byte[] byArray2;
            byte[] byArray3;
            if (byArray == null) throw new IllegalArgumentException("Null nonce");
            if (object == null) throw new IllegalArgumentException("Null nonce");
            int n2 = byArray.length * 8;
            int n3 = ((byte[])object).length * 8;
            if (n2 != 128) {
                if (n2 != 192) {
                    if (n2 != 256) throw new IllegalArgumentException("Unknown length " + n2 + ", was expecting 128, 192, or 256");
                }
                byArray3 = C0_LENGTH_256;
                byArray2 = C1_LENGTH_256;
            } else {
                byArray3 = C0_LENGTH_128;
                byArray2 = C1_LENGTH_128;
            }
            Object object3 = new StringBuilder().append(string);
            Object object4 = string.endsWith("/CBC/NoPadding") ? "" : "/CBC/NoPadding";
            Object object5 = object3 = Cipher.getInstance(((StringBuilder)object3).append((String)object4).toString());
            int n4 = ((Cipher)object5).getBlockSize();
            object4 = ivParameterSpec;
            ivParameterSpec = new IvParameterSpec(new byte[n4]);
            Object object6 = secretKeySpec;
            secretKeySpec = new SecretKeySpec((byte[])object, string);
            ((Cipher)object5).init(1, (Key)object6, (AlgorithmParameterSpec)object4);
            object6 = ((Cipher)object3).doFinal(byArray);
            object = byteArrayOutputStream;
            byteArrayOutputStream = new ByteArrayOutputStream();
            int n5 = 0;
            while (true) {
                if (n5 * n2 >= bigInteger.bitLength() + 64) break;
                Object object7 = object;
                Object object8 = object3;
                byte[] byArray4 = byArray2;
                Object object9 = object3;
                byte[] byArray5 = byArray3;
                Object object10 = object3;
                int n6 = 1;
                {
                    byte[] byArray6;
                    Object object11;
                    catch (Throwable throwable2222222) {
                        break block16;
                    }
                    catch (Exception exception) {}
                    {
                        Object object12 = object;
                        object11 = object12;
                        LOGGER.log(Level.WARNING, "Could not write to stream", exception);
                        byArray6 = Util.i2os(Util.os2i(((ByteArrayOutputStream)object12).toByteArray()).mod(bigInteger));
                    }
                    try {
                        ((ByteArrayOutputStream)object11).close();
                        return byArray6;
                    }
                    catch (IOException iOException) {
                        LOGGER.log(Level.FINE, "Could not close stream", iOException);
                    }
                    return byArray6;
                }
                {
                    ((Cipher)object10).init(n6, (Key)new SecretKeySpec((byte[])object6, 0, n3 / 8, string), (AlgorithmParameterSpec)object4);
                    object6 = ((Cipher)object9).doFinal(byArray5);
                    ((OutputStream)object7).write(((Cipher)object8).doFinal(byArray4));
                    ++n5;
                    continue;
                }
                break;
            }
            {
                Object object13 = object;
                object2 = object13;
                object6 = Util.i2os(Util.os2i(((ByteArrayOutputStream)object13).toByteArray()).mod(bigInteger));
            }
            try {
                ((ByteArrayOutputStream)object2).close();
                return object6;
            }
            catch (IOException iOException) {
                LOGGER.log(Level.FINE, "Could not close stream", iOException);
            }
            return object6;
        }
        try {
            ((ByteArrayOutputStream)object).close();
            throw throwable2222222;
        }
        catch (IOException iOException) {
            LOGGER.log(Level.FINE, "Could not close stream", iOException);
        }
        throw throwable2222222;
    }

    public static java.security.spec.ECPoint icartPointEncode(BigInteger object, ECParameterSpec eCParameterSpec) {
        ECParameterSpec eCParameterSpec2 = eCParameterSpec;
        BigInteger bigInteger = Util.getPrime(eCParameterSpec2);
        int n2 = eCParameterSpec2.getCofactor();
        Object object2 = eCParameterSpec2.getCurve().getA();
        BigInteger bigInteger2 = eCParameterSpec2.getCurve().getB();
        BigInteger bigInteger3 = ((BigInteger)object).modPow(BigInteger.valueOf(2L), bigInteger).negate().mod(bigInteger);
        BigInteger bigInteger4 = bigInteger3.add(bigInteger3.modPow(BigInteger.valueOf(2L), bigInteger)).mod(bigInteger);
        BigInteger bigInteger5 = BigInteger.ONE.add(bigInteger4);
        BigInteger bigInteger6 = bigInteger.subtract(BigInteger.ONE).subtract(BigInteger.ONE);
        bigInteger4 = bigInteger2.negate().multiply(bigInteger5).multiply(((BigInteger)object2).multiply(bigInteger4).modPow(bigInteger6, bigInteger)).mod(bigInteger);
        bigInteger3 = bigInteger3.multiply(bigInteger4).mod(bigInteger);
        object2 = bigInteger4.modPow(BigInteger.valueOf(3L), bigInteger).add(((BigInteger)object2).multiply(bigInteger4)).add(bigInteger2).mod(bigInteger);
        BigInteger bigInteger7 = bigInteger;
        object = ((BigInteger)object).modPow(BigInteger.valueOf(3L), bigInteger).multiply((BigInteger)object2).mod(bigInteger);
        bigInteger2 = bigInteger7.add(BigInteger.ONE).multiply(BigInteger.valueOf(4L).modInverse(bigInteger)).mod(bigInteger);
        bigInteger2 = ((BigInteger)object2).modPow(bigInteger7.subtract(BigInteger.ONE).subtract(bigInteger2), bigInteger);
        if (bigInteger2.modPow(BigInteger.valueOf(2L), bigInteger).multiply((BigInteger)object2).mod(bigInteger).equals(BigInteger.ONE)) {
            java.security.spec.ECPoint eCPoint;
            object = eCPoint;
            eCPoint = new java.security.spec.ECPoint(bigInteger4, bigInteger2.multiply((BigInteger)object2).mod(bigInteger));
            object2 = object;
        } else {
            java.security.spec.ECPoint eCPoint;
            object2 = eCPoint;
            eCPoint = new java.security.spec.ECPoint(bigInteger3, bigInteger2.multiply((BigInteger)object).mod(bigInteger));
        }
        if (n2 == 1) {
            return Util.normalize((java.security.spec.ECPoint)object2, eCParameterSpec);
        }
        ECPoint eCPoint = Util.toBouncyCastleECPoint((java.security.spec.ECPoint)object2, eCParameterSpec);
        eCPoint.multiply(BigInteger.valueOf(n2));
        return Util.fromBouncyCastleECPoint(eCPoint);
    }

    public static PublicKey updateParameterSpec(PublicKey publicKey, PrivateKey privateKey) {
        if (publicKey instanceof ECPublicKey && privateKey instanceof ECPrivateKey) {
            return KeyFactory.getInstance("EC", BC_PROVIDER).generatePublic(new ECPublicKeySpec(((ECPublicKey)publicKey).getW(), ((ECPrivateKey)privateKey).getParams()));
        }
        throw new NoSuchAlgorithmException("Unsupported key type");
    }

    public static byte[] generateAuthenticationToken(String string, SecretKey secretKey, PublicKey publicKey) {
        String string2 = string;
        return PACEProtocol.generateAuthenticationToken(string2, Util.getMac(PACEProtocol.inferMACAlgorithmFromCipherAlgorithm(PACEInfo.toCipherAlgorithm(string2)), secretKey), publicKey);
    }

    public static byte[] computeKeySeedForPACE(String string) {
        return Util.computeKeySeed(string, "SHA-1", false);
    }

    public static byte[] encodePublicKeyDataObject(String string, PublicKey publicKey) {
        return PACEProtocol.encodePublicKeyDataObject(string, publicKey, true);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] encodePublicKeyDataObject(String object, PublicKey serializable, boolean bl) {
        Throwable throwable222222;
        TLVOutputStream tLVOutputStream;
        block15: {
            block14: {
                TLVOutputStream tLVOutputStream2;
                ByteArrayOutputStream byteArrayOutputStream;
                ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
                byteArrayOutputStream = new ByteArrayOutputStream();
                tLVOutputStream = tLVOutputStream2;
                new TLVOutputStream((OutputStream)byteArrayOutputStream2).writeTag(32585);
                if (serializable instanceof DHPublicKey) {
                    boolean bl2 = bl;
                    DHPublicKey dHPublicKey = (DHPublicKey)serializable;
                    DHParameterSpec dHParameterSpec = dHPublicKey.getParams();
                    serializable = dHParameterSpec.getP();
                    bl = dHParameterSpec.getL();
                    BigInteger bigInteger = dHParameterSpec.getG();
                    BigInteger bigInteger2 = dHPublicKey.getY();
                    tLVOutputStream.write(new ASN1ObjectIdentifier((String)object).getEncoded());
                    if (!bl2) {
                        TLVOutputStream tLVOutputStream3 = tLVOutputStream;
                        TLVOutputStream tLVOutputStream4 = tLVOutputStream;
                        tLVOutputStream.writeTag(129);
                        tLVOutputStream4.writeValue(Util.i2os((BigInteger)serializable));
                        tLVOutputStream4.writeTag(130);
                        tLVOutputStream3.writeValue(Util.i2os(BigInteger.valueOf((long)bl)));
                        tLVOutputStream3.writeTag(131);
                        tLVOutputStream.writeValue(Util.i2os(bigInteger));
                    }
                    tLVOutputStream.writeTag(132);
                    tLVOutputStream.writeValue(Util.i2os(bigInteger2));
                } else {
                    if (!(serializable instanceof ECPublicKey)) break block14;
                    ECPublicKey eCPublicKey = (ECPublicKey)serializable;
                    ECParameterSpec eCParameterSpec = eCPublicKey.getParams();
                    serializable = Util.getPrime(eCParameterSpec);
                    EllipticCurve ellipticCurve = eCParameterSpec.getCurve();
                    BigInteger bigInteger = ellipticCurve.getA();
                    BigInteger bigInteger3 = ellipticCurve.getB();
                    java.security.spec.ECPoint eCPoint = eCParameterSpec.getGenerator();
                    BigInteger bigInteger4 = eCParameterSpec.getOrder();
                    int n2 = eCParameterSpec.getCofactor();
                    java.security.spec.ECPoint eCPoint2 = eCPublicKey.getW();
                    tLVOutputStream.write(new ASN1ObjectIdentifier((String)object).getEncoded());
                    if (!bl) {
                        TLVOutputStream tLVOutputStream5 = tLVOutputStream;
                        java.security.spec.ECPoint eCPoint3 = eCPoint;
                        TLVOutputStream tLVOutputStream6 = tLVOutputStream;
                        TLVOutputStream tLVOutputStream7 = tLVOutputStream;
                        tLVOutputStream.writeTag(129);
                        tLVOutputStream7.writeValue(Util.i2os((BigInteger)serializable));
                        tLVOutputStream7.writeTag(130);
                        tLVOutputStream6.writeValue(Util.i2os(bigInteger));
                        tLVOutputStream6.writeTag(131);
                        tLVOutputStream.writeValue(Util.i2os(bigInteger3));
                        object = eCPoint3.getAffineX();
                        serializable = eCPoint3.getAffineY();
                        tLVOutputStream5.writeTag(132);
                        tLVOutputStream5.write(Util.i2os((BigInteger)object));
                        tLVOutputStream5.write(Util.i2os((BigInteger)serializable));
                        tLVOutputStream5.writeValueEnd();
                        tLVOutputStream5.writeTag(133);
                        tLVOutputStream.writeValue(Util.i2os(bigInteger4));
                    }
                    tLVOutputStream.writeTag(134);
                    tLVOutputStream.writeValue(Util.ecPoint2OS(eCPoint2));
                    if (!bl) {
                        tLVOutputStream.writeTag(135);
                        tLVOutputStream.writeValue(Util.i2os(BigInteger.valueOf(n2)));
                    }
                }
                TLVOutputStream tLVOutputStream8 = tLVOutputStream;
                TLVOutputStream tLVOutputStream9 = tLVOutputStream8;
                tLVOutputStream8.writeValueEnd();
                tLVOutputStream8.flush();
                try {
                    tLVOutputStream9.close();
                    return byteArrayOutputStream2.toByteArray();
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.FINE, "Error closing stream", iOException);
                }
                return byteArrayOutputStream2.toByteArray();
            }
            try {
                throw new InvalidKeyException("Unsupported public key: " + serializable.getClass().getCanonicalName());
            }
            catch (Throwable throwable222222) {
                break block15;
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, "Exception", iOException);
                throw new IllegalStateException("Error in encoding public key");
            }
        }
        try {
            tLVOutputStream.close();
            throw throwable222222;
        }
        catch (IOException iOException) {
            LOGGER.log(Level.FINE, "Error closing stream", iOException);
        }
        throw throwable222222;
    }

    public static byte[] encodePublicKeyForSmartCard(PublicKey publicKey) {
        if (publicKey != null) {
            if (publicKey instanceof ECPublicKey) {
                ByteArrayOutputStream byteArrayOutputStream;
                publicKey = (ECPublicKey)publicKey;
                ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
                try {
                    byteArrayOutputStream2();
                    byteArrayOutputStream.write(Util.ecPoint2OS(publicKey.getW()));
                    byte[] byArray = byteArrayOutputStream.toByteArray();
                    byteArrayOutputStream2.close();
                    return byArray;
                }
                catch (IOException iOException) {
                    throw new IllegalStateException("Internal error writing to memory", iOException);
                }
            }
            if (publicKey instanceof DHPublicKey) {
                return Util.i2os(((DHPublicKey)publicKey).getY());
            }
            throw new InvalidKeyException("Unsupported public key: " + publicKey.getClass().getCanonicalName());
        }
        throw new IllegalArgumentException("Cannot encode null public key");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public static PublicKey decodePublicKeyFromSmartCard(byte[] object, AlgorithmParameterSpec algorithmParameterSpec) {
        block12: {
            PublicKey publicKey;
            DataInputStream dataInputStream;
            if (algorithmParameterSpec == null) throw new IllegalArgumentException("Params cannot be null");
            if (algorithmParameterSpec instanceof ECParameterSpec) {
                object = Util.os2ECPoint(object);
                algorithmParameterSpec = (ECParameterSpec)algorithmParameterSpec;
                return Util.getPublicKey("EC", new ECPublicKeySpec((java.security.spec.ECPoint)object, (ECParameterSpec)algorithmParameterSpec));
            }
            if (!(algorithmParameterSpec instanceof DHParameterSpec)) throw new IllegalArgumentException("Expected ECParameterSpec or DHParameterSpec, found " + algorithmParameterSpec.getClass().getCanonicalName());
            DataInputStream dataInputStream2 = dataInputStream;
            dataInputStream = new DataInputStream(new ByteArrayInputStream((byte[])object));
            try {
                if (dataInputStream.read() != 4) break block12;
                byte[] byArray = new byte[((byte[])object).length - 1];
                dataInputStream2.readFully(byArray);
                object = Util.os2i(byArray);
                algorithmParameterSpec = (DHParameterSpec)algorithmParameterSpec;
                publicKey = Util.getPublicKey("DH", new DHPublicKeySpec((BigInteger)object, ((DHParameterSpec)algorithmParameterSpec).getP(), ((DHParameterSpec)algorithmParameterSpec).getG()));
            }
            catch (Throwable throwable) {
                try {
                    dataInputStream2.close();
                    throw throwable;
                }
                catch (GeneralSecurityException generalSecurityException) {
                    LOGGER.log(Level.WARNING, "Exception", generalSecurityException);
                    throw new IllegalArgumentException(generalSecurityException);
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.WARNING, "Exception", iOException);
                    throw new IllegalArgumentException(iOException);
                }
            }
            dataInputStream2.close();
            return publicKey;
        }
        throw new IllegalArgumentException("Expected encoded public key to start with 0x04");
    }

    public static byte[] generateAuthenticationToken(String object, Mac object2, PublicKey publicKey) {
        object = ((Mac)object2).doFinal(PACEProtocol.encodePublicKeyDataObject((String)object, publicKey));
        byte[] byArray = new byte[8];
        object2 = byArray;
        int n2 = ((Object)object2).length;
        System.arraycopy(object, 0, object2, 0, n2);
        return byArray;
    }

    public static String fixDocumentNumber(String string) {
        string = string.replace('<', ' ').trim().replace(' ', '<');
        while (string.length() < 9) {
            string = string + "<";
        }
        return string;
    }

    public static byte[] computeKeySeedForPACE(String string, String string2, String string3) {
        return Util.computeKeySeed(string, string2, string3, "SHA-1", false);
    }

    private void checkConsistency(String string, String string2, String string3, int n2, AlgorithmParameterSpec algorithmParameterSpec) {
        if (string != null) {
            if (!"ECDH".equalsIgnoreCase(string) && !"DH".equalsIgnoreCase(string)) {
                throw new IllegalArgumentException("Unsupported agreement algorithm, expected ECDH or DH, found \"" + string + "\"");
            }
            if (string2 != null) {
                if (!"DESede".equalsIgnoreCase(string2) && !"AES".equalsIgnoreCase(string2)) {
                    throw new IllegalArgumentException("Unsupported cipher algorithm, expected DESede or AES, found \"" + string2 + "\"");
                }
                if (!("SHA-1".equalsIgnoreCase(string3) || "SHA1".equalsIgnoreCase(string3) || "SHA-256".equalsIgnoreCase(string3) || "SHA256".equalsIgnoreCase(string3))) {
                    throw new IllegalArgumentException("Unsupported cipher algorithm, expected DESede or AES, found \"" + string3 + "\"");
                }
                if (n2 != 128 && n2 != 192 && n2 != 256) {
                    throw new IllegalArgumentException("Unsupported key length, expected 128, 192, or 256, found " + n2);
                }
                if ("ECDH".equalsIgnoreCase(string) && !(algorithmParameterSpec instanceof ECParameterSpec)) {
                    throw new IllegalArgumentException("Expected ECParameterSpec for agreement algorithm \"" + string + "\", found " + algorithmParameterSpec.getClass().getCanonicalName());
                }
                if ("DH".equalsIgnoreCase(string) && !(algorithmParameterSpec instanceof DHParameterSpec)) {
                    throw new IllegalArgumentException("Expected DHParameterSpec for agreement algorithm \"" + string + "\", found " + algorithmParameterSpec.getClass().getCanonicalName());
                }
                return;
            }
            throw new IllegalArgumentException("Unknown cipher algorithm");
        }
        throw new IllegalArgumentException("Unknown agreement algorithm");
    }

    public static String inferMACAlgorithmFromCipherAlgorithm(String string) {
        if (string != null) {
            if (string.startsWith("DESede")) {
                return "ISO9797ALG3WITHISO7816-4PADDING";
            }
            if (string.startsWith("AES")) {
                return "AESCMAC";
            }
            throw new InvalidAlgorithmParameterException("Cannot infer MAC algorithm from cipher algorithm \"" + string + "\"");
        }
        throw new IllegalArgumentException("Cannot infer MAC algorithm from cipher algorithm null");
    }

    public PACEResult doPACE(AccessKeySpec accessKeySpec, String string, AlgorithmParameterSpec algorithmParameterSpec) {
        try {
            AccessKeySpec accessKeySpec2 = accessKeySpec;
            return this.doPACE(accessKeySpec2, PACEProtocol.deriveStaticPACEKey(accessKeySpec2, string), string, algorithmParameterSpec);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new PACEException("PCD side error in key derivation step", generalSecurityException);
        }
    }

    public byte[] doPACEStep1(SecretKey secretKey, Cipher cipher) {
        Cipher cipher2 = cipher;
        PACEProtocol pACEProtocol = this;
        byte[] byArray = new byte[]{};
        byte[] byArray2 = TLVUtil.unwrapDO((int)128, (byte[])pACEProtocol.service.sendGeneralAuthenticate(this.wrapper, byArray, false));
        try {
            cipher.init(2, (Key)secretKey, new IvParameterSpec(new byte[cipher.getBlockSize()]));
            return cipher2.doFinal(byArray2);
        }
        catch (CardServiceException cardServiceException) {
            throw new PACEException("PICC side exception in tranceiving nonce step", cardServiceException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new PACEException("PCD side exception in tranceiving nonce step", generalSecurityException);
        }
    }

    public PACEMappingResult doPACEStep2(PACEInfo.MappingType mappingType, String string, AlgorithmParameterSpec algorithmParameterSpec, byte[] byArray, Cipher cipher) {
        int n2 = mappingType.ordinal();
        if (n2 != 1 && n2 != 2) {
            if (n2 == 3) {
                return this.doPACEStep2IM(string, algorithmParameterSpec, byArray, cipher);
            }
            throw new PACEException("Unsupported mapping type " + (Object)((Object)mappingType));
        }
        return this.doPACEStep2GM(string, algorithmParameterSpec, byArray);
    }

    /*
     * Unable to fully structure code
     */
    public PACEGMMappingResult doPACEStep2GM(String var1_3, AlgorithmParameterSpec var2_4, byte[] var3_5) {
        v0 = this;
        v1 = KeyPairGenerator.getInstance((String)var1_3, PACEProtocol.BC_PROVIDER);
        v1.initialize(var2_4);
        var4_6 = v1.generateKeyPair();
        v2 = var4_6.getPublic();
        var5_7 = var4_6.getPrivate();
        var6_8 = TLVUtil.wrapDO((int)129, (byte[])PACEProtocol.encodePublicKeyForSmartCard(v2));
        this = PACEProtocol.decodePublicKeyFromSmartCard(TLVUtil.unwrapDO((int)130, (byte[])v0.service.sendGeneralAuthenticate(this.wrapper, var6_8, false)), var2_4);
        if (!"ECDH".equals(var1_3)) ** GOTO lbl26
        v3 = var3_5;
        var1_3 = v4;
        var1_3();
        var1_3.init((PrivateKey)var5_7);
        var1_3 = v4.doPhase(this);
        var5_7 = PACEProtocol.mapNonceGMWithECDH(v3, (java.security.spec.ECPoint)var1_3, (ECParameterSpec)var2_4);
        return new PACEGMWithECDHMappingResult(var2_4, var3_5, this, var4_6, (java.security.spec.ECPoint)var1_3, (AlgorithmParameterSpec)var5_7);
lbl26:
        // 1 sources

        if (!"DH".equals(var1_3)) ** GOTO lbl41
        v5 = var3_5;
        v6 = KeyAgreement.getInstance((String)var1_3);
        v6.init((Key)var5_7);
        v6.doPhase(this, true);
        v7 = v6.generateSecret();
        var1_3 = v7;
        var5_7 = PACEProtocol.mapNonceGMWithDH(v5, Util.os2i(v7), (DHParameterSpec)var2_4);
        try {
            return new PACEGMWithDHMappingResult(var2_4, var3_5, this, var4_6, (byte[])var1_3, (AlgorithmParameterSpec)var5_7);
lbl41:
            // 1 sources

            throw new IllegalArgumentException("Unsupported parameters for mapping nonce, expected \"ECDH\" / ECParameterSpec or \"DH\" / DHParameterSpec, found \"" + (String)var1_3 + "\" /" + var2_4.getClass().getCanonicalName());
        }
        catch (CardServiceException var0_1) {
            throw new PACEException("PICC side exception in mapping nonce step", var0_1);
        }
        catch (GeneralSecurityException var0_2) {
            throw new PACEException("PCD side error in mapping nonce step", var0_2);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PACEIMMappingResult doPACEStep2IM(String string, AlgorithmParameterSpec algorithmParameterSpec, byte[] byArray, Cipher cipher) {
        byte[] byArray2;
        try {
            PACEProtocol pACEProtocol = object;
            byArray2 = new byte[byArray.length];
            pACEProtocol.random.nextBytes(byArray2);
            byte[] byArray3 = TLVUtil.wrapDO((int)129, (byte[])byArray2);
            pACEProtocol.service.sendGeneralAuthenticate(((PACEProtocol)object).wrapper, byArray3, false);
        }
        catch (CardServiceException cardServiceException) {
            int n2 = cardServiceException.getSW();
            throw new PACEException("PICC side exception in mapping nonce step", cardServiceException, n2);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new PACEException("PCD side error in mapping nonce step", generalSecurityException);
        }
        {
            Object object;
            if ("ECDH".equals(string)) {
                object = PACEProtocol.mapNonceIMWithECDH(byArray, byArray2, cipher.getAlgorithm(), (ECParameterSpec)algorithmParameterSpec);
                return new PACEIMMappingResult(algorithmParameterSpec, byArray, byArray2, (AlgorithmParameterSpec)object);
            }
            if ("DH".equals(string)) {
                object = PACEProtocol.mapNonceIMWithDH(byArray, byArray2, cipher.getAlgorithm(), (DHParameterSpec)algorithmParameterSpec);
                return new PACEIMMappingResult(algorithmParameterSpec, byArray, byArray2, (AlgorithmParameterSpec)object);
            }
            throw new IllegalArgumentException("Unsupported parameters for mapping nonce, expected \"ECDH\" / ECParameterSpec or \"DH\" / DHParameterSpec, found \"" + string + "\" /" + algorithmParameterSpec.getClass().getCanonicalName());
        }
    }

    public KeyPair doPACEStep3GenerateKeyPair(String string, AlgorithmParameterSpec algorithmParameterSpec) {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(string, BC_PROVIDER);
            keyPairGenerator.initialize(algorithmParameterSpec);
            return keyPairGenerator.generateKeyPair();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new PACEException("PCD side error during generation of PCD key pair", generalSecurityException);
        }
    }

    public PublicKey doPACEStep3ExchangePublicKeys(PublicKey object, AlgorithmParameterSpec algorithmParameterSpec) {
        block7: {
            PublicKey publicKey = object;
            PACEProtocol pACEProtocol = publicKey2;
            object = TLVUtil.wrapDO((int)131, (byte[])PACEProtocol.encodePublicKeyForSmartCard((PublicKey)object));
            PublicKey publicKey2 = PACEProtocol.decodePublicKeyFromSmartCard(TLVUtil.unwrapDO((int)132, (byte[])pACEProtocol.service.sendGeneralAuthenticate(((PACEProtocol)((Object)publicKey2)).wrapper, (byte[])object, false)), algorithmParameterSpec);
            if (publicKey.equals(publicKey2)) break block7;
            return publicKey2;
        }
        try {
            throw new PACEException("PCD's public key and PICC's public key are the same in key agreement step!");
        }
        catch (CardServiceException cardServiceException) {
            int n2 = cardServiceException.getSW();
            throw new PACEException("PICC side exception in key agreement step", cardServiceException, n2);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new PACEException("PCD side exception in key agreement step", generalSecurityException);
        }
        catch (IllegalStateException illegalStateException) {
            throw new PACEException("PCD side exception in key agreement step", illegalStateException);
        }
    }

    public byte[] doPACEStep3KeyAgreement(String string, PrivateKey privateKey, PublicKey publicKey) {
        try {
            KeyAgreement keyAgreement = KeyAgreement.getInstance(string, BC_PROVIDER);
        }
        catch (GeneralSecurityException generalSecurityException) {
            LOGGER.log(Level.WARNING, "PCD side error during key agreement", generalSecurityException);
            throw new PACEException("PCD side error during key agreement");
        }
        keyAgreement.init(privateKey);
        keyAgreement.doPhase(PACEProtocol.updateParameterSpec(publicKey, privateKey), true);
        return keyAgreement.generateSecret();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] doPACEStep4(String var1_11, PACEInfo.MappingType var2_15, KeyPair var3_16, PublicKey var4_17, SecretKey var5_18) {
        var4_17 = TLVUtil.wrapDO((int)133, (byte[])PACEProtocol.generateAuthenticationToken((String)var1_11, var5_18, (PublicKey)var4_17));
        this = this.service.sendGeneralAuthenticate(this.wrapper, (byte[])var4_17, true);
        var4_17 = v0;
        v0 = new TLVInputStream((InputStream)new ByteArrayInputStream((byte[])this));
        var0_1 = v0.readTag();
        if (var0_1 != 134) {
            PACEProtocol.LOGGER.warning("Was expecting tag 0x86, found: " + Integer.toHexString(var0_1));
        }
        v1 = var1_11;
        v2 = var5_18;
        v3 = var3_16;
        v4 = var4_17;
        v5 = v4;
        v4.readLength();
        var0_2 = v5.readValue();
        v6 = PACEProtocol.generateAuthenticationToken((String)v1, v2, v3.getPublic());
        var1_11 = v6;
        if (!Arrays.equals(v6, var0_2)) ** GOTO lbl53
        if (var2_15 != PACEInfo.MappingType.CAM) ** GOTO lbl44
        var0_3 = var4_17.readTag();
        if (var0_3 == 138) ** GOTO lbl30
        PACEProtocol.LOGGER.warning("Was expecting tag 0x8A, found: " + Integer.toHexString(var0_3));
lbl30:
        // 2 sources

        v7 = var4_17;
        v8 = v7;
        v9 = v7;
        v7.readLength();
        this = v9.readValue();
        try {
            v8.close();
            return this;
        }
        catch (IOException var1_12) {
            PACEProtocol.LOGGER.log(Level.FINE, "Exception closing stream", var1_12);
        }
        return this;
lbl44:
        // 1 sources

        try {
            var4_17.close();
            return null;
        }
        catch (IOException var0_4) {
            block27: {
                v10 = PACEProtocol.LOGGER;
                v11 = Level.FINE;
                break block27;
lbl53:
                // 3 sources

                throw new GeneralSecurityException("PICC authentication token mismatch, expectedPICCToken = " + Hex.bytesToHexString((byte[])var1_11) + ", piccToken = " + Hex.bytesToHexString((byte[])var0_2));
            }
lbl55:
            // 2 sources

            while (true) {
                v10.log(v11, "Exception closing stream", (Throwable)var0_5);
                return null;
            }
        }
        catch (Throwable var0_6) {
            ** GOTO lbl70
        }
        catch (IOException var0_7) {
            PACEProtocol.LOGGER.log(Level.WARNING, "Could not parse step 4 response", var0_7);
            try {
                try {
                    var4_17.close();
                    return null;
                }
                catch (IOException var0_8) {
                    v10 = PACEProtocol.LOGGER;
                    v11 = Level.FINE;
                    ** continue;
                }
lbl70:
                // 1 sources

                try {
                    var4_17.close();
                    throw var0_6;
                }
                catch (IOException var1_13) {
                    PACEProtocol.LOGGER.log(Level.FINE, "Exception closing stream", var1_13);
                }
                throw var0_6;
            }
            catch (CardServiceException var0_9) {
                var1_14 = var0_9.getSW();
                throw new PACEException("PICC side exception in authentication token generation step", var0_9, var1_14);
            }
            catch (GeneralSecurityException var0_10) {
                throw new PACEException("PCD side exception in authentication token generation step", var0_10);
            }
        }
    }
}

