/*
 * Decompiled with CFR 0.152.
 */
package com.dtf.wish.ui;

import android.content.Context;
import android.text.Html;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.dtf.face.camera.utils.DisplayUtil;
import com.dtf.face.ui.overlay.CommAlertOverlay;
import com.dtf.face.ui.toyger.FaceShowFragment;
import com.dtf.wish.R;
import com.dtf.wish.api.IDTWishFragment;
import com.dtf.wish.widget.RecordingProgress;
import com.dtf.wish.widget.VoiceView;
import com.dtf.wish.widget.WishRecordView;
import com.dtf.wish.widget.WishStepLayout;
import java.util.ArrayList;
import java.util.List;
import wishverify.i;

public class WishFragment
extends FaceShowFragment
implements IDTWishFragment {
    public TextView mTopTitle;
    public TextView mWishTipsText;
    public TextView mReadText;
    public VoiceView voiceView;
    public TextView voiceTipsView;
    public WishStepLayout stepView;
    public WishRecordView mRecordingBtn;
    public TextView mWishTipTitle;
    public RecordingProgress mRecordingProgress;
    public IDTWishFragment.IWishCallBack wishCallBack;
    public IDTWishFragment.Item currentItem;
    public List<IDTWishFragment.Item> currentWishItems;
    public IDTWishFragment.WishMode currentWishMode;
    public List<IDTWishFragment.Wish> wishes;
    public int currentWishIndex;
    public LinearLayout mVoiceRegisterLayout;
    public TextView mReadCode;
    public WishRecordView.a touchListener = new WishRecordView.a(){

        @Override
        public void onStartRecord() {
            if (WishFragment.this.hasShowMessageBox()) {
                return;
            }
            if (WishFragment.this.wishCallBack.startRecordWish()) {
                WishFragment.this.changeUIToRecord();
            }
        }

        @Override
        public void onEndRecord() {
            if (WishFragment.this.wishCallBack.endRecordWish()) {
                WishFragment.this.changeUIToWait();
            }
        }
    };

    public int getLayoutID() {
        return R.layout.dtf_layout_wish;
    }

    public void initView() {
        WishFragment wishFragment = this;
        super.initView();
        wishFragment.mTopTitle = (TextView)wishFragment.findViewById(R.id.top_bar_title);
        wishFragment.mWishTipTitle = (TextView)wishFragment.findViewById(R.id.wish_tip_title);
        wishFragment.mWishTipsText = (TextView)wishFragment.findViewById(R.id.wish_tip_text_view);
        wishFragment.mReadText = (TextView)wishFragment.findViewById(R.id.read_text);
        wishFragment.voiceView = (VoiceView)wishFragment.findViewById(R.id.voice_view);
        wishFragment.voiceTipsView = (TextView)wishFragment.findViewById(R.id.voice_tips_view);
        wishFragment.voiceView.a();
        wishFragment.mRecordingBtn = (WishRecordView)wishFragment.findViewById(R.id.recording_btn);
        wishFragment.mRecordingBtn.setRecordCallBack(this.touchListener);
        wishFragment.mRecordingProgress = (RecordingProgress)wishFragment.findViewById(R.id.recording_progress);
        wishFragment.stepView = (WishStepLayout)wishFragment.findViewById(R.id.step_view);
        wishFragment.mRecordingProgress.a();
        wishFragment.mVoiceRegisterLayout = (LinearLayout)wishFragment.findViewById(R.id.voice_register_layout);
        wishFragment.mReadCode = (TextView)wishFragment.findViewById(R.id.read_code);
        if (wishFragment.getActivity() != null) {
            ((CommAlertOverlay)this.findViewById(R.id.message_box_overlay)).updateStyle(20, 18, 20, 20);
        }
    }

    public void changeUIToRecord() {
        WishFragment wishFragment = string2;
        String string2 = wishFragment.getResString(R.string.dtf_wish_recording);
        wishFragment.mWishTipTitle.setText((CharSequence)string2);
        wishFragment.mRecordingBtn.setText(string2);
        wishFragment.voiceView.setVisibility(0);
        wishFragment.voiceView.b();
        wishFragment.voiceTipsView.setText(R.string.dtf_wish_voice_record_tips);
        wishFragment.wishCallBack.startRecordWish();
    }

    public void changeUIToWait() {
        WishFragment wishFragment = this;
        wishFragment.voiceTipsView.setText(R.string.dtf_wish_voice_quiet_tips);
        wishFragment.mRecordingBtn.setText(this.getResString(R.string.dtf_wish_hold_record));
        wishFragment.voiceView.c();
        wishFragment.voiceView.setVisibility(8);
        wishFragment.mWishTipTitle.setText((CharSequence)this.getResString(R.string.dtf_wish_record_tips));
    }

    @Override
    public void onWishContentUpdate(IDTWishFragment.WishContent wishContent) {
        this.wishes = wishContent.getWishes();
    }

    @Override
    public void onWishVerify(int n2) {
        if (n2 >= 0) {
            this.currentWishIndex = n2;
            Object object = this.wishes.get(this.currentWishIndex);
            if (object != null) {
                ArrayList arrayList;
                this.currentWishMode = ((IDTWishFragment.Wish)object).getWishMode();
                this.mTopTitle.setText((CharSequence)((IDTWishFragment.Wish)object).getWishTitle());
                this.currentWishItems = ((IDTWishFragment.Wish)object).getContent();
                object = arrayList;
                arrayList = new ArrayList();
                for (int i2 = 0; i2 < this.currentWishItems.size(); ++i2) {
                    IDTWishFragment.Item item = this.currentWishItems.get(i2);
                    if (i2 == 0) {
                        this.currentItem = item;
                    }
                    object.add(i.a((Context)this.getActivity(), this.currentWishMode) + i.a((Context)this.getActivity(), i2));
                }
                WishFragment wishFragment = this;
                wishFragment.stepView.setStepTitles((List<String>)object);
                object = wishFragment.currentItem;
                if (object != null) {
                    this.updateWishItem((IDTWishFragment.Item)object);
                }
            }
        }
    }

    @Override
    public void onWishItemVerify(int n2) {
        if (n2 >= 0 && this.currentWishItems.get(n2) != null) {
            WishFragment wishFragment = this;
            wishFragment.currentItem = wishFragment.currentWishItems.get(n2);
            wishFragment.updateWishItem(wishFragment.currentItem);
        }
    }

    @Override
    public void onWishItemCompleted(int n2) {
        if (n2 < this.currentWishItems.size()) {
            this.stepView.a();
        }
    }

    @Override
    public void onWishItemReset() {
        IDTWishFragment.Item item = this.currentItem;
        if (item != null) {
            this.updateWishItem(item);
        }
        this.changeUIToWait();
    }

    @Override
    public void onWishStatusEnable() {
        this.mRecordingBtn.setEnabled(true);
    }

    @Override
    public void onWishStatusDisable() {
        this.mRecordingBtn.setEnabled(false);
    }

    @Override
    public void setWishTriggerCallBack(IDTWishFragment.IWishCallBack iWishCallBack) {
        this.wishCallBack = iWishCallBack;
    }

    public void onTimeChanged(int n2, int n3) {
        this.updateWishItemTimeTips(n2 - 1, true);
    }

    public void onCameraSizeChanged(double d2, double d3) {
        WishFragment wishFragment = this;
        super.onCameraSizeChanged(d2, d3);
        View view = wishFragment.findViewById(R.id.toyger_face_circle_hole_view);
        if (view != null && (this = this.findViewById(R.id.wish_tip_container)) != null) {
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.getLayoutParams();
            int n2 = view.getWidth() > view.getHeight() ? view.getHeight() : view.getWidth();
            layoutParams.topMargin = DisplayUtil.dip2px((Context)this.getContext(), (float)15.0f) + n2;
        }
    }

    public void updateWishItemTimeTips(int n2, boolean bl) {
        String string2 = this.currentItem.getAnswerTitle();
        String string3 = "%\u65f6\u95f4%";
        String string4 = bl ? i.a(Integer.toString(n2)) : String.valueOf(n2);
        string4 = string2.replace(string3, string4);
        if (this.currentItem.getAnswerType() != null) {
            String string5 = this.currentItem.getAnswerType();
            string4 = string4.replace(string5, i.a(string5));
        }
        this.mWishTipsText.setText((CharSequence)Html.fromHtml((String)string4));
    }

    public void updateWishItem(IDTWishFragment.Item object) {
        if (object != null) {
            IDTWishFragment.Item item = object;
            ((WishFragment)((Object)string5)).updateWishItemTimeTips(((IDTWishFragment.Item)object).getTime(), false);
            object = item.getQuestion();
            String string2 = item.getAnswerType();
            if (string2 != null) {
                String string3 = string2;
                String string4 = i.a(string3);
                if (((String)object).contains(string3)) {
                    WishFragment wishFragment = string5;
                    String string5 = ((String)object).replace(string2, string4);
                    wishFragment.mReadText.setText((CharSequence)Html.fromHtml((String)string5));
                    return;
                }
            }
            if (IDTWishFragment.WishMode.REGISTER_MODE == ((WishFragment)((Object)string5)).currentWishMode) {
                WishFragment wishFragment = string5;
                wishFragment.mVoiceRegisterLayout.setVisibility(0);
                wishFragment.mReadText.setVisibility(8);
                wishFragment.mReadCode.setText((CharSequence)object);
            } else {
                WishFragment wishFragment = string5;
                wishFragment.mVoiceRegisterLayout.setVisibility(8);
                wishFragment.mReadText.setVisibility(0);
                wishFragment.mReadText.setText((CharSequence)object);
            }
            ((WishFragment)((Object)string5)).mWishTipTitle.setText((CharSequence)((WishFragment)((Object)string5)).getResString(R.string.dtf_wish_record_tips));
        }
    }

    public String getResString(int n2) {
        return this.mRootView.getContext().getString(n2);
    }

    public void onRetry(int n2) {
        super.onRetry(n2);
    }

    public void onVerifyBegin() {
        WishFragment wishFragment = this;
        super.onVerifyBegin();
        RecordingProgress recordingProgress = wishFragment.mRecordingProgress;
        if (recordingProgress != null) {
            recordingProgress.setVisibility(4);
            this.mRecordingProgress.b();
        }
    }

    public void onVerifyEnd() {
        super.onVerifyEnd();
    }

    public void onDestroy() {
        WishFragment wishFragment = recordingProgress;
        super.onDestroy();
        RecordingProgress recordingProgress = wishFragment.mRecordingProgress;
        if (recordingProgress != null) {
            recordingProgress.b();
        }
    }
}

