/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.alipaysecuritysdk.common.exception;

public class ErrorCode {
    private static final int LINE_NUMBER_MASK = 1023;
    private static final int MAJOR_MASK = 511;
    private static final int MINOR_MASK = 4095;
    public static final int E_TA_TIMEOUT = 108;
    public static final int E_UNSUPPORT_DEVICE = 301;
    public static final int E_VOS_NOT_START = 302;
    public static final int E_T0_NOT_START = 303;
    public static final int E_KERNEL_BIN_NOT_EXIST = 304;
    public static final int E_KERNEL_BIN_TOO_LARGE = 305;
    public static final int E_LEVEL_DB_WORK_DIR = 306;
    public static final int E_OPERATIONTYPE_EMPTY = 307;
    public static final int E_SIGN_ERROR = 308;
    public static final int E_T0_HANDLE_INVALID = 309;
    public static final int E_VOS_UPDATE_TRUSTTIME = 310;
    public static final int E_BUSY = 311;
    public static final int E_CRASHED_BEFORE = 312;
    public static final int E_TA_DEGRADE = 313;
    public static final int E_T0_DATA_DELETE = 314;
    public static final int E_APP_HOOKED = 314;
    public static final int E_TA_CRASHED_BEFORE = 401;
    public static final int E_SO_LOAD_FAILED = 402;
    public static final int E_DL_CRASHED_BEFORE = 403;
    public static final int E_INVALID_ARGUMENT = 404;
    public static final int E_INVALID_APP_CONTEXT = 405;
    public static final int E_T0_INIT_FAILED = 406;

    public static int build(int errorCode) {
        int n2;
        if (errorCode < 0) {
            return Integer.MIN_VALUE | errorCode;
        }
        if (errorCode == 0) {
            return 0;
        }
        return (0 | (0x1FF & n2) << 12 | 0) & Integer.MAX_VALUE;
    }

    public static String errorCodeToString(int errorCode) {
        int n2;
        if (errorCode == 0) {
            return "OK";
        }
        int n3 = errorCode & 0xFFF;
        int n4 = errorCode >> 12 & 0x1FF;
        n2 = n2 >> 21 & 0x3FF;
        return "errorInfo:line=" + n2 + ",major=" + n4 + ",minor=" + n3;
    }

    public static boolean isTimeout(int errorCode) {
        int n2;
        if (errorCode == 0) {
            return false;
        }
        return (n2 >> 12 & 0x1FF) == 108;
    }

    public static boolean isEdgeTACrashedBefore(int errorCode) {
        int n2;
        if (errorCode == 0) {
            return false;
        }
        return (n2 >> 12 & 0x1FF) == 401;
    }

    public static boolean isDLModelCrashedBefore(int errorCode) {
        int n2;
        if (errorCode == 0) {
            return false;
        }
        return (n2 >> 12 & 0x1FF) == 403;
    }

    public static String formatErrorCode(int errorCode) {
        int n2;
        int n3 = errorCode & 0xFFF;
        n2 = n2 >> 12 & 0x1FF;
        return n2 + "_" + n3;
    }
}

