/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.deviceid;

import android.content.Context;
import com.alipay.alipaysecuritysdk.common.config.Configuration;
import com.alipay.alipaysecuritysdk.common.config.GlobalConfig;
import com.alipay.alipaysecuritysdk.common.config.Locale;
import com.alipay.alipaysecuritysdk.face.APDID;
import com.alipay.alipaysecuritysdk.face.APSecuritySdk;
import com.alipay.alipaysecuritysdk.modules.x.bb;
import com.alipay.alipaysecuritysdk.modules.x.t;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class APDeviceTokenClient {
    public static final int STATUS_OK = 0;
    public static final int STATUS_MODULE_NOT_FOUND = 4;
    public static final int STATUS_APPNAME_EMPTY = 2;
    public static final int STATUS_APPKEYCLIENT_EMPTY = 3;
    public static final int STATUS_UNKNOWD = 1;
    public static final int ENVIRONMENT_ONLINE = 0;
    public static final int ENVIRONMENT_DAILY = 1;
    public static final int ENVIRONMENT_PRE = 2;
    public static final int ENVIRONMENT_SIT = 3;
    public static final int ENVIRONMENT_AAA = 4;
    private static String appNameCache = "";
    private static String appKeyClientCache = "";
    private static String randomStr = "";
    private boolean hasInited = false;
    private static APDeviceTokenClient deviceTokenClientInstance = null;
    private Context context = null;
    private AtomicBoolean isRepInitializing = new AtomicBoolean(false);

    /*
     * WARNING - void declaration
     */
    private APDeviceTokenClient(Context ctx) {
        void var1_1;
        if (ctx == null) {
            throw new IllegalArgumentException("DeviceTokenClient initialization error: context is null.");
        }
        this.context = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setConfiguration(Configuration configuration) {
        void var1_1;
        new StringBuilder("set local: ").append((Object)configuration.locale).append(", gateway:").append(configuration.gateway).append(", env:").append(configuration.envMode);
        GlobalConfig.setConfiguration((Configuration)var1_1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static APDeviceTokenClient getInstance(Context ctx) {
        if (deviceTokenClientInstance != null) return deviceTokenClientInstance;
        Class<APDeviceTokenClient> clazz = APDeviceTokenClient.class;
        synchronized (APDeviceTokenClient.class) {
            Context context;
            if (deviceTokenClientInstance != null) return deviceTokenClientInstance;
            deviceTokenClientInstance = new APDeviceTokenClient(context);
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return deviceTokenClientInstance;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void initToken(String appName, String appKeyClient, InitResultListener listener) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.initToken((String)var1_1, (String)var2_2, null, false, (InitResultListener)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void initToken(String appName, String appKeyClient, Map<String, String> inputParams, InitResultListener listener) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.initToken((String)var1_1, (String)var2_2, (Map<String, String>)var3_3, false, listener);
    }

    /*
     * WARNING - void declaration
     */
    public void updateToken(String appName, String appKeyClient, Map<String, String> inputParams, InitResultListener listener) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.initToken((String)var1_1, (String)var2_2, (Map<String, String>)var3_3, true, listener);
    }

    /*
     * WARNING - void declaration
     */
    private void initToken(String appName, String appKeyClient, Map<String, String> inputParams, boolean isForce, InitResultListener listener) {
        String string;
        String string2;
        try {
            if (!this.hasInited) {
                APSecuritySdk.getInstance().init(this.context);
                this.hasInited = true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (bb.b(appName)) {
            if (listener != null) {
                listener.onResult("", 2);
            }
            return;
        }
        if (bb.b(appKeyClient)) {
            if (listener != null) {
                listener.onResult("", 3);
            }
            return;
        }
        appKeyClientCache = appKeyClient;
        appNameCache = appName;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("appName", string2);
        hashMap.put("appKeyClient", string);
        hashMap.put("appchannel", "openapi");
        if (inputParams != null && inputParams.size() > 0) {
            void var3_3;
            string2 = inputParams.get("md5");
            string = (String)var3_3.get("traceid");
            hashMap.put("md5", string2 != null ? string2 : "");
            hashMap.put("traceid", string != null ? string : "");
        }
        try {
            if (isForce) {
                APDID.updateToken(hashMap, new com.alipay.alipaysecuritysdk.common.model.InitResultListener(this, listener){
                    final /* synthetic */ InitResultListener val$listener;
                    final /* synthetic */ APDeviceTokenClient this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                        this.val$listener = initResultListener;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public void onResult(Boolean success, com.alipay.alipaysecuritysdk.common.model.TokenResult tokenResult, String msg) {
                        void var1_1;
                        if (this.val$listener == null) {
                            return;
                        }
                        if (var1_1.booleanValue()) {
                            void var2_2;
                            this.val$listener.onResult(var2_2.apdidToken, 0);
                            return;
                        }
                        this.val$listener.onResult("", 1);
                    }
                });
                return;
            }
            APDID.initToken(hashMap, new com.alipay.alipaysecuritysdk.common.model.InitResultListener(this, listener){
                final /* synthetic */ InitResultListener val$listener;
                final /* synthetic */ APDeviceTokenClient this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$listener = initResultListener;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void onResult(Boolean success, com.alipay.alipaysecuritysdk.common.model.TokenResult tokenResult, String msg) {
                    void var1_1;
                    if (this.val$listener == null) {
                        return;
                    }
                    if (var1_1.booleanValue()) {
                        void var2_2;
                        this.val$listener.onResult(var2_2.apdidToken, 0);
                        return;
                    }
                    this.val$listener.onResult("", 1);
                }
            });
            return;
        }
        catch (Exception exception) {
            if (listener != null) {
                listener.onResult("", 4);
            }
            return;
        }
    }

    public TokenResult getTokenResult() {
        return this.getTokenResult(appNameCache);
    }

    public TokenResult getTokenResult(String appName) {
        TokenResult tokenResult = new TokenResult();
        new TokenResult().apdid = "";
        tokenResult.clientKey = "";
        tokenResult.apdidToken = "";
        try {
            com.alipay.alipaysecuritysdk.common.model.TokenResult tokenResult2;
            tokenResult2 = APDID.getTokenResult((String)((Object)tokenResult2));
            tokenResult.apdidToken = tokenResult2.apdidToken;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (tokenResult.apdidToken != null && !"".equals(tokenResult.apdidToken)) {
            new StringBuilder("gettoken ").append(appNameCache);
            return tokenResult;
        }
        if (appNameCache == null || appKeyClientCache == null || "".equals(appNameCache) || "".equals(appKeyClientCache)) {
            tokenResult.apdidToken = "";
            return tokenResult;
        }
        this.initToken(appNameCache, appKeyClientCache, new InitResultListener(this){
            final /* synthetic */ APDeviceTokenClient this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            public void onResult(String apdidToken, int errorCode) {
            }
        });
        return tokenResult;
    }

    /*
     * WARNING - void declaration
     */
    public String getExactID(Context context) {
        if (context == null) {
            return null;
        }
        try {
            void var1_1;
            return t.f((Context)var1_1);
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    public static void setEnvConfig(int envMode) {
        switch (envMode) {
            case 1: {
                APSecuritySdk.getInstance().setConfiguration(Locale.FinTech, 3);
                return;
            }
            case 3: {
                APSecuritySdk.getInstance().setConfiguration(Locale.FinTech, 2);
                return;
            }
            case 2: {
                APSecuritySdk.getInstance().setConfiguration(Locale.FinTech, 1);
                return;
            }
            case 4: {
                APSecuritySdk.getInstance().setConfiguration(Locale.FinTech, 4);
                return;
            }
        }
        APSecuritySdk.getInstance().setConfiguration(Locale.FinTech, 0);
    }

    public static void setGatewayAddress(String address) {
        String string;
        APSecuritySdk.getInstance().setConfiguration(Configuration.createConfiguration(string, 0));
    }

    public static class TokenResult {
        public String apdidToken;
        public String clientKey;
        public String apdid;
    }

    public static interface InitResultListener {
        public void onResult(String var1, int var2);
    }
}

