/*
 * Decompiled with CFR 0.152.
 */
package net.security.device.api.id.oaid;

import android.annotation.SuppressLint;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.IBinder;
import android.os.Parcel;
import java.security.MessageDigest;
import net.security.device.api.LogUtil;
import net.security.device.api.id.IOAID;
import net.security.device.api.id.IOAIDGetter;

public class OppoImpl
implements IOAID {
    private final Context context;
    private String sign;

    public OppoImpl(Context context) {
        this.context = context;
    }

    @Override
    public boolean supportOAID() {
        if (this.context == null) {
            return false;
        }
        try {
            PackageManager pm = this.context.getPackageManager();
            if (pm != null) {
                PackageInfo pi = pm.getPackageInfo("com.heytap.openid", 0);
                return pi != null;
            }
        }
        catch (Exception e) {
            LogUtil.e(e.toString());
        }
        return false;
    }

    @Override
    public void doGet(final IOAIDGetter getter) {
        if (this.context == null) {
            getter.onOAIDGetError(new NullPointerException("OAID context is null"));
            return;
        }
        Intent intent = new Intent("action.com.heytap.openid.OPEN_ID_SERVICE");
        intent.setComponent(new ComponentName("com.heytap.openid", "com.heytap.openid.IdentifyService"));
        try {
            boolean isBinded = this.context.bindService(intent, new ServiceConnection(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onServiceConnected(ComponentName name, IBinder service) {
                    LogUtil.d("HeyTap IdentifyService connected");
                    try {
                        try {
                            String ouid = OppoImpl.this.realGetOUID(service);
                            if (ouid == null || ouid.length() == 0) {
                                throw new RuntimeException("HeyTap OUID get failed");
                            }
                            getter.onOAIDGetComplete(ouid);
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                        finally {
                            OppoImpl.this.context.unbindService((ServiceConnection)this);
                        }
                    }
                    catch (Exception e) {
                        LogUtil.e(e.toString());
                        getter.onOAIDGetError(e);
                    }
                }

                public void onServiceDisconnected(ComponentName name) {
                    LogUtil.d("HeyTap IdentifyService disconnected");
                }
            }, 1);
            if (!isBinded) {
                throw new RuntimeException("HeyTap IdentifyService bind failed");
            }
        }
        catch (Exception e) {
            getter.onOAIDGetError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"PackageManagerGetSignatures"})
    private String realGetOUID(IBinder service) {
        Object signatures;
        if (this.context == null || service == null) {
            return null;
        }
        String pkgName = this.context.getPackageName();
        if (this.sign == null) {
            try {
                MessageDigest messageDigest;
                byte[] digest;
                byte[] byteArray;
                PackageInfo pi;
                PackageManager pm = this.context.getPackageManager();
                if (pm != null && (pi = pm.getPackageInfo(pkgName, 64)) != null && (signatures = pi.signatures) != null && (byteArray = signatures[0].toByteArray()) != null && (digest = (messageDigest = MessageDigest.getInstance("SHA1")).digest(byteArray)) != null) {
                    StringBuilder sb = new StringBuilder();
                    for (byte b : digest) {
                        sb.append(Integer.toHexString(b & 0xFF | 0x100).substring(1, 3));
                    }
                    this.sign = sb.toString();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Parcel obtain = Parcel.obtain();
        Parcel obtain2 = Parcel.obtain();
        try {
            obtain.writeInterfaceToken("com.heytap.openid.IOpenID");
            obtain.writeString(pkgName);
            obtain.writeString(this.sign);
            obtain.writeString("OUID");
            if (service.transact(1, obtain, obtain2, 0)) {
                obtain2.readException();
                signatures = obtain2.readString();
                return signatures;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            obtain.recycle();
            obtain2.recycle();
        }
        return null;
    }
}

