/*
 * Decompiled with CFR 0.152.
 */
package com.dtf.face.ui.toyger;

import android.app.Fragment;
import android.graphics.Color;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.dtf.face.ToygerConfig;
import com.dtf.face.api.IDTFragment;
import com.dtf.face.api.IDTFragmentCallBack;
import com.dtf.face.api.IDTUIListener;
import com.dtf.face.log.RecordLevel;
import com.dtf.face.log.RecordService;
import com.dtf.face.ui.UICustomParams;
import com.dtf.face.ui.overlay.CommAlertOverlay;
import com.dtf.face.ui.widget.CircleHoleView;
import com.dtf.face.ui.widget.RoundProgressBar;
import com.dtf.face.verify.R;

public class FaceShowFragment
extends Fragment
implements IDTFragment {
    public View mRootView;
    public IDTFragment.ICloseCallBack mCloseCallBack;
    public IDTFragment.IDTCallBack mDTCallBack;
    public double cameraSurfaceViewRate = 0.66f;

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup stringArray, Bundle bundle) {
        bundle = this.mRootView;
        if (bundle == null) {
            try {
                this.mRootView = layoutInflater.inflate(this.getLayoutID(), (ViewGroup)stringArray, false);
            }
            catch (Throwable throwable) {
                String[] stringArray2 = new String[2];
                stringArray = stringArray2;
                stringArray[0] = "msg";
                stringArray2[1] = Log.getStackTraceString((Throwable)throwable);
                RecordService.getInstance().recordEvent(RecordLevel.LOG_INFO, "ToygerActivityInit", stringArray);
            }
            this.initView();
        } else {
            layoutInflater = bundle.getParent();
            if (layoutInflater instanceof ViewGroup) {
                ((ViewGroup)layoutInflater).removeView(this.mRootView);
            }
        }
        return this.mRootView;
    }

    public int getLayoutID() {
        return R.layout.dtf_activity_toyger;
    }

    public void initView() {
        TextView textView;
        if (!TextUtils.isEmpty((CharSequence)UICustomParams.TOP_TIP_TEXT) && (textView = this.getLivenessMessageView()) != null) {
            TextView textView2 = textView;
            textView2.setTextSize(1, this.getResources().getDimension(R.dimen.dtf_comm_normal_small2_font_size));
            textView2.setText((CharSequence)UICustomParams.TOP_TIP_TEXT);
        }
        FaceShowFragment faceShowFragment = this;
        faceShowFragment.stopFaceScanProcess(true);
        faceShowFragment.initClose();
    }

    public <T extends View> T findViewById(int n2) {
        FaceShowFragment faceShowFragment = faceShowFragment.mRootView;
        if (faceShowFragment != null) {
            return (T)faceShowFragment.findViewById(n2);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initClose() {
        View view;
        block8: {
            view = this.getCloseView();
            try {
                IDTUIListener iDTUIListener = ToygerConfig.getInstance().getUiCustomListener();
                if (iDTUIListener == null) break block8;
                if (view != null && !iDTUIListener.onIsPageScanCloseImageLeft()) {
                    View view2 = view;
                    ((FrameLayout.LayoutParams)view2.getLayoutParams()).gravity = 5;
                    view2.setLayoutParams((ViewGroup.LayoutParams)((FrameLayout.LayoutParams)view2.getLayoutParams()));
                }
                Object t = this.findViewById(R.id.close_toyger_icon);
                int n2 = iDTUIListener.onPageScanCloseImage();
                if (t == null || n2 <= 0) break block8;
                if (t instanceof ImageView) {
                    ((ImageView)t).setImageResource(n2);
                } else {
                    t.setBackgroundResource(n2);
                }
            }
            catch (Exception exception) {}
        }
        if (view != null) {
            view.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    1 this_ = this_.FaceShowFragment.this.mCloseCallBack;
                    if (this_ != null) {
                        this_.onClose();
                    }
                }
            });
        }
    }

    public void stopFaceScanProcess(boolean bl) {
        if ((this = this.getFaceProgressView()) != null) {
            this.stopProcess();
            if (bl) {
                this.setProgress(0);
            }
        }
    }

    public void stopFaceUploadProcess() {
        LinearLayout linearLayout = (LinearLayout)this.findViewById(R.id.toyger_face_eye_loading_page);
        if (linearLayout != null) {
            linearLayout.setVisibility(8);
        }
        if ((this = this.getCloseView()) != null) {
            this.setEnabled(true);
        }
    }

    public void onCameraPreviewBegin() {
        LinearLayout linearLayout = (LinearLayout)this.findViewById(R.id.toyger_main_page);
        if (linearLayout != null) {
            linearLayout.setVisibility(0);
        }
        if ((this = this.getCloseView()) != null) {
            this.setVisibility(0);
        }
    }

    public void onCameraPreviewEnd() {
        this.stopFaceScanProcess(true);
    }

    public void onVerifyBegin() {
        FaceShowFragment faceShowFragment = this;
        faceShowFragment.showFaceProcessView(false);
        faceShowFragment.startFaceUploadProcess();
    }

    public void showFaceProcessView(boolean bl) {
        if ((this = this.getFaceProgressView()) != null) {
            if (!bl) {
                this.setVisibility(0);
            } else {
                this.setVisibility(8);
            }
        }
    }

    public void startFaceUploadProcess() {
        LinearLayout linearLayout = (LinearLayout)this.findViewById(R.id.toyger_face_eye_loading_page);
        if (linearLayout != null) {
            if (linearLayout.getVisibility() == 0) {
                return;
            }
            linearLayout.setVisibility(0);
        }
        if ((this = this.getCloseView()) != null) {
            this.setEnabled(false);
        }
    }

    public void onVerifyEnd() {
        FaceShowFragment faceShowFragment = this;
        faceShowFragment.stopFaceScanProcess(true);
        faceShowFragment.showFaceProcessView(false);
        faceShowFragment.stopFaceUploadProcess();
    }

    public void onPhotinusBegin() {
        if ((this = this.getFaceMessageView()) != null) {
            this.setVisibility(4);
        }
    }

    public void onPhotinusColorUpdate(int n2) {
        if ((this = (CircleHoleView)this.findViewById(R.id.toyger_face_circle_hole_view)) != null) {
            this.changeBackColor(n2);
        }
    }

    public void onPhotinusEnd() {
    }

    public void onTimeChanged(int n2, int n3) {
        if ((this = this.getFaceProgressView()) != null) {
            String string2 = UICustomParams.FACE_PROGRESS_COLOR;
            if (string2 != null) {
                this.setGradientColor(Color.parseColor((String)string2));
            }
            this.setMax(n3);
            this.setProgress(n3 - n2);
        }
    }

    public void onRetry(int n2) {
        if ((this = this.getFaceProgressView()) != null) {
            String string2 = UICustomParams.FACE_PROGRESS_COLOR;
            if (string2 != null) {
                this.setGradientColor(Color.parseColor((String)string2));
            }
            this.setProgress(0);
        }
    }

    public void onFaceTipsUpdateFace(String string2, String string3) {
        TextView textView = this.getFaceMessageView();
        if (textView != null && !TextUtils.isEmpty((CharSequence)string3)) {
            textView.setText((CharSequence)string3);
        }
        if ((this = this.getLivenessMessageView()) != null && !TextUtils.isEmpty((CharSequence)string2) && TextUtils.isEmpty((CharSequence)UICustomParams.TOP_TIP_TEXT)) {
            this.setText(string2);
        }
    }

    public void onCameraSizeChanged(double d2, double d3) {
        if (this.getResources() != null && this.getResources().getConfiguration() != null && this.getResources().getConfiguration().orientation == 2) {
            this.onLandUIInit(d2, d3);
        } else {
            this.onPortUIInit(d2, d3);
        }
    }

    public void onPortUIInit(double d2, double d3) {
        Object t = this.findViewById(R.id.screen_main_frame);
        if (t != null) {
            RoundProgressBar roundProgressBar;
            float f2;
            Object t2 = t;
            float f3 = t2.getWidth();
            float f4 = t2.getHeight();
            float f5 = 1.8f;
            if (f2 / f3 < f5) {
                f3 = (int)(f4 / f5);
            }
            FaceShowFragment faceShowFragment = this;
            FrameLayout frameLayout = (FrameLayout)faceShowFragment.findViewById(R.id.toger_main_scan_frame);
            ViewGroup.LayoutParams layoutParams = frameLayout.getLayoutParams();
            layoutParams.width = (int)(this.cameraSurfaceViewRate * (double)f3);
            layoutParams.height = (int)((double)layoutParams.width / (d2 * 1.0) * d3);
            frameLayout.setLayoutParams(layoutParams);
            CircleHoleView circleHoleView = (CircleHoleView)faceShowFragment.findViewById(R.id.toyger_face_circle_hole_view);
            if (circleHoleView != null) {
                CircleHoleView circleHoleView2 = circleHoleView;
                circleHoleView2.getLayoutParams().width = layoutParams.width;
                circleHoleView2.getLayoutParams().height = layoutParams.height;
                circleHoleView2.setLayoutParams(circleHoleView2.getLayoutParams());
                int n2 = layoutParams.width;
                circleHoleView.widthAttr = n2;
                circleHoleView.heightAttr = n2;
                circleHoleView.invalidate();
            }
            if ((roundProgressBar = this.getFaceProgressView()) != null) {
                RoundProgressBar roundProgressBar2 = roundProgressBar;
                roundProgressBar2.getLayoutParams().width = layoutParams.width;
                roundProgressBar2.getLayoutParams().height = layoutParams.width;
                roundProgressBar2.setLayoutParams(roundProgressBar2.getLayoutParams());
            }
            if ((this = this.getFaceMessageView()) != null) {
                FaceShowFragment faceShowFragment2 = this;
                faceShowFragment2.getLayoutParams().width = layoutParams.width;
                faceShowFragment2.setLayoutParams(faceShowFragment2.getLayoutParams());
            }
        }
    }

    public void onLandUIInit(double d2, double d3) {
        Object t = faceShowFragment3.findViewById(R.id.screen_main_frame);
        if (t != null) {
            TextView textView;
            FaceShowFragment faceShowFragment = faceShowFragment3;
            int n2 = t.getHeight();
            double d4 = faceShowFragment.getResources().getDimension(R.dimen.margin_size_60);
            FrameLayout frameLayout = (FrameLayout)faceShowFragment.findViewById(R.id.toger_main_scan_frame);
            ViewGroup.LayoutParams layoutParams = frameLayout.getLayoutParams();
            double d5 = faceShowFragment3.cameraSurfaceViewRate;
            layoutParams.height = (int)(((double)n2 - d4) * d5);
            layoutParams.width = (int)((double)layoutParams.height / (d3 * 1.0) * d2);
            frameLayout.setLayoutParams(layoutParams);
            CircleHoleView circleHoleView = (CircleHoleView)faceShowFragment.findViewById(R.id.toyger_face_circle_hole_view);
            if (circleHoleView != null) {
                CircleHoleView circleHoleView2 = circleHoleView;
                circleHoleView2.getLayoutParams().width = layoutParams.width;
                circleHoleView2.getLayoutParams().height = layoutParams.height;
                circleHoleView2.setLayoutParams(circleHoleView2.getLayoutParams());
                int n3 = layoutParams.height;
                circleHoleView.widthAttr = n3;
                circleHoleView.heightAttr = n3;
                circleHoleView.invalidate();
            }
            if ((textView = faceShowFragment3.getFaceMessageView()) != null) {
                TextView textView2 = textView;
                textView2.getLayoutParams().width = layoutParams.height;
                textView2.setLayoutParams(textView2.getLayoutParams());
            }
            if ((faceShowFragment3 = faceShowFragment3.getFaceProgressView()) != null) {
                FaceShowFragment faceShowFragment2 = faceShowFragment3;
                FaceShowFragment faceShowFragment3 = faceShowFragment2.getLayoutParams();
                ((ViewGroup.LayoutParams)faceShowFragment3).height = ((ViewGroup.LayoutParams)faceShowFragment3).width = layoutParams.height;
                faceShowFragment2.setLayoutParams((ViewGroup.LayoutParams)faceShowFragment3);
            }
        }
    }

    public FrameLayout getCameraContainer() {
        return (FrameLayout)this.findViewById(R.id.toyger_camera_container);
    }

    public FrameLayout getPhotinusContainer() {
        return (FrameLayout)this.findViewById(R.id.toyger_photinus_container);
    }

    public boolean onMessageBoxShow(String string2, String string3, String string4, String string5, final IDTFragmentCallBack.MessageBoxCallBack messageBoxCallBack) {
        CommAlertOverlay commAlertOverlay = this.getAlertMessageView();
        if (commAlertOverlay != null) {
            IDTUIListener iDTUIListener = ToygerConfig.getInstance().getUiCustomListener();
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                String string6;
                boolean bl = false;
                if (iDTUIListener != null && !TextUtils.isEmpty((CharSequence)(string6 = iDTUIListener.onAlertTitle(string2)))) {
                    bl = true;
                } else {
                    string6 = string2;
                }
                commAlertOverlay.setTitleText(string6, bl);
            }
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                String string7;
                boolean bl = false;
                if (iDTUIListener != null && !TextUtils.isEmpty((CharSequence)(string7 = iDTUIListener.onAlertMessage(string3)))) {
                    bl = true;
                } else {
                    string7 = string3;
                }
                commAlertOverlay.setMessageText(string7, bl);
            } else {
                commAlertOverlay.setMessageText(string3, false);
            }
            if (!TextUtils.isEmpty((CharSequence)string5)) {
                commAlertOverlay.setButtonType(true);
                boolean bl = false;
                if (iDTUIListener != null && !TextUtils.isEmpty((CharSequence)(string3 = iDTUIListener.onAlertCancelButton(string5)))) {
                    bl = true;
                } else {
                    string3 = string5;
                }
                commAlertOverlay.setCancelText(string3, bl);
            } else {
                commAlertOverlay.setButtonType(false);
            }
            if (!TextUtils.isEmpty((CharSequence)string4)) {
                boolean bl = false;
                if (iDTUIListener != null && !TextUtils.isEmpty((CharSequence)(string3 = iDTUIListener.onAlertOKButton(string4)))) {
                    bl = true;
                } else {
                    string3 = string4;
                }
                commAlertOverlay.setConfirmText(string3, bl);
            }
            CommAlertOverlay commAlertOverlay2 = commAlertOverlay;
            commAlertOverlay2.setVisibility(0);
            commAlertOverlay2.setCommAlertOverlayListener(new CommAlertOverlay.CommAlertOverlayListener(){

                public void onCancel() {
                    2 this_ = this_.messageBoxCallBack;
                    if (this_ != null) {
                        this_.onCancel();
                    }
                }

                public void onConfirm() {
                    2 this_ = this_.messageBoxCallBack;
                    if (this_ != null) {
                        this_.onOK();
                    }
                }
            });
            return true;
        }
        return false;
    }

    public void hideMessageBox() {
        if ((this = this.getAlertMessageView()) != null && this.getVisibility() == 0) {
            this.setVisibility(8);
        }
    }

    public boolean hasShowMessageBox() {
        if ((this = this.getAlertMessageView()) != null) {
            return this.getVisibility() == 0;
        }
        return false;
    }

    public boolean isActive() {
        return this.isAdded();
    }

    public boolean onBackPressed() {
        return false;
    }

    public void setCloseCallBack(IDTFragment.ICloseCallBack iCloseCallBack) {
        this.mCloseCallBack = iCloseCallBack;
    }

    public void setDTCallBack(IDTFragment.IDTCallBack iDTCallBack) {
        this.mDTCallBack = iDTCallBack;
    }

    public CommAlertOverlay getAlertMessageView() {
        return (CommAlertOverlay)this.findViewById(R.id.message_box_overlay);
    }

    public TextView getLivenessMessageView() {
        return (TextView)this.findViewById(R.id.face_common_tips);
    }

    public RoundProgressBar getFaceProgressView() {
        return (RoundProgressBar)this.findViewById(R.id.scan_progress);
    }

    public TextView getFaceMessageView() {
        return (TextView)this.findViewById(R.id.messageCode);
    }

    public View getCloseView() {
        return this.findViewById(R.id.close_toyger_btn);
    }
}

