/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.alipaysecuritysdk.mpaas.rpc;

import android.content.Context;
import android.util.Log;
import com.alipay.alipaysecuritysdk.api.service.ConfigService;
import com.alipay.alipaysecuritysdk.api.service.RPCService;
import com.alipay.alipaysecuritysdk.api.service.ServiceManager;
import com.alipay.alipaysecuritysdk.api.service.model.DeviceConfigRequest;
import com.alipay.alipaysecuritysdk.api.service.model.DeviceConfigResult;
import com.alipay.alipaysecuritysdk.api.service.model.DeviceRpcRequest;
import com.alipay.alipaysecuritysdk.api.service.model.DeviceRpcResponse;
import com.alipay.alipaysecuritysdk.modules.x.ch;
import com.alipay.alipaysecuritysdk.modules.x.cv;
import com.alipay.alipaysecuritysdk.modules.x.da;
import com.alipay.alipaysecuritysdk.mpaas.rpc.model.EdgeConfigRequest;
import com.alipay.alipaysecuritysdk.mpaas.rpc.model.EdgeConfigResult;
import com.alipay.alipaysecuritysdk.mpaas.rpc.model.ReportRequest;
import com.alipay.alipaysecuritysdk.mpaas.rpc.model.ReportResult;
import com.alipay.alipaysecuritysdk.mpaas.rpc.service.AliyunEdgeConfigService;
import com.alipay.alipaysecuritysdk.mpaas.rpc.service.DeviceDataReportService;
import com.alipay.alipaysecuritysdk.mpaas.rpc.tool.ConvertUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;

public class RPCServiceImpl
implements RPCService {
    private static final int DATA_UPDATE_TIMEOUT = 600000;
    private static final int CONFIG_UPDATE_TIMEOUT = 4000;
    private cv mRpcClient = null;
    private DeviceDataReportService mDeviceFingerPrintService = null;
    private AliyunEdgeConfigService mEdgeConfigService = null;
    private ReportResult mReportResult = null;
    private EdgeConfigResult mConfigResult = null;
    private ExecutorService mDFPThreadExecutor = null;
    private ExecutorService mEdgeConfigExecutor = null;

    /*
     * WARNING - void declaration
     */
    @Override
    public void initDataReportService(Context context, String hostAddress, Map<String, String> headers) {
        ArrayList<Header> arrayList;
        da da2 = new da();
        new da().a = arrayList;
        arrayList = new ArrayList<Header>();
        if (headers != null) {
            Iterator iterator;
            for (Map.Entry entry : iterator.entrySet()) {
                arrayList.add((Header)new BasicHeader((String)entry.getKey(), (String)entry.getValue()));
            }
        }
        da2.b = arrayList;
        if (this.mRpcClient == null) {
            void var1_1;
            this.mRpcClient = new ch((Context)var1_1);
        }
        this.mDeviceFingerPrintService = this.mRpcClient.a(DeviceDataReportService.class, da2);
        if (this.mDFPThreadExecutor == null) {
            this.mDFPThreadExecutor = Executors.newSingleThreadExecutor();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void initConfigReportService(Context context, String hostAddress, Map<String, String> headers) {
        ArrayList<Header> arrayList;
        da da2 = new da();
        new da().a = arrayList;
        arrayList = new ArrayList<Header>();
        if (headers != null) {
            Iterator iterator;
            for (Map.Entry entry : iterator.entrySet()) {
                arrayList.add((Header)new BasicHeader((String)entry.getKey(), (String)entry.getValue()));
            }
        }
        da2.b = arrayList;
        if (this.mRpcClient == null) {
            void var1_1;
            this.mRpcClient = new ch((Context)var1_1);
        }
        this.mEdgeConfigService = this.mRpcClient.a(AliyunEdgeConfigService.class, da2);
        if (this.mEdgeConfigExecutor == null) {
            this.mEdgeConfigExecutor = Executors.newScheduledThreadPool(4);
        }
    }

    @Override
    public DeviceRpcResponse updateStaticData(DeviceRpcRequest deviceRpcRequest) {
        ReportRequest reportRequest;
        CountDownLatch countDownLatch = new CountDownLatch(1);
        reportRequest = ConvertUtil.convertFrom((DeviceRpcRequest)((Object)reportRequest));
        if (this.mDeviceFingerPrintService != null) {
            this.mDFPThreadExecutor.execute(new Runnable(this, reportRequest, countDownLatch){
                final /* synthetic */ ReportRequest val$reportRequest;
                final /* synthetic */ CountDownLatch val$updateStaticDataCountDown;
                final /* synthetic */ RPCServiceImpl this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$reportRequest = reportRequest;
                    this.val$updateStaticDataCountDown = countDownLatch;
                }

                @Override
                public void run() {
                    try {
                        RPCServiceImpl.access$002(this.this$0, this.this$0.mDeviceFingerPrintService.reportStaticData(this.val$reportRequest));
                    }
                    catch (Throwable throwable) {
                        RPCServiceImpl.access$002(this.this$0, new ReportResult());
                        ((RPCServiceImpl)this.this$0).mReportResult.success = false;
                        ((RPCServiceImpl)this.this$0).mReportResult.resultCode = "update static data error:" + throwable.getMessage();
                        Log.e((String)"apdid", (String)"", (Throwable)throwable);
                    }
                    this.val$updateStaticDataCountDown.countDown();
                }
            });
            try {
                countDownLatch.await(600000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        return ConvertUtil.convertFrom(this.mReportResult);
    }

    @Override
    public DeviceConfigResult updateConfigData(DeviceConfigRequest deviceConfigRequest) throws Exception {
        Object object;
        CountDownLatch countDownLatch = new CountDownLatch(1);
        object = ConvertUtil.convertFrom((DeviceConfigRequest)object);
        if (this.mEdgeConfigService != null) {
            this.mEdgeConfigExecutor.execute(new Runnable(this, (EdgeConfigRequest)object, countDownLatch){
                final /* synthetic */ EdgeConfigRequest val$configRequest;
                final /* synthetic */ CountDownLatch val$updateStaticDataCountDown;
                final /* synthetic */ RPCServiceImpl this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$configRequest = edgeConfigRequest;
                    this.val$updateStaticDataCountDown = countDownLatch;
                }

                @Override
                public void run() {
                    try {
                        RPCServiceImpl.access$202(this.this$0, this.this$0.mEdgeConfigService.getEdgeConfig(this.val$configRequest));
                    }
                    catch (Throwable throwable) {
                        RPCServiceImpl.access$202(this.this$0, new EdgeConfigResult());
                        ((RPCServiceImpl)this.this$0).mConfigResult.success = false;
                        ((RPCServiceImpl)this.this$0).mConfigResult.resultCode = "update config data error:" + throwable.getMessage();
                        Log.e((String)"apdid", (String)"", (Throwable)throwable);
                    }
                    this.val$updateStaticDataCountDown.countDown();
                }
            });
            object = (ConfigService)ServiceManager.getService(ServiceManager.TYPE_SERVICE_CONFIG);
            int n2 = 4000;
            if (object != null) {
                try {
                    n2 = Integer.parseInt(object.getConfig("configUpdateTimeout"));
                }
                catch (Exception exception) {}
                if (n2 == 0) {
                    n2 = 4000;
                }
            }
            try {
                countDownLatch.await(n2, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        return ConvertUtil.convertFrom(this.mConfigResult);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ ReportResult access$002(RPCServiceImpl x0, ReportResult x1) {
        void var1_1;
        x0.mReportResult = var1_1;
        return x0.mReportResult;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ EdgeConfigResult access$202(RPCServiceImpl x0, EdgeConfigResult x1) {
        void var1_1;
        x0.mConfigResult = var1_1;
        return x0.mConfigResult;
    }
}

