/*
 * Decompiled with CFR 0.152.
 */
package org.ejbca.cvc;

import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.util.Calendar;
import java.util.Date;
import org.ejbca.cvc.AccessRightEnum;
import org.ejbca.cvc.AccessRights;
import org.ejbca.cvc.AlgorithmUtil;
import org.ejbca.cvc.AuthorizationRole;
import org.ejbca.cvc.AuthorizationRoleEnum;
import org.ejbca.cvc.CAReferenceField;
import org.ejbca.cvc.CVCAuthenticatedRequest;
import org.ejbca.cvc.CVCPublicKey;
import org.ejbca.cvc.CVCertificate;
import org.ejbca.cvc.CVCertificateBody;
import org.ejbca.cvc.HolderReferenceField;
import org.ejbca.cvc.KeyFactory;
import org.ejbca.cvc.util.BCECUtil;

public final class CertificateGenerator {
    public static CVCertificate createTestCertificate(PublicKey serializable, PrivateKey privateKey, CAReferenceField cAReferenceField, HolderReferenceField holderReferenceField, String string, AuthorizationRoleEnum authorizationRoleEnum) {
        PublicKey publicKey = serializable;
        Date date = Calendar.getInstance().getTime();
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, 3);
        serializable = calendar.getTime();
        return CertificateGenerator.createCertificate(publicKey, privateKey, string, cAReferenceField, holderReferenceField, authorizationRoleEnum, AccessRightEnum.READ_ACCESS_DG3_AND_DG4, date, (Date)serializable, "BC");
    }

    public static CVCertificate createCertificate(PublicKey serializable, PrivateKey privateKey, String string, CAReferenceField cAReferenceField, HolderReferenceField holderReferenceField, AuthorizationRole authorizationRole, AccessRights accessRights, Date date, Date date2, String string2) {
        CVCertificate cVCertificate;
        CVCertificateBody cVCertificateBody;
        serializable = KeyFactory.createInstance((PublicKey)serializable, string, authorizationRole);
        CVCertificateBody cVCertificateBody2 = cVCertificateBody;
        cVCertificateBody = new CVCertificateBody(cAReferenceField, (CVCPublicKey)serializable, holderReferenceField, authorizationRole, accessRights, date, date2);
        serializable = cVCertificate;
        String string3 = string;
        ((CVCertificate)serializable)(cVCertificateBody2);
        Signature signature = Signature.getInstance(AlgorithmUtil.convertAlgorithmNameToCVC(string3), string2);
        signature.initSign(privateKey);
        signature.update(((CVCertificate)serializable).getTBS());
        cVCertificate.setSignature(BCECUtil.convertX962SigToCVC(string3, signature.sign()));
        return cVCertificate;
    }

    public static CVCertificate createCertificate(PublicKey publicKey, PrivateKey privateKey, String string, CAReferenceField cAReferenceField, HolderReferenceField holderReferenceField, AuthorizationRoleEnum authorizationRoleEnum, AccessRightEnum accessRightEnum, Date date, Date date2, String string2) {
        return CertificateGenerator.createCertificate(publicKey, privateKey, string, cAReferenceField, holderReferenceField, (AuthorizationRole)authorizationRoleEnum, (AccessRights)accessRightEnum, date, date2, string2);
    }

    public static CVCertificate createRequest(KeyPair keyPair, String string, HolderReferenceField holderReferenceField) {
        return CertificateGenerator.createRequest(keyPair, string, holderReferenceField, "BC");
    }

    public static CVCertificate createRequest(KeyPair keyPair, String string, HolderReferenceField holderReferenceField, String string2) {
        return CertificateGenerator.createRequest(keyPair, string, null, holderReferenceField, string2);
    }

    public static CVCertificate createRequest(KeyPair keyPair, String string, CAReferenceField cAReferenceField, HolderReferenceField holderReferenceField) {
        return CertificateGenerator.createRequest(keyPair, string, cAReferenceField, holderReferenceField, "BC");
    }

    public static CVCertificate createRequest(KeyPair keyPair, String string, CAReferenceField cVCObject, HolderReferenceField holderReferenceField, String string2) {
        CVCertificate cVCertificate;
        CVCertificateBody cVCertificateBody;
        CVCPublicKey cVCPublicKey = KeyFactory.createInstance(keyPair.getPublic(), string, null);
        CVCertificateBody cVCertificateBody2 = cVCertificateBody;
        cVCertificateBody = new CVCertificateBody((CAReferenceField)cVCObject, cVCPublicKey, holderReferenceField);
        cVCObject = cVCertificate;
        String string3 = string;
        ((CVCertificate)cVCObject)(cVCertificateBody2);
        Signature signature = Signature.getInstance(AlgorithmUtil.convertAlgorithmNameToCVC(string3), string2);
        signature.initSign(keyPair.getPrivate());
        signature.update(((CVCertificate)cVCObject).getTBS());
        cVCertificate.setSignature(BCECUtil.convertX962SigToCVC(string3, signature.sign()));
        return cVCertificate;
    }

    public static CVCAuthenticatedRequest createAuthenticatedRequest(CVCertificate cVCertificate, KeyPair keyPair, String string, CAReferenceField cAReferenceField) {
        return CertificateGenerator.createAuthenticatedRequest(cVCertificate, keyPair, string, cAReferenceField, "BC");
    }

    public static CVCAuthenticatedRequest createAuthenticatedRequest(CVCertificate cVCertificate, KeyPair keyPair, String string, CAReferenceField cAReferenceField, String string2) {
        CVCAuthenticatedRequest cVCAuthenticatedRequest;
        CVCAuthenticatedRequest cVCAuthenticatedRequest2 = cVCAuthenticatedRequest;
        String string3 = string;
        cVCAuthenticatedRequest2(cVCertificate, cAReferenceField);
        Signature signature = Signature.getInstance(AlgorithmUtil.convertAlgorithmNameToCVC(string3), string2);
        signature.initSign(keyPair.getPrivate());
        signature.update(cVCAuthenticatedRequest2.getTBS());
        cVCAuthenticatedRequest.setSignature(BCECUtil.convertX962SigToCVC(string3, signature.sign()));
        return cVCAuthenticatedRequest;
    }
}

