/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import net.sf.scuba.smartcards.APDUWrapper;
import net.sf.scuba.smartcards.CardServiceException;
import net.sf.scuba.smartcards.FileInfo;
import net.sf.scuba.smartcards.FileSystemStructured;
import net.sf.scuba.tlv.TLVInputStream;
import org.jmrtd.APDULevelReadBinaryCapable;
import org.jmrtd.io.FragmentBuffer;
import org.jmrtd.lds.LDSFileUtil;

public class DefaultFileSystem
implements FileSystemStructured {
    public static final int NO_SFI = -1;
    public static final Logger LOGGER = Logger.getLogger("org.jmrtd");
    public static final int READ_AHEAD_LENGTH = 8;
    public short selectedFID;
    public boolean isSFIEnabled;
    public boolean isSelected;
    public APDULevelReadBinaryCapable service;
    public Map<Short, DefaultFileInfo> fileInfos;
    public Map<Short, Byte> fidToSFI;
    public APDUWrapper wrapper;

    public DefaultFileSystem(APDULevelReadBinaryCapable aPDULevelReadBinaryCapable, boolean bl) {
        this(aPDULevelReadBinaryCapable, bl, LDSFileUtil.FID_TO_SFI);
    }

    public DefaultFileSystem(APDULevelReadBinaryCapable aPDULevelReadBinaryCapable, boolean bl, Map<Short, Byte> map) {
        DefaultFileSystem defaultFileSystem = this;
        defaultFileSystem.service = aPDULevelReadBinaryCapable;
        defaultFileSystem.fileInfos = new HashMap<Short, DefaultFileInfo>();
        defaultFileSystem.selectedFID = 0;
        defaultFileSystem.isSelected = false;
        this.isSFIEnabled = bl;
        this.fidToSFI = map;
    }

    /*
     * Unable to fully structure code
     */
    private synchronized DefaultFileInfo getFileInfo() {
        block21: {
            block20: {
                block19: {
                    var1_1 = this.selectedFID;
                    if (var1_1 <= 0) break block21;
                    var1_2 = this.fileInfos.get(var1_1);
                    if (var1_2 != null) {
                        return var1_2;
                    }
                    if (!this.isSFIEnabled) ** GOTO lbl20
                    var1_2 = this.fidToSFI.get(this.selectedFID);
                    if (var1_2 == null) ** GOTO lbl19
                    var1_3 = 128;
                    v0 = var1_2.byteValue();
                    var1_2 = this.sendReadBinary(v0 & 255 | var1_3, 0, 8, false);
                    this.isSelected = true;
                    break block19;
lbl19:
                    // 1 sources

                    throw new NumberFormatException("Unknown FID " + Integer.toHexString(this.selectedFID));
lbl20:
                    // 1 sources

                    if (this.isSelected) ** GOTO lbl25
                    v1 = this;
                    v1.sendSelectFile(v1.selectedFID);
                    v1.isSelected = true;
lbl25:
                    // 2 sources

                    var1_2 = this.sendReadBinary(0, 8, false);
                }
                if (var1_2 == null) ** GOTO lbl60
                if (((Object)var1_2).length != 8) ** GOTO lbl60
                var2_5 = v2;
                v2 = new ByteArrayInputStream((byte[])var1_2);
                var3_7 = v3;
                v3 = new TLVInputStream((InputStream)var2_5);
                if (v3.readTag() != 66) break block20;
                var2_6 = 36;
                {
                    catch (Throwable v4) {
                        var3_7.close();
                        throw v4;
                    }
                }
            }
            v5 = var1_2;
            var4_8 = var3_7.readLength();
            var2_6 = ((Object)v5).length - var2_5.available() + var4_8;
            var4_9 = v6;
            v7 = var3_7;
            v8 = var4_9;
            v8(this.selectedFID, var2_6);
            v8.addFragment(0, (byte[])var1_2);
            this.fileInfos.put(this.selectedFID, var4_9);
            try {
                v7.close();
                return v6;
lbl60:
                // 2 sources

                DefaultFileSystem.LOGGER.warning("Something is wrong with prefix, prefix = " + Arrays.toString((byte[])var1_2));
                return null;
            }
            catch (IOException var1_4) {
                throw new CardServiceException("Error getting file info for " + Integer.toHexString(this.selectedFID), (Throwable)var1_4);
            }
        }
        throw new CardServiceException("No file selected");
    }

    public void setWrapper(APDUWrapper aPDUWrapper) {
        this.wrapper = aPDUWrapper;
    }

    public synchronized FileInfo[] getSelectedPath() {
        FileInfo[] fileInfoArray;
        if ((this = this.getFileInfo()) == null) {
            fileInfoArray = this = null;
        } else {
            FileInfo[] fileInfoArray2 = new DefaultFileInfo[1];
            fileInfoArray = fileInfoArray2;
            fileInfoArray2[0] = this;
        }
        return fileInfoArray;
    }

    public synchronized void selectFile(short s2) {
        if (this.selectedFID != s2) {
            DefaultFileSystem defaultFileSystem = this;
            defaultFileSystem.selectedFID = s2;
            defaultFileSystem.isSelected = false;
        }
    }

    /*
     * Unable to fully structure code
     */
    public synchronized byte[] readBinary(int var1_1, int var2_4) {
        block22: {
            block21: {
                var3_10 = null;
                if (this.selectedFID <= 0) ** GOTO lbl58
                var3_10 = this.getFileInfo();
                if (var3_10 == null) ** GOTO lbl57
                var4_11 = var3_10.getSmallestUnbufferedFragment(var1_1, var2_4);
                if (var4_11.getLength() <= 0) ** GOTO lbl50
                if (!this.isSFIEnabled || var1_1 >= 256) ** GOTO lbl25
                var2_5 = this.fidToSFI.get(this.selectedFID);
                if (var2_5 == null) ** GOTO lbl24
                var2_6 = 128;
                v0 = var2_5;
                var2_7 = this.sendReadBinary(v0 & 255 | var2_6, var4_11.getOffset(), var4_11.getLength(), false);
                this.isSelected = true;
                break block21;
lbl24:
                // 1 sources

                throw new NumberFormatException("Unknown FID " + Integer.toHexString(this.selectedFID));
lbl25:
                // 1 sources

                if (this.isSelected) ** GOTO lbl30
                v1 = this;
                v1.sendSelectFile(v1.selectedFID);
                v1.isSelected = true;
lbl30:
                // 2 sources

                v2 = var1_1;
                v3 = var4_11;
                v4 = v3;
                var2_4 = v3.getOffset();
                var5_12 = v4.getLength();
                var6_14 = v2 > 32767;
                var2_7 = this.sendReadBinary(var2_4, var5_12, var6_14);
            }
            if (var2_7 == null) break block22;
            if (var2_7.length <= 0) ** GOTO lbl45
            var3_10.addFragment(var4_11.getOffset(), var2_7);
lbl45:
            // 2 sources

            var2_4 = var2_7.length;
            ** GOTO lbl50
        }
        throw new IllegalStateException("Could not read bytes");
lbl50:
        // 2 sources

        v5 = var2_4;
        var4_11 = var3_10.getBuffer();
        var5_13 = new byte[v5];
        try {
            System.arraycopy(var4_11, var1_1, var5_13, 0, var2_4);
            return var5_13;
lbl57:
            // 1 sources

            throw new IllegalStateException("Could not get file info");
lbl58:
            // 1 sources

            throw new CardServiceException("No file selected");
        }
        catch (Exception var1_2) {
            var4_11 = new StringBuilder().append("Read binary failed on file ");
            if (var3_10 == null) {
                var3_10 = Integer.toHexString(this.selectedFID);
            }
            v6 = var2_8;
            v6(var4_11.append(var3_10).toString(), (Throwable)var1_2);
            throw v6;
        }
        catch (CardServiceException var1_3) {
            var4_11 = new StringBuilder().append("Read binary failed on file ");
            if (var3_10 == null) {
                var3_10 = Integer.toHexString(this.selectedFID);
            }
            v7 = var2_9;
            v8 = var1_3;
            v7(var4_11.append(var3_10).toString(), (Throwable)v8, v8.getSW());
            throw v7;
        }
    }

    public synchronized void sendSelectFile(short s2) {
        this.service.sendSelectFile(this.wrapper, s2);
    }

    public synchronized byte[] sendReadBinary(int n2, int n3, boolean bl) {
        return this.service.sendReadBinary(this.wrapper, -1, n2, n3, false, bl);
    }

    public synchronized byte[] sendReadBinary(int n2, int n3, int n4, boolean bl) {
        return this.service.sendReadBinary(this.wrapper, n2, n3, n4, true, bl);
    }

    public static class DefaultFileInfo
    extends FileInfo
    implements Serializable {
        public static final long serialVersionUID = 6727369753765119839L;
        public short fid;
        public FragmentBuffer buffer;

        public DefaultFileInfo(short s2, int n2) {
            DefaultFileInfo defaultFileInfo = this;
            defaultFileInfo.fid = s2;
            defaultFileInfo.buffer = new FragmentBuffer(n2);
        }

        public byte[] getBuffer() {
            return this.buffer.getBuffer();
        }

        public short getFID() {
            return this.fid;
        }

        public int getFileLength() {
            return this.buffer.getLength();
        }

        public String toString() {
            return Integer.toHexString(this.fid);
        }

        public FragmentBuffer.Fragment getSmallestUnbufferedFragment(int n2, int n3) {
            return this.buffer.getSmallestUnbufferedFragment(n2, n3);
        }

        public void addFragment(int n2, byte[] byArray) {
            this.buffer.addFragment(n2, byArray);
        }
    }
}

