/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.cert;

import java.io.IOException;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPublicKeySpec;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.scuba.data.Country;
import org.ejbca.cvc.AccessRightEnum;
import org.ejbca.cvc.AlgorithmUtil;
import org.ejbca.cvc.AuthorizationRoleEnum;
import org.ejbca.cvc.CAReferenceField;
import org.ejbca.cvc.CVCPublicKey;
import org.ejbca.cvc.CVCertificate;
import org.ejbca.cvc.CVCertificateBody;
import org.ejbca.cvc.HolderReferenceField;
import org.ejbca.cvc.ReferenceField;
import org.ejbca.cvc.exception.ConstructionException;
import org.jmrtd.cert.CVCAuthorizationTemplate;
import org.jmrtd.cert.CVCPrincipal;

public class CardVerifiableCertificate
extends Certificate {
    public static final long serialVersionUID = -3585440601605666288L;
    public static final Logger LOGGER = Logger.getLogger("org.jmrtd");
    public CVCertificate cvCertificate;
    public transient KeyFactory rsaKeyFactory;

    public CardVerifiableCertificate(CVCertificate cVCertificate) {
        super("CVC");
        try {
            this.rsaKeyFactory = KeyFactory.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            LOGGER.log(Level.WARNING, "Exception", noSuchAlgorithmException);
        }
        this.cvCertificate = cVCertificate;
    }

    public CardVerifiableCertificate(CVCPrincipal serializable, CVCPrincipal object, PublicKey publicKey, String string, Date date, Date date2, CVCAuthorizationTemplate.Role enum_, CVCAuthorizationTemplate.Permission object2, byte[] byArray) {
        CVCertificateBody cVCertificateBody;
        HolderReferenceField holderReferenceField;
        CAReferenceField cAReferenceField;
        CardVerifiableCertificate cardVerifiableCertificate = serializable2;
        serializable2(null);
        Serializable serializable2 = cAReferenceField;
        try {
            cAReferenceField = new CAReferenceField(serializable.getCountry().toAlpha2Code(), serializable.getMnemonic(), serializable.getSeqNumber());
        }
        catch (ConstructionException constructionException) {
            throw new IllegalArgumentException(constructionException);
        }
        serializable = holderReferenceField;
        holderReferenceField = new HolderReferenceField(((CVCPrincipal)object).getCountry().toAlpha2Code(), ((CVCPrincipal)object).getMnemonic(), ((CVCPrincipal)object).getSeqNumber());
        object = CVCAuthorizationTemplate.fromRole((CVCAuthorizationTemplate.Role)enum_);
        enum_ = CVCAuthorizationTemplate.fromPermission(object2);
        object2 = cVCertificateBody;
        cVCertificateBody = new CVCertificateBody((CAReferenceField)serializable2, org.ejbca.cvc.KeyFactory.createInstance(publicKey, string, (AuthorizationRoleEnum)object), (HolderReferenceField)serializable, (AuthorizationRoleEnum)object, (AccessRightEnum)enum_, date, date2);
        cardVerifiableCertificate.cvCertificate = new CVCertificate((CVCertificateBody)object2);
        cardVerifiableCertificate.cvCertificate.setSignature(byArray);
        cardVerifiableCertificate.cvCertificate.getTBS();
    }

    public String getSigAlgName() {
        try {
            return AlgorithmUtil.getAlgorithmName(this.cvCertificate.getCertificateBody().getPublicKey().getObjectIdentifier());
        }
        catch (NoSuchFieldException noSuchFieldException) {
            LOGGER.log(Level.WARNING, "No such field", noSuchFieldException);
            return null;
        }
    }

    public String getSigAlgOID() {
        try {
            return this.cvCertificate.getCertificateBody().getPublicKey().getObjectIdentifier().getAsText();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            LOGGER.log(Level.WARNING, "No such field", noSuchFieldException);
            return null;
        }
    }

    @Override
    public byte[] getEncoded() {
        try {
            return this.cvCertificate.getDEREncoded();
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException(iOException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PublicKey getPublicKey() {
        try {
            Serializable serializable;
            CVCPublicKey cVCPublicKey = ((CardVerifiableCertificate)serializable).cvCertificate.getCertificateBody().getPublicKey();
            if (!"RSA".equals(cVCPublicKey.getAlgorithm())) {
                return cVCPublicKey;
            }
            CardVerifiableCertificate cardVerifiableCertificate = serializable;
            serializable = (RSAPublicKey)((Object)cVCPublicKey);
            try {
                return cardVerifiableCertificate.rsaKeyFactory.generatePublic(new RSAPublicKeySpec(serializable.getModulus(), serializable.getPublicExponent()));
            }
            catch (GeneralSecurityException generalSecurityException) {
                LOGGER.log(Level.WARNING, "Exception", generalSecurityException);
                return cVCPublicKey;
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            LOGGER.log(Level.WARNING, "No such field", noSuchFieldException);
            return null;
        }
    }

    @Override
    public String toString() {
        return this.cvCertificate.toString();
    }

    @Override
    public void verify(PublicKey publicKey) {
        Provider[] providerArray = Security.getProviders();
        boolean bl = false;
        for (Provider provider : providerArray) {
            try {
                this.cvCertificate.verify(publicKey, provider.getName());
                bl = true;
                break;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                LOGGER.log(Level.FINE, "Trying next provider", noSuchAlgorithmException);
            }
        }
        if (bl) {
            return;
        }
        throw new NoSuchAlgorithmException("Tried all security providers: None was able to provide this signature algorithm.");
    }

    @Override
    public void verify(PublicKey publicKey, String string) {
        this.cvCertificate.verify(publicKey, string);
    }

    public byte[] getCertBodyData() {
        try {
            return this.cvCertificate.getCertificateBody().getDEREncoded();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new CertificateException("No such field", noSuchFieldException);
        }
    }

    public Date getNotBefore() {
        try {
            return this.cvCertificate.getCertificateBody().getValidFrom();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new CertificateException("No such field", noSuchFieldException);
        }
    }

    public Date getNotAfter() {
        try {
            return this.cvCertificate.getCertificateBody().getValidTo();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new CertificateException("No such field", noSuchFieldException);
        }
    }

    public CVCPrincipal getAuthorityReference() {
        try {
            Serializable serializable = ((CardVerifiableCertificate)serializable).cvCertificate.getCertificateBody().getAuthorityReference();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new CertificateException("No such field", noSuchFieldException);
        }
        Country country = Country.getInstance((String)((ReferenceField)serializable).getCountry().toUpperCase());
        return new CVCPrincipal(country, ((ReferenceField)serializable).getMnemonic(), ((ReferenceField)serializable).getSequence());
    }

    public CVCPrincipal getHolderReference() {
        try {
            Serializable serializable = ((CardVerifiableCertificate)serializable).cvCertificate.getCertificateBody().getHolderReference();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new CertificateException("No such field", noSuchFieldException);
        }
        return new CVCPrincipal(Country.getInstance((String)((ReferenceField)serializable).getCountry().toUpperCase()), ((ReferenceField)serializable).getMnemonic(), ((ReferenceField)serializable).getSequence());
    }

    public CVCAuthorizationTemplate getAuthorizationTemplate() {
        try {
            Serializable serializable = serializable.cvCertificate.getCertificateBody().getAuthorizationTemplate();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new CertificateException("No such field", noSuchFieldException);
        }
        return new CVCAuthorizationTemplate((org.ejbca.cvc.CVCAuthorizationTemplate)serializable);
    }

    public byte[] getSignature() {
        try {
            return this.cvCertificate.getSignature();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new CertificateException("No such field", noSuchFieldException);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean equals(Object object) {
        if (object == null) return false;
        if (this == object) {
            return true;
        }
        if (!CardVerifiableCertificate.class.equals(object.getClass())) return false;
        boolean bl = this.cvCertificate.equals(((CardVerifiableCertificate)object).cvCertificate);
        return bl;
    }

    @Override
    public int hashCode() {
        return this.cvCertificate.hashCode() * 2 - 1030507011;
    }
}

