/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.lds.iso19794;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.jmrtd.cbeff.BiometricDataBlock;
import org.jmrtd.cbeff.StandardBiometricHeader;
import org.jmrtd.lds.AbstractListInfo;
import org.jmrtd.lds.iso19794.FaceImageInfo;

public class FaceInfo
extends AbstractListInfo<FaceImageInfo>
implements BiometricDataBlock {
    public static final long serialVersionUID = -6053206262773400725L;
    public static final Logger LOGGER = Logger.getLogger("org.jmrtd");
    public static final int FORMAT_IDENTIFIER = 1178682112;
    public static final int VERSION_NUMBER = 0x30313000;
    public static final int FORMAT_OWNER_VALUE = 257;
    public static final int FORMAT_TYPE_VALUE = 8;
    public StandardBiometricHeader sbh;

    public FaceInfo(List<FaceImageInfo> list) {
        this(null, list);
    }

    public FaceInfo(StandardBiometricHeader standardBiometricHeader, List<FaceImageInfo> list) {
        this.sbh = standardBiometricHeader;
        this.addAll(list);
    }

    public FaceInfo(InputStream inputStream) {
        this(null, inputStream);
    }

    public FaceInfo(StandardBiometricHeader standardBiometricHeader, InputStream inputStream) {
        this.sbh = standardBiometricHeader;
        this.readObject(inputStream);
    }

    @Override
    public void readObject(InputStream inputStream) {
        DataInputStream dataInputStream;
        if (inputStream instanceof DataInputStream) {
            dataInputStream = (DataInputStream)inputStream;
        } else {
            DataInputStream dataInputStream2;
            dataInputStream = dataInputStream2;
            dataInputStream2 = new DataInputStream(inputStream);
        }
        int n2 = dataInputStream.readInt();
        if (n2 == 1178682112) {
            n2 = dataInputStream.readInt();
            if (n2 == 0x30313000) {
                DataInputStream dataInputStream3 = dataInputStream;
                long l2 = ((long)dataInputStream3.readInt() & 0xFFFFFFFFL) - 14L;
                long l3 = 0L;
                int n3 = dataInputStream3.readUnsignedShort();
                for (int i2 = 0; i2 < n3; ++i2) {
                    FaceImageInfo faceImageInfo;
                    FaceImageInfo faceImageInfo2;
                    FaceImageInfo faceImageInfo3 = faceImageInfo2 = faceImageInfo;
                    faceImageInfo3(inputStream);
                    l3 += faceImageInfo3.getRecordLength();
                    this.add(faceImageInfo);
                }
                if (l2 != l3) {
                    LOGGER.warning("ConstructedDataLength and dataLength differ: dataLength = " + l2 + ", constructedDataLength = " + l3);
                }
                return;
            }
            throw new IllegalArgumentException("'010' version number expected! Found " + Integer.toHexString(n2));
        }
        throw new IllegalArgumentException("'FAC' marker expected! Found " + Integer.toHexString(n2));
    }

    @Override
    public void writeObject(OutputStream object) {
        DataOutputStream dataOutputStream;
        int n2 = 14;
        long l2 = 0L;
        List list = this.getSubRecords();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            l2 += ((FaceImageInfo)iterator.next()).getRecordLength();
        }
        l2 = (long)n2 + l2;
        if (object instanceof DataOutputStream) {
            dataOutputStream = (DataOutputStream)object;
        } else {
            DataOutputStream dataOutputStream2;
            dataOutputStream = dataOutputStream2;
            dataOutputStream2 = new DataOutputStream((OutputStream)object);
        }
        DataOutputStream dataOutputStream3 = dataOutputStream;
        dataOutputStream3.writeInt(1178682112);
        dataOutputStream3.writeInt(0x30313000);
        dataOutputStream.writeInt((int)(l2 & 0xFFFFFFFFL));
        dataOutputStream.writeShort(list.size());
        object = list.iterator();
        while (object.hasNext()) {
            ((FaceImageInfo)object.next()).writeObject(dataOutputStream);
        }
    }

    @Override
    public StandardBiometricHeader getStandardBiometricHeader() {
        if (this.sbh == null) {
            TreeMap<Integer, byte[]> treeMap;
            byte[] byArray = new byte[1];
            byte[] byArray2 = byArray;
            byArray[0] = 2;
            byte[] byArray3 = new byte[1];
            byte[] byArray4 = byArray3;
            byArray3[0] = 0;
            byte[] byArray5 = new byte[2];
            byte[] byArray6 = byArray5;
            byArray5[0] = 1;
            byArray5[1] = 1;
            byte[] byArray7 = new byte[2];
            byte[] byArray8 = byArray7;
            byArray7[0] = 0;
            byArray7[1] = 8;
            TreeMap<Integer, byte[]> treeMap2 = treeMap;
            new TreeMap<Integer, byte[]>().put(129, byArray2);
            treeMap2.put(130, byArray4);
            treeMap2.put(135, byArray6);
            treeMap2.put(136, byArray8);
            this.sbh = new StandardBiometricHeader(treeMap2);
        }
        return this.sbh;
    }

    public List<FaceImageInfo> getFaceImageInfos() {
        return this.getSubRecords();
    }

    public void addFaceImageInfo(FaceImageInfo faceImageInfo) {
        this.add(faceImageInfo);
    }

    public void removeFaceImageInfo(int n2) {
        this.remove(n2);
    }
}

