/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.protocol;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.util.List;
import javax.crypto.interfaces.DHPublicKey;
import net.sf.scuba.smartcards.CardServiceException;
import net.sf.scuba.tlv.TLVOutputStream;
import net.sf.scuba.tlv.TLVUtil;
import org.eid_bc.bouncycastle.jce.interfaces.ECPrivateKey;
import org.eid_bc.bouncycastle.jce.interfaces.ECPublicKey;
import org.jmrtd.APDULevelEACTACapable;
import org.jmrtd.Util;
import org.jmrtd.cert.CVCAuthorizationTemplate;
import org.jmrtd.cert.CVCPrincipal;
import org.jmrtd.cert.CardVerifiableCertificate;
import org.jmrtd.lds.icao.MRZInfo;
import org.jmrtd.protocol.EACCAResult;
import org.jmrtd.protocol.EACTAResult;
import org.jmrtd.protocol.PACEResult;
import org.jmrtd.protocol.SecureMessagingWrapper;

public class EACTAProtocol {
    public static final int TAG_CVCERTIFICATE_SIGNATURE = 24375;
    public static final Provider BC_PROVIDER = Util.getBouncyCastleProvider();
    public APDULevelEACTACapable service;
    public SecureMessagingWrapper wrapper;

    public EACTAProtocol(APDULevelEACTACapable aPDULevelEACTACapable, SecureMessagingWrapper secureMessagingWrapper) {
        this.service = aPDULevelEACTACapable;
        this.wrapper = secureMessagingWrapper;
    }

    public static byte[] deriveIdentifier(String string) {
        byte by;
        int n2 = string.length();
        byte[] byArray = new byte[n2 + 1];
        byte[] byArray2 = byArray;
        try {
            int n3 = n2;
            String string2 = string;
            System.arraycopy(string2.getBytes("ISO-8859-1"), 0, byArray2, 0, n2);
            by = (byte)MRZInfo.checkDigit(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException("Unsupported encoding", unsupportedEncodingException);
        }
        byArray[n3] = by;
        return byArray;
    }

    public static byte[] deriveIdentifier(PACEResult object) {
        PACEResult pACEResult = object;
        object = pACEResult.getAgreementAlg();
        PublicKey publicKey = pACEResult.getPICCPublicKey();
        if ("DH".equals(object)) {
            return MessageDigest.getInstance("SHA-1").digest(EACTAProtocol.getKeyData((String)object, publicKey));
        }
        if ("ECDH".equals(object)) {
            object = (ECPublicKey)publicKey;
            return Util.alignKeyDataToSize(Util.i2os(object.getQ().getAffineXCoord().toBigInteger()), (int)Math.ceil((double)object.getParameters().getCurve().getFieldSize() / 8.0));
        }
        throw new NoSuchAlgorithmException("Unsupported agreement algorithm " + (String)object);
    }

    public static byte[] getKeyData(String string, PublicKey publicKey) {
        if ("DH".equals(string)) {
            return ((DHPublicKey)publicKey).getY().toByteArray();
        }
        if ("ECDH".equals(string)) {
            return ((ECPublicKey)publicKey).getQ().getEncoded(false);
        }
        throw new IllegalArgumentException("Unsupported agreement algorithm " + string);
    }

    public synchronized EACTAResult doEACTA(CVCPrincipal cVCPrincipal, List<CardVerifiableCertificate> list, PrivateKey privateKey, String string, EACCAResult eACCAResult, String string2) {
        return this.doTA(cVCPrincipal, list, privateKey, string, eACCAResult, EACTAProtocol.deriveIdentifier(string2));
    }

    public synchronized EACTAResult doTA(CVCPrincipal cVCPrincipal, List<CardVerifiableCertificate> list, PrivateKey privateKey, String string, EACCAResult eACCAResult, PACEResult pACEResult) {
        try {
            return this.doTA(cVCPrincipal, list, privateKey, string, eACCAResult, EACTAProtocol.deriveIdentifier(pACEResult));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CardServiceException("No such algorithm", (Throwable)noSuchAlgorithmException);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public synchronized EACTAResult doTA(CVCPrincipal var1_3, List<CardVerifiableCertificate> var2_4, PrivateKey var3_5, String var4_6, EACCAResult var5_7, byte[] var6_8) {
        block26: {
            block25: {
                if (var2_4 == null) throw new IllegalArgumentException("Need at least 1 certificate to perform TA, found: " + var2_4);
                if (var2_4.isEmpty() != false) throw new IllegalArgumentException("Need at least 1 certificate to perform TA, found: " + var2_4);
                v0 = var5_7.getKeyHash();
                var4_6 = v0;
                if (v0 == null) throw new IllegalArgumentException("CA key hash is null");
                var7_9 = var2_4.get(0);
                if (!CVCAuthorizationTemplate.Role.CVCA.equals((Object)var7_9.getAuthorizationTemplate().getRole())) break block25;
                var8_10 /* !! */  = var7_9.getHolderReference();
                if (var1_3 != null) {
                    if (var1_3.equals(var8_10 /* !! */ ) == false) throw new CardServiceException("First certificate holds wrong authority, found \"" + var8_10 /* !! */ .getName() + "\", expected \"" + var1_3.getName() + "\"");
                }
                if (var1_3 != null) {
                    var8_10 /* !! */  = var1_3;
                }
                var2_4.remove(0);
                break block26;
            }
            var8_10 /* !! */  = var1_3;
        }
        var1_3 = var7_9.getAuthorityReference();
        if (var8_10 /* !! */  != null) {
            if (var8_10 /* !! */ .equals(var1_3) == false) throw new CardServiceException("First certificate not signed by expected CA, found " + var1_3.getName() + ", expected " + var8_10 /* !! */ .getName());
        }
        if (var8_10 /* !! */  != null) {
            var1_3 = var8_10 /* !! */ ;
        }
        v1 = var2_4;
        v2 = v1;
        v3 = v1.size();
        var7_9 = v2.get(v3 - 1);
        var8_10 /* !! */  = var7_9.getAuthorizationTemplate().getRole();
        if (CVCAuthorizationTemplate.Role.IS.equals(var8_10 /* !! */ ) == false) throw new CardServiceException("Last certificate in chain (" + var7_9.getHolderReference().getName() + ") does not have role IS, but has role " + var8_10 /* !! */ );
        var8_10 /* !! */  = var2_4.iterator();
        while (var8_10 /* !! */ .hasNext()) {
            v4 = this;
            v5 = (CardVerifiableCertificate)var8_10 /* !! */ .next();
        }
        ** GOTO lbl62
        {
            var9_11 = TLVUtil.wrapDO((int)131, (byte[])v5.getAuthorityReference().getName().getBytes("ISO-8859-1"));
            this.service.sendMSESetDST(this.wrapper, (byte[])var9_11);
            var9_11 = v5.getCertBodyData();
            var10_12 = v5.getSignature();
            var11_13 = v6;
            v6 = new ByteArrayOutputStream();
            try {
                v7 = new TLVOutputStream((OutputStream)var11_13);
                v7.writeTag(24375);
                v7.writeValue(var10_12);
                v7.close();
                var10_12 = v6.toByteArray();
                v4.service.sendPSOExtendedLengthMode(this.wrapper, (byte[])var9_11, var10_12);
                continue;
            }
            catch (Exception var0_1) {
                throw new CardServiceException("Exception", (Throwable)var0_1);
                catch (CardServiceException v8) {
                    throw v8;
                }
lbl62:
                // 1 sources

                if (var3_5 == null) throw new CardServiceException("No terminal key");
                v9 = var7_9;
                v10 = this;
                var8_10 /* !! */  = (CVCPrincipal)TLVUtil.wrapDO((int)131, (byte[])var7_9.getHolderReference().getName().getBytes("ISO-8859-1"));
                v10.service.sendMSESetATExtAuth(this.wrapper, (byte[])var8_10 /* !! */ );
                var8_10 /* !! */  = (CVCPrincipal)v10.service.sendGetChallenge(this.wrapper);
                var9_11 = v11;
                var9_11();
                var9_11.write((byte[])var6_8);
                var9_11.write((byte[])var8_10 /* !! */ );
                v11.write((byte[])var4_6);
                v11.close();
                var4_6 = v11.toByteArray();
                var6_8 = v9.getSigAlgName();
                if (var6_8 == null) throw new IllegalStateException("Could not determine signature algorithm for terminal certificate " + var7_9.getHolderReference().getName());
                v12 = var6_8;
                v13 = v12;
                v14 = Signature.getInstance((String)v12, EACTAProtocol.BC_PROVIDER);
                v14.initSign(var3_5);
                v14.update((byte[])var4_6);
                var4_6 = v14.sign();
                if (!v13.toUpperCase().endsWith("ECDSA")) ** GOTO lbl93
                v15 = var4_6;
                v16 = ((ECPrivateKey)var3_5).getParameters().getCurve().getFieldSize();
                v17 = (int)Math.ceil(v16 / 8.0);
                var4_6 = Util.getRawECDSASignature((byte[])v15, v17);
lbl93:
                // 2 sources

                this.service.sendMutualAuthenticate(this.wrapper, (byte[])var4_6);
                try {
                    return new EACTAResult(var5_7, var1_3, var2_4, var3_5, null, (byte[])var8_10 /* !! */ );
                }
                catch (Exception var0_2) {
                    throw new CardServiceException("Exception", (Throwable)var0_2);
                }
                catch (CardServiceException v18) {
                    throw v18;
                    break;
                }
            }
        }
    }
}

