/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.protocol;

import java.io.Serializable;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECPoint;
import org.jmrtd.protocol.PACEGMMappingResult;

public class PACEGMWithECDHMappingResult
extends PACEGMMappingResult {
    public static final long serialVersionUID = -3892431861957032423L;
    public BigInteger sharedSecretPointX;
    public BigInteger sharedSecretPointY;

    public PACEGMWithECDHMappingResult(AlgorithmParameterSpec algorithmParameterSpec, byte[] byArray, PublicKey publicKey, KeyPair keyPair, ECPoint eCPoint, AlgorithmParameterSpec algorithmParameterSpec2) {
        super(algorithmParameterSpec, byArray, publicKey, keyPair, algorithmParameterSpec2);
        this.sharedSecretPointX = eCPoint.getAffineX();
        this.sharedSecretPointY = eCPoint.getAffineY();
    }

    public ECPoint getSharedSecretPoint() {
        return new ECPoint(this.sharedSecretPointX, this.sharedSecretPointY);
    }

    @Override
    public int hashCode() {
        PACEGMWithECDHMappingResult pACEGMWithECDHMappingResult = this;
        int n2 = super.hashCode() * 31;
        BigInteger bigInteger = pACEGMWithECDHMappingResult.sharedSecretPointX;
        int n3 = bigInteger == null ? 0 : bigInteger.hashCode();
        int n4 = n2 + n3;
        BigInteger bigInteger2 = this.sharedSecretPointY;
        int n5 = bigInteger2 == null ? 0 : bigInteger2.hashCode();
        return n4 + n5;
    }

    @Override
    public boolean equals(Object object) {
        if (serializable == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (PACEGMWithECDHMappingResult.class != object.getClass()) {
            return false;
        }
        object = (PACEGMWithECDHMappingResult)object;
        BigInteger bigInteger = ((PACEGMWithECDHMappingResult)serializable).sharedSecretPointX;
        if (bigInteger == null ? ((PACEGMWithECDHMappingResult)object).sharedSecretPointX != null : !bigInteger.equals(((PACEGMWithECDHMappingResult)object).sharedSecretPointX)) {
            return false;
        }
        Serializable serializable = ((PACEGMWithECDHMappingResult)serializable).sharedSecretPointY;
        return !(serializable == null ? ((PACEGMWithECDHMappingResult)object).sharedSecretPointY != null : !((BigInteger)serializable).equals(((PACEGMWithECDHMappingResult)object).sharedSecretPointY));
    }
}

