/*
 * Decompiled with CFR 0.152.
 */
package net.sf.scuba.smartcards;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.nfc.Tag;
import android.nfc.tech.IsoDep;
import android.nfc.tech.NfcA;
import android.nfc.tech.NfcB;
import android.os.Build;
import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.scuba.smartcards.APDUEvent;
import net.sf.scuba.smartcards.CardService;
import net.sf.scuba.smartcards.CardServiceException;
import net.sf.scuba.smartcards.CommandAPDU;
import net.sf.scuba.smartcards.ResponseAPDU;

public class IsoDepCardService
extends CardService {
    private static final Logger LOGGER = Logger.getLogger("net.sf.scuba");
    private IsoDep isoDep;
    private int apduCount;

    public IsoDepCardService(IsoDep isoDep) {
        this.isoDep = isoDep;
        this.apduCount = 0;
    }

    @Override
    @SuppressLint(value={"MissingPermission"})
    public void open() throws CardServiceException {
        if (!this.isOpen()) {
            try {
                this.isoDep.connect();
                if (!this.isoDep.isConnected()) {
                    throw new CardServiceException("Failed to connect");
                }
                this.state = 1;
            }
            catch (IOException var2) {
                LOGGER.log(Level.WARNING, "Failed to connect", var2);
                throw new CardServiceException(var2.toString());
            }
        }
    }

    @Override
    public boolean isOpen() {
        if (this.isoDep.isConnected()) {
            this.state = 1;
            return true;
        }
        this.state = 0;
        return false;
    }

    @Override
    @SuppressLint(value={"MissingPermission"})
    public ResponseAPDU transmit(CommandAPDU ourCommandAPDU) throws CardServiceException {
        try {
            if (!this.isoDep.isConnected()) {
                throw new CardServiceException("Not connected");
            }
            byte[] responseBytes = this.isoDep.transceive(ourCommandAPDU.getBytes());
            if (responseBytes != null && responseBytes.length >= 2) {
                ResponseAPDU ourResponseAPDU = new ResponseAPDU(responseBytes);
                this.notifyExchangedAPDU(new APDUEvent(this, (Serializable)((Object)"ISODep"), ++this.apduCount, ourCommandAPDU, ourResponseAPDU));
                return ourResponseAPDU;
            }
            throw new CardServiceException("Failed response");
        }
        catch (IOException var4) {
            throw new CardServiceException(var4.getMessage());
        }
        catch (Exception var5) {
            throw new CardServiceException(var5.getMessage());
        }
    }

    @Override
    public byte[] getATR() {
        if (this.isoDep == null) {
            return null;
        }
        Tag tag = this.isoDep.getTag();
        if (tag == null) {
            return null;
        }
        NfcA nfcA = NfcA.get((Tag)tag);
        if (nfcA != null) {
            return this.isoDep.getHistoricalBytes();
        }
        NfcB nfcB = NfcB.get((Tag)tag);
        return nfcB != null ? this.isoDep.getHiLayerResponse() : this.isoDep.getHistoricalBytes();
    }

    @Override
    @TargetApi(value=16)
    public boolean isExtendedAPDULengthSupported() {
        if (Build.VERSION.SDK_INT >= 16) {
            return this.isoDep.isExtendedLengthApduSupported();
        }
        int maxTranceiveLength = this.isoDep.getMaxTransceiveLength();
        return maxTranceiveLength > 261;
    }

    @Override
    public void close() {
        try {
            this.isoDep.close();
            this.state = 0;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean isConnectionLost(Exception e) {
        if (e == null) {
            return false;
        }
        String exceptionClassName = e.getClass().getName();
        if (exceptionClassName != null && exceptionClassName.contains("TagLostException")) {
            return true;
        }
        String message = e.getMessage();
        if (message == null) {
            message = "";
        }
        return message.toLowerCase().contains("tag was lost");
    }
}

