/*
 * Decompiled with CFR 0.152.
 */
package net.sf.scuba.tlv;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.scuba.tlv.TLVInputStream;
import net.sf.scuba.tlv.TLVOutputStream;

public class TLVUtil {
    private static final Logger LOGGER = Logger.getLogger("net.sf.scuba");

    private TLVUtil() {
    }

    public static boolean isPrimitive(int tag) {
        int mask;
        int i;
        for (i = 3; i >= 0 && (tag & (mask = 255 << 8 * i)) == 0; --i) {
        }
        mask = (tag & 255 << 8 * i) >> 8 * i & 0xFF;
        return (mask & 0x20) == 0;
    }

    public static int getTagLength(int tag) {
        return TLVUtil.getTagAsBytes(tag).length;
    }

    public static int getLengthLength(int length) {
        return TLVUtil.getLengthAsBytes(length).length;
    }

    public static byte[] getTagAsBytes(int tag) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int byteCount = (int)(Math.log(tag) / Math.log(256.0)) + 1;
        for (int i = 0; i < byteCount; ++i) {
            int pos = 8 * (byteCount - i - 1);
            out.write((tag & 255 << pos) >> pos);
        }
        byte[] tagBytes = out.toByteArray();
        switch (TLVUtil.getTagClass(tag)) {
            case 1: {
                tagBytes[0] = (byte)(tagBytes[0] | 0x40);
                break;
            }
            case 2: {
                tagBytes[0] = (byte)(tagBytes[0] | 0x80);
                break;
            }
            case 3: {
                tagBytes[0] = (byte)(tagBytes[0] | 0xC0);
            }
        }
        if (!TLVUtil.isPrimitive(tag)) {
            tagBytes[0] = (byte)(tagBytes[0] | 0x20);
        }
        return tagBytes;
    }

    public static byte[] getLengthAsBytes(int length) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (length < 128) {
            out.write(length);
        } else {
            int byteCount = TLVUtil.log(length, 256);
            out.write(0x80 | byteCount);
            for (int i = 0; i < byteCount; ++i) {
                int pos = 8 * (byteCount - i - 1);
                out.write((length & 255 << pos) >> pos);
            }
        }
        return out.toByteArray();
    }

    public static byte[] wrapDO(int tag, byte[] data) {
        byte[] var4;
        if (data == null) {
            throw new IllegalArgumentException("Data to wrap is null");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            TLVOutputStream tlvOutputStream = new TLVOutputStream(byteArrayOutputStream);
            tlvOutputStream.writeTag(tag);
            tlvOutputStream.writeValue(data);
            tlvOutputStream.flush();
            tlvOutputStream.close();
            var4 = byteArrayOutputStream.toByteArray();
        }
        catch (IOException var13) {
            throw new IllegalStateException("Error writing stream", var13);
        }
        finally {
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException var12) {
                LOGGER.log(Level.FINE, "Error closing stream", var12);
            }
        }
        return var4;
    }

    public static byte[] unwrapDO(int expectedTag, byte[] wrappedData) {
        if (wrappedData != null && wrappedData.length >= 2) {
            byte[] var8;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(wrappedData);
            TLVInputStream tlvInputStream = new TLVInputStream(byteArrayInputStream);
            try {
                int actualTag = tlvInputStream.readTag();
                if (actualTag != expectedTag) {
                    throw new IllegalArgumentException("Expected tag " + Integer.toHexString(expectedTag) + ", found tag " + Integer.toHexString(actualTag));
                }
                int length = tlvInputStream.readLength();
                byte[] value = tlvInputStream.readValue();
                byte[] result = new byte[length];
                System.arraycopy(value, 0, result, 0, length);
                var8 = result;
            }
            catch (IOException var17) {
                throw new IllegalStateException("Error reading from stream", var17);
            }
            finally {
                try {
                    tlvInputStream.close();
                }
                catch (IOException var16) {
                    LOGGER.log(Level.FINE, "Error closing stream", var16);
                }
            }
            return var8;
        }
        throw new IllegalArgumentException("Wrapped data is null or length < 2");
    }

    static int getTagClass(int tag) {
        int msByte;
        int i;
        for (i = 3; i >= 0 && (tag & (msByte = 255 << 8 * i)) == 0; --i) {
        }
        msByte = (tag & 255 << 8 * i) >> 8 * i & 0xFF;
        switch (msByte & 0xC0) {
            case 0: {
                return 0;
            }
            case 64: {
                return 1;
            }
            case 128: {
                return 2;
            }
        }
        return 3;
    }

    private static int log(int n, int base) {
        int result = 0;
        while (n > 0) {
            n /= base;
            ++result;
        }
        return result;
    }
}

