/*
 * Decompiled with CFR 0.152.
 */
package org.eid_bc.bouncycastle.asn1.cms;

import org.eid_bc.bouncycastle.asn1.ASN1Choice;
import org.eid_bc.bouncycastle.asn1.ASN1Object;
import org.eid_bc.bouncycastle.asn1.ASN1Primitive;
import org.eid_bc.bouncycastle.asn1.ASN1Sequence;
import org.eid_bc.bouncycastle.asn1.ASN1TaggedObject;
import org.eid_bc.bouncycastle.asn1.DERTaggedObject;
import org.eid_bc.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.eid_bc.bouncycastle.asn1.cms.RecipientKeyIdentifier;

public class KeyAgreeRecipientIdentifier
extends ASN1Object
implements ASN1Choice {
    private IssuerAndSerialNumber issuerSerial;
    private RecipientKeyIdentifier rKeyID;

    public static KeyAgreeRecipientIdentifier getInstance(ASN1TaggedObject obj, boolean explicit) {
        return KeyAgreeRecipientIdentifier.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static KeyAgreeRecipientIdentifier getInstance(Object obj) {
        if (obj == null || obj instanceof KeyAgreeRecipientIdentifier) {
            return (KeyAgreeRecipientIdentifier)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new KeyAgreeRecipientIdentifier(IssuerAndSerialNumber.getInstance(obj));
        }
        if (obj instanceof ASN1TaggedObject && ((ASN1TaggedObject)obj).getTagNo() == 0) {
            return new KeyAgreeRecipientIdentifier(RecipientKeyIdentifier.getInstance((ASN1TaggedObject)obj, false));
        }
        throw new IllegalArgumentException("Invalid KeyAgreeRecipientIdentifier: " + obj.getClass().getName());
    }

    public KeyAgreeRecipientIdentifier(IssuerAndSerialNumber issuerSerial) {
        this.issuerSerial = issuerSerial;
        this.rKeyID = null;
    }

    public KeyAgreeRecipientIdentifier(RecipientKeyIdentifier rKeyID) {
        this.issuerSerial = null;
        this.rKeyID = rKeyID;
    }

    public IssuerAndSerialNumber getIssuerAndSerialNumber() {
        return this.issuerSerial;
    }

    public RecipientKeyIdentifier getRKeyID() {
        return this.rKeyID;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        if (this.issuerSerial != null) {
            return this.issuerSerial.toASN1Primitive();
        }
        return new DERTaggedObject(false, 0, this.rKeyID);
    }
}

