/*
 * Decompiled with CFR 0.152.
 */
package net.security.device.api;

import android.app.Activity;
import android.content.Context;
import java.lang.reflect.Method;
import net.security.device.api.LogUtil;
import net.security.device.api.SecurityInitListener;
import net.security.device.api.SecuritySession;
import net.security.device.api.SecuritySessionId;
import net.security.device.api.SecurityToken;
import net.security.device.api.SecurityUtil;
import net.security.device.api.id.DeviceID;
import net.security.device.api.id.IGAID;
import net.security.device.api.id.IGAIDGetter;
import net.security.device.api.id.IOAID;
import net.security.device.api.id.IOAIDGetter;

public class SecurityDevice {
    private Context ctx = null;
    private SecurityInitListener securityInitListener = null;
    private boolean isInited = false;
    private String userAppKey;
    private Thread initThread = null;
    private Thread otherThread = null;
    private static SecurityDevice s_instance;

    public static SecurityDevice getInstance() {
        return s_instance;
    }

    private Context getCtx() {
        return this.ctx;
    }

    public void init(Context ctx, String userAppKey, SecurityInitListener securityInitListener) {
        this.initCommonEx(ctx, userAppKey, securityInitListener, 0);
    }

    public void initV6(Context ctx, String userAppKey, SecurityInitListener securityInitListener) {
        this.initCommonEx(ctx, userAppKey, securityInitListener, 1);
    }

    private void otherThreadRun() {
        this.otiRaw(this.getCtx(), this.userAppKey);
    }

    private void runInitEx(int isIPV6) {
        int retCode = this.initExFirstRaw(this.ctx, this.userAppKey, isIPV6);
        if (null != this.securityInitListener) {
            this.securityInitListener.onInitFinish(retCode);
        }
        switch (retCode) {
            case 10009: 
            case 10010: 
            case 10011: 
            case 10012: {
                this.isInited = false;
                return;
            }
        }
        this.initExSecondRaw(this.ctx, this.userAppKey, isIPV6);
        this.isInited = false;
    }

    private void initCommonEx(Context ctx, String userAppKey, SecurityInitListener securityInitListener, final int isIPv6) {
        if (ctx == null || userAppKey == null || userAppKey.length() != 32) {
            if (null != securityInitListener) {
                securityInitListener.onInitFinish(10010);
            }
            return;
        }
        if (this.isInited) {
            if (null != securityInitListener) {
                securityInitListener.onInitFinish(10000);
            }
            return;
        }
        this.isInited = true;
        this.userAppKey = userAppKey;
        this.ctx = ctx.getApplicationContext();
        this.securityInitListener = securityInitListener;
        this.setAppKeyRaw(this.ctx, this.userAppKey);
        SecurityUtil.utilInit();
        this.initThread = new Thread(new Runnable(){

            @Override
            public void run() {
                SecurityDevice.getInstance().runInitEx(isIPv6);
            }
        });
        this.initThread.start();
        if (this.otherThread == null) {
            this.otherThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    SecurityDevice.getInstance().otherThreadRun();
                }
            });
            this.otherThread.start();
        }
    }

    public SecuritySession getSession() {
        return this.getSessionRaw();
    }

    public SecurityToken getDeviceToken() {
        SecuritySession session = this.getSessionRaw();
        SecurityToken token = new SecurityToken();
        token.code = session.code;
        token.token = session.session;
        return token;
    }

    public void reportUserData(int type, String msg) {
        this.reportUserDataRaw(String.valueOf(10000 + type), msg);
    }

    public void setServer(String url, String host) {
        if (url.isEmpty()) {
            return;
        }
        this.setUrlHostRaw(url, host);
    }

    public void lx() {
        this.lxRaw();
    }

    public void gti() {
        this.gtiRaw();
    }

    public void gte() {
        this.gteRaw();
    }

    public void gtt(int i, String p) {
        this.gttRaw(i, p);
    }

    public void asc(Activity obj) {
        if (this.ctx == null && obj != null) {
            this.ctx = obj.getApplicationContext();
        }
        SecurityDevice.ascRaw(obj);
    }

    public String getVersion() {
        return SecurityDevice.getVersionRaw();
    }

    public boolean getId1() {
        if (this.ctx == null) {
            return false;
        }
        IOAID deviceId = DeviceID.withOAID(this.ctx);
        if (deviceId == null || !deviceId.supportOAID()) {
            return false;
        }
        deviceId.doGet(new IOAIDGetter(){

            @Override
            public void onOAIDGetComplete(String oaid) {
                SecurityDevice.this.setId1(oaid);
            }

            @Override
            public void onOAIDGetError(Exception exception) {
                LogUtil.e("onOAIDGetError: " + exception.toString());
            }
        });
        return true;
    }

    private void setId1(String id1) {
        if (id1 == null || id1.isEmpty()) {
            return;
        }
        this.setId1Raw(id1);
    }

    public boolean getId2() {
        if (this.ctx == null) {
            return false;
        }
        IGAID deviceId = DeviceID.withGAID(this.ctx);
        if (deviceId == null || !deviceId.supportGAID()) {
            return false;
        }
        deviceId.doGet(new IGAIDGetter(){

            @Override
            public void onGAIDGetComplete(String gaid) {
                SecurityDevice.this.setId2(gaid);
            }

            @Override
            public void onGAIDGetError(Exception exception) {
                LogUtil.e("onGAIDGetError: " + exception.toString());
            }
        });
        return true;
    }

    private void setId2(String id2) {
        if (id2 == null || id2.isEmpty()) {
            return;
        }
        this.setId2Raw(id2);
    }

    public SecuritySessionId getSessionId() {
        if (!this.isInited) {
            SecuritySessionId securitySessionId = new SecuritySessionId();
            securitySessionId.code = 10001;
            securitySessionId.sessionId = "";
            return securitySessionId;
        }
        return this.getSessionIdRaw();
    }

    public static long gtam() {
        long ret = 0L;
        try {
            Method reserved0 = SecurityDevice.class.getDeclaredMethod("reserved0", new Class[0]);
            ret = SecurityUtil.getArtMethod(reserved0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    private native int initExFirstRaw(Context var1, String var2, int var3);

    private native int initExSecondRaw(Context var1, String var2, int var3);

    private native SecuritySession getSessionRaw();

    private native SecuritySessionId getSessionIdRaw();

    private native void reportUserDataRaw(String var1, String var2);

    private native void setUrlHostRaw(String var1, String var2);

    private native void setAppKeyRaw(Context var1, String var2);

    public static native void ascRaw(Activity var0);

    public static native String getVersionRaw();

    private native void setId1Raw(String var1);

    private native void setId2Raw(String var1);

    public static native String gsRaw(String var0);

    private native void otiRaw(Context var1, String var2);

    private native void lxRaw();

    public static native void reserved0();

    public static native void reserved1();

    private native void gtiRaw();

    private native void gttRaw(int var1, String var2);

    private native void gteRaw();

    static {
        System.loadLibrary("securitydevice");
        s_instance = new SecurityDevice();
    }
}

