/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.alipaysecuritysdk.api.service;

import com.alipay.alipaysecuritysdk.api.service.LogService;
import com.alipay.alipaysecuritysdk.api.service.ThirdPartyService;
import com.alipay.alipaysecuritysdk.api.service.impl.BaseLogServiceImpl;
import java.util.HashMap;
import java.util.Map;

public class ServiceManager {
    private static String TAG = "ServiceManager";
    private static LogService LOGGER = new BaseLogServiceImpl();
    public static String TYPE_SERVICE_LOG = "KEY_TYPE_SERVICE_LOG";
    public static String TYPE_SERVICE_MDAP = "KEY_TYPE_SERVICE_MDAP";
    public static String TYPE_SERVICE_CONFIG = "KEY_TYPE_SERVICE_CONFIG";
    public static String TYPE_SERVICE_FILE_UPLOAD = "KEY_TYPE_SERVICE_FILE_UPLOAD";
    public static String TYPE_SERVICE_RPC = "KEY_TYPE_SERVICE_RPC";
    public static String TYPE_SERVICE_SYNC = "KEY_TYPE_SERVICE_SYNC";
    private static Map<String, String> serviceClassMap = new HashMap(){
        {
            this.put(TYPE_SERVICE_LOG, "com.alipay.alipaysecuritysdk.mpaas.log.LogServiceImpl");
            this.put(TYPE_SERVICE_MDAP, "com.alipay.alipaysecuritysdk.mpaas.mdap.MdapServiceImpl");
            this.put(TYPE_SERVICE_CONFIG, "com.alipay.alipaysecuritysdk.mpaas.config.ConfigServiceImpl");
            this.put(TYPE_SERVICE_FILE_UPLOAD, "com.alipay.alipaysecuritysdk.mpaas.uploader.FileUploadServiceImpl");
            this.put(TYPE_SERVICE_RPC, "com.alipay.alipaysecuritysdk.mpaas.rpc.RPCServiceImpl");
            this.put(TYPE_SERVICE_SYNC, "com.alipay.alipaysecuritysdk.mpaas.sync.SyncServiceImpl");
        }
    };
    private static Map<String, ThirdPartyService> serviceMap = new HashMap<String, ThirdPartyService>();

    private ServiceManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T extends ThirdPartyService> T getService(String type) {
        String string;
        if (null != serviceMap.get(type)) return (T)serviceMap.get(string);
        Class<ServiceManager> clazz = ServiceManager.class;
        synchronized (ServiceManager.class) {
            if (null != serviceMap.get(type)) return (T)serviceMap.get(string);
            try {
                ThirdPartyService thirdPartyService = (ThirdPartyService)Class.forName(serviceClassMap.get(type)).newInstance();
                serviceMap.put(type, thirdPartyService);
            }
            catch (Throwable throwable) {
                LOGGER.d(TAG, type + " Service Load Failed");
                if (type != TYPE_SERVICE_LOG || null != serviceMap.get(type)) return (T)serviceMap.get(string);
                BaseLogServiceImpl baseLogServiceImpl = new BaseLogServiceImpl();
                serviceMap.put(type, baseLogServiceImpl);
            }
            return (T)serviceMap.get(string);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void setServiceClass(String type, String clazz) {
        String string;
        void var1_1;
        serviceClassMap.put(type, (String)var1_1);
        serviceMap.remove(string);
    }

    public static void checkService() {
        if (null == serviceClassMap.get(TYPE_SERVICE_RPC) || serviceClassMap.get(TYPE_SERVICE_RPC).isEmpty()) {
            throw new IllegalArgumentException("RPC Service is not provided, call APSecuritySdk.getInstance()\n                .rpcServiceClassName(RPCServiceImpl.class.getName()) please.");
        }
    }
}

