/*
 * Decompiled with CFR 0.152.
 */
package org.ejbca.cvc;

import org.ejbca.cvc.AccessRights;

public enum AccessRightEnum implements AccessRights
{
    READ_ACCESS_NONE(0),
    READ_ACCESS_DG3(1),
    READ_ACCESS_DG4(2),
    READ_ACCESS_DG3_AND_DG4(3);

    public byte value;

    public AccessRightEnum(int n3) {
        this.value = (byte)n3;
    }

    public byte getValue() {
        return this.value;
    }

    public boolean hasDG3() {
        return (this.value & AccessRightEnum.READ_ACCESS_DG3.value) != 0;
    }

    public boolean hasDG4() {
        return (this.value & AccessRightEnum.READ_ACCESS_DG4.value) != 0;
    }

    @Override
    public byte[] getEncoded() {
        return new byte[]{this.value};
    }

    public String toString() {
        switch (this) {
            default: {
                throw new IllegalStateException("Enum case not handled");
            }
            case READ_ACCESS_NONE: {
                return "none";
            }
            case READ_ACCESS_DG3: {
                return "DG3";
            }
            case READ_ACCESS_DG4: {
                return "DG4";
            }
            case READ_ACCESS_DG3_AND_DG4: 
        }
        return "DG3+DG4";
    }
}

