/*
 * Decompiled with CFR 0.152.
 */
package org.ejbca.cvc;

import java.math.BigInteger;
import org.ejbca.cvc.AbstractDataField;
import org.ejbca.cvc.CVCObject;
import org.ejbca.cvc.CVCTagEnum;

public class IntegerField
extends AbstractDataField {
    public static final long serialVersionUID = 1L;
    public int intValue;

    public IntegerField(CVCTagEnum cVCTagEnum, int n2) {
        super(cVCTagEnum);
        this.intValue = n2;
    }

    public IntegerField(CVCTagEnum cVCTagEnum, byte[] byArray) {
        super(cVCTagEnum);
        if (byArray != null && byArray.length > 4) {
            throw new IllegalArgumentException("Byte array too long, max is 4, was " + byArray.length);
        }
        this.intValue = new BigInteger(1, byArray).intValue();
    }

    public void setValue(int n2) {
        this.intValue = n2;
    }

    public int getValue() {
        return this.intValue;
    }

    @Override
    public byte[] getEncoded() {
        return CVCObject.toByteArray(this.intValue);
    }

    @Override
    public String valueAsText() {
        return "" + this.intValue;
    }
}

