/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd;

import java.security.GeneralSecurityException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jmrtd.BACKeySpec;
import org.jmrtd.Util;

public class BACKey
implements BACKeySpec {
    public static final long serialVersionUID = -1059774581180524710L;
    public static final String SDF = "yyMMdd";
    public String documentNumber;
    public String dateOfBirth;
    public String dateOfExpiry;

    public BACKey() {
    }

    public BACKey(String string, Date date, Date date2) {
        this(string, BACKey.toString(date), BACKey.toString(date2));
    }

    public BACKey(String string, String string2, String string3) {
        if (string != null) {
            if (string2 != null && string2.length() == 6) {
                if (string3 != null && string3.length() == 6) {
                    StringBuilder stringBuilder;
                    StringBuilder stringBuilder2 = stringBuilder;
                    stringBuilder = new StringBuilder(string);
                    while (stringBuilder2.length() < 9) {
                        stringBuilder2.append('<');
                    }
                    this.documentNumber = stringBuilder2.toString().trim();
                    this.dateOfBirth = string2;
                    this.dateOfExpiry = string3;
                    return;
                }
                throw new IllegalArgumentException("Illegal date: " + string3);
            }
            throw new IllegalArgumentException("Illegal date: " + string2);
        }
        throw new IllegalArgumentException("Illegal document number");
    }

    public static synchronized String toString(Date date) {
        return new SimpleDateFormat(SDF).format(date);
    }

    @Override
    public String getDocumentNumber() {
        return this.documentNumber;
    }

    @Override
    public String getDateOfBirth() {
        return this.dateOfBirth;
    }

    @Override
    public String getDateOfExpiry() {
        return this.dateOfExpiry;
    }

    public String toString() {
        return this.documentNumber + ", " + this.dateOfBirth + ", " + this.dateOfExpiry;
    }

    public int hashCode() {
        int n2 = 305;
        String string = this.documentNumber;
        int n3 = string == null ? 0 : string.hashCode();
        n2 = (n2 + n3) * 61;
        String string2 = this.dateOfBirth;
        int n4 = string2 == null ? 0 : string2.hashCode();
        int n5 = (n2 + n4) * 61;
        String string3 = this.dateOfExpiry;
        int n6 = string3 == null ? 0 : string3.hashCode();
        return n5 + n6;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!object.getClass().equals(BACKey.class)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        object = (BACKey)object;
        return this.documentNumber.equals(((BACKey)object).documentNumber) && this.dateOfBirth.equals(((BACKey)object).dateOfBirth) && this.dateOfExpiry.equals(((BACKey)object).dateOfExpiry);
    }

    @Override
    public String getAlgorithm() {
        return "BAC";
    }

    @Override
    public byte[] getKey() {
        try {
            return Util.computeKeySeed(this.documentNumber, this.dateOfBirth, this.dateOfExpiry, "SHA-1", true);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IllegalArgumentException("Unexpected exception", generalSecurityException);
        }
    }

    public void setDocumentNumber(String string) {
        this.documentNumber = string;
    }

    public void setDateOfBirth(String string) {
        this.dateOfBirth = string;
    }

    public void setDateOfExpiry(String string) {
        this.dateOfExpiry = string;
    }
}

