/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd;

import org.jmrtd.AccessKeySpec;
import org.jmrtd.BACKeySpec;
import org.jmrtd.Util;
import org.jmrtd.protocol.PACEProtocol;

public class PACEKeySpec
implements AccessKeySpec {
    public static final long serialVersionUID = -7113246293247012560L;
    public byte[] key;
    public byte keyReference;

    public PACEKeySpec(String string, byte by) {
        this(Util.getBytes(string), by);
    }

    public PACEKeySpec(byte[] byArray, byte by) {
        this.keyReference = by;
        this.key = byArray;
    }

    public static PACEKeySpec createMRZKey(BACKeySpec bACKeySpec) {
        return new PACEKeySpec(PACEProtocol.computeKeySeedForPACE(bACKeySpec), 1);
    }

    public static PACEKeySpec createCANKey(String string) {
        return new PACEKeySpec(string, 2);
    }

    public static PACEKeySpec createPINKey(String string) {
        return new PACEKeySpec(string, 3);
    }

    public static PACEKeySpec createPUKKey(String string) {
        return new PACEKeySpec(string, 4);
    }

    @Override
    public String getAlgorithm() {
        return "PACE";
    }

    public byte getKeyReference() {
        return this.keyReference;
    }

    @Override
    public byte[] getKey() {
        return this.key;
    }
}

