/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.cert;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactorySpi;
import java.util.Collection;
import net.sf.scuba.tlv.TLVInputStream;
import net.sf.scuba.tlv.TLVOutputStream;
import org.ejbca.cvc.CVCertificate;
import org.ejbca.cvc.CertificateParser;
import org.ejbca.cvc.exception.ConstructionException;
import org.ejbca.cvc.exception.ParseException;
import org.jmrtd.cert.CardVerifiableCertificate;

public class CVCertificateFactorySpi
extends CertificateFactorySpi {
    public static final int CV_CERTIFICATE_TAG = 32545;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Certificate engineGenerateCertificate(InputStream inputStream) {
        ByteArrayOutputStream byteArrayOutputStream;
        TLVInputStream tLVInputStream;
        Object object = tLVInputStream;
        int n2 = new TLVInputStream(inputStream).readTag();
        if (n2 != 32545) throw new CertificateException("Expected CV_CERTIFICATE_TAG, found " + Integer.toHexString(n2));
        CVCertificateFactorySpi cVCertificateFactorySpi = object;
        CVCertificateFactorySpi cVCertificateFactorySpi2 = cVCertificateFactorySpi;
        cVCertificateFactorySpi.readLength();
        object = cVCertificateFactorySpi2.readValue();
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        TLVOutputStream tLVOutputStream = new TLVOutputStream((OutputStream)byteArrayOutputStream2);
        tLVOutputStream.writeTag(32545);
        tLVOutputStream.writeValue((byte[])object);
        tLVOutputStream.close();
        object = CertificateParser.parseCertificate(byteArrayOutputStream.toByteArray());
        try {
            return new CardVerifiableCertificate((CVCertificate)object);
        }
        catch (ParseException parseException) {
            throw new CertificateException(parseException);
        }
        catch (ConstructionException constructionException) {
            throw new CertificateException(constructionException);
        }
        catch (IOException iOException) {
            throw new CertificateException(iOException);
        }
    }

    @Override
    public CRL engineGenerateCRL(InputStream inputStream) {
        return null;
    }

    @Override
    public Collection<? extends CRL> engineGenerateCRLs(InputStream inputStream) {
        return null;
    }

    @Override
    public Collection<? extends Certificate> engineGenerateCertificates(InputStream inputStream) {
        return null;
    }
}

