/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.lds;

import java.io.InputStream;
import java.io.OutputStream;
import net.sf.scuba.tlv.TLVInputStream;
import net.sf.scuba.tlv.TLVOutputStream;
import net.sf.scuba.tlv.TLVUtil;
import org.jmrtd.lds.AbstractImageInfo;

public class DisplayedImageInfo
extends AbstractImageInfo {
    public static final long serialVersionUID = 3801320585294302721L;
    public static final int DISPLAYED_PORTRAIT_TAG = 24384;
    public static final int DISPLAYED_SIGNATURE_OR_MARK_TAG = 24387;
    public int displayedImageTag;

    public DisplayedImageInfo(int n2, byte[] byArray) {
        int n3 = n2;
        super(n3, DisplayedImageInfo.getMimeTypeFromType(n3));
        this.displayedImageTag = DisplayedImageInfo.getDisplayedImageTagFromType(n2);
        this.setImageBytes(byArray);
    }

    public DisplayedImageInfo(InputStream inputStream) {
        this.readObject(inputStream);
    }

    public static String getMimeTypeFromType(int n2) {
        if (n2 != 0) {
            if (n2 != 1) {
                if (n2 == 2) {
                    return "image/x-wsq";
                }
                throw new NumberFormatException("Unknown type: " + Integer.toHexString(n2));
            }
            return "image/jpeg";
        }
        return "image/jpeg";
    }

    public static int getDisplayedImageTagFromType(int n2) {
        if (n2 != 0) {
            if (n2 == 1) {
                return 24387;
            }
            throw new NumberFormatException("Unknown type: " + Integer.toHexString(n2));
        }
        return 24384;
    }

    public static int getTypeFromDisplayedImageTag(int n2) {
        if (n2 != 24384) {
            if (n2 == 24387) {
                return 1;
            }
            throw new NumberFormatException("Unknown tag: " + Integer.toHexString(n2));
        }
        return 0;
    }

    @Override
    public void readObject(InputStream inputStream) {
        Object object;
        if (inputStream instanceof TLVInputStream) {
            inputStream = (TLVInputStream)inputStream;
            object = inputStream;
        } else {
            TLVInputStream tLVInputStream;
            object = tLVInputStream;
            tLVInputStream = new TLVInputStream(inputStream);
        }
        int n2 = this.displayedImageTag = object.readTag();
        if (n2 != 24384 && n2 != 24387) {
            throw new IllegalArgumentException("Expected tag 0x5F40 or 0x5F43, found " + Integer.toHexString(this.displayedImageTag));
        }
        Object object2 = object;
        DisplayedImageInfo displayedImageInfo = this;
        int n3 = DisplayedImageInfo.getTypeFromDisplayedImageTag(displayedImageInfo.displayedImageTag);
        displayedImageInfo.setType(n3);
        displayedImageInfo.setMimeType(DisplayedImageInfo.getMimeTypeFromType(n3));
        this.readImage((InputStream)object2, object2.readLength());
    }

    @Override
    public void writeObject(OutputStream outputStream) {
        Object object;
        if (outputStream instanceof TLVOutputStream) {
            outputStream = (TLVOutputStream)outputStream;
            object = outputStream;
        } else {
            TLVOutputStream tLVOutputStream;
            object = tLVOutputStream;
            tLVOutputStream = new TLVOutputStream(outputStream);
        }
        Object object2 = object;
        object2.writeTag(DisplayedImageInfo.getDisplayedImageTagFromType(this.getType()));
        this.writeImage((OutputStream)object2);
        object.writeValueEnd();
    }

    public int getDisplayedImageTag() {
        return this.displayedImageTag;
    }

    @Override
    public long getRecordLength() {
        DisplayedImageInfo displayedImageInfo = this;
        int n2 = displayedImageInfo.getImageLength();
        return (long)TLVUtil.getTagLength((int)DisplayedImageInfo.getDisplayedImageTagFromType(displayedImageInfo.getType())) + 0L + (long)TLVUtil.getLengthLength((int)n2) + (long)n2;
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 31 + this.displayedImageTag;
    }

    @Override
    public boolean equals(Object object) {
        if (displayedImageInfo2 == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (DisplayedImageInfo.class != object.getClass()) {
            return false;
        }
        DisplayedImageInfo displayedImageInfo = displayedImageInfo2;
        DisplayedImageInfo displayedImageInfo2 = (DisplayedImageInfo)object;
        return displayedImageInfo.displayedImageTag == displayedImageInfo2.displayedImageTag;
    }
}

