/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.lds.icao;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.jmrtd.cbeff.BiometricDataBlockDecoder;
import org.jmrtd.cbeff.BiometricDataBlockEncoder;
import org.jmrtd.cbeff.CBEFFInfo;
import org.jmrtd.cbeff.ComplexCBEFFInfo;
import org.jmrtd.cbeff.ISO781611Decoder;
import org.jmrtd.cbeff.ISO781611Encoder;
import org.jmrtd.cbeff.SimpleCBEFFInfo;
import org.jmrtd.cbeff.StandardBiometricHeader;
import org.jmrtd.lds.CBEFFDataGroup;
import org.jmrtd.lds.iso19794.FaceInfo;

public class DG2File
extends CBEFFDataGroup<FaceInfo> {
    public static final long serialVersionUID = 414300652684010416L;
    public static final ISO781611Decoder DECODER = new ISO781611Decoder(new BiometricDataBlockDecoder<FaceInfo>(){

        @Override
        public FaceInfo decode(InputStream inputStream, StandardBiometricHeader standardBiometricHeader, int n2, int n3) {
            return new FaceInfo(standardBiometricHeader, inputStream);
        }
    });
    public static final ISO781611Encoder<FaceInfo> ENCODER = new ISO781611Encoder<FaceInfo>(new BiometricDataBlockEncoder<FaceInfo>(){

        @Override
        public void encode(FaceInfo faceInfo, OutputStream outputStream) {
            faceInfo.writeObject(outputStream);
        }
    });

    public DG2File(List<FaceInfo> list) {
        super(117, list);
    }

    public DG2File(InputStream inputStream) {
        super(117, inputStream);
    }

    @Override
    public void readContent(InputStream object) {
        for (CBEFFInfo cBEFFInfo : DECODER.decode((InputStream)object).getSubRecords()) {
            if (cBEFFInfo instanceof SimpleCBEFFInfo) {
                if ((cBEFFInfo = ((SimpleCBEFFInfo)cBEFFInfo).getBiometricDataBlock()) instanceof FaceInfo) {
                    this.add((FaceInfo)((Object)cBEFFInfo));
                    continue;
                }
                throw new IOException("Was expecting a FaceInfo, found " + cBEFFInfo.getClass().getSimpleName());
            }
            throw new IOException("Was expecting a SimpleCBEFFInfo, found " + cBEFFInfo.getClass().getSimpleName());
        }
    }

    @Override
    public void writeContent(OutputStream outputStream) {
        ComplexCBEFFInfo complexCBEFFInfo;
        DG2File dG2File = complexCBEFFInfo2;
        ComplexCBEFFInfo complexCBEFFInfo2 = complexCBEFFInfo;
        complexCBEFFInfo = new ComplexCBEFFInfo();
        for (FaceInfo faceInfo : dG2File.getSubRecords()) {
            complexCBEFFInfo2.add(new SimpleCBEFFInfo<FaceInfo>(faceInfo));
        }
        ENCODER.encode(complexCBEFFInfo2, outputStream);
    }

    @Override
    public String toString() {
        return "DG2File [" + super.toString() + "]";
    }

    public List<FaceInfo> getFaceInfos() {
        return this.getSubRecords();
    }

    public void addFaceInfo(FaceInfo faceInfo) {
        this.add(faceInfo);
    }

    public void removeFaceInfo(int n2) {
        this.remove(n2);
    }
}

