/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.protocol;

import java.io.Serializable;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;

public abstract class PACEMappingResult
implements Serializable {
    public static final long serialVersionUID = 2773111318950631118L;
    public transient AlgorithmParameterSpec staticParameters;
    public transient AlgorithmParameterSpec ephemeralParameters;
    public byte[] piccNonce;

    public PACEMappingResult(AlgorithmParameterSpec algorithmParameterSpec, byte[] byArray, AlgorithmParameterSpec algorithmParameterSpec2) {
        PACEMappingResult pACEMappingResult = object;
        ((PACEMappingResult)object).staticParameters = algorithmParameterSpec;
        pACEMappingResult.ephemeralParameters = algorithmParameterSpec2;
        pACEMappingResult.piccNonce = null;
        if (byArray != null) {
            ((PACEMappingResult)object).piccNonce = new byte[byArray.length];
            Object object = ((PACEMappingResult)object).piccNonce;
            int n2 = byArray.length;
            System.arraycopy(byArray, 0, object, 0, n2);
        }
    }

    public AlgorithmParameterSpec getStaticParameters() {
        return this.staticParameters;
    }

    public AlgorithmParameterSpec getEphemeralParameters() {
        return this.ephemeralParameters;
    }

    public byte[] getPICCNonce() {
        return this.piccNonce;
    }

    public int hashCode() {
        int n2 = 31;
        AlgorithmParameterSpec algorithmParameterSpec = this.ephemeralParameters;
        int n3 = algorithmParameterSpec == null ? 0 : algorithmParameterSpec.hashCode();
        int n4 = ((n2 + n3) * 31 + Arrays.hashCode(this.piccNonce)) * 31;
        AlgorithmParameterSpec algorithmParameterSpec2 = this.staticParameters;
        int n5 = algorithmParameterSpec2 == null ? 0 : algorithmParameterSpec2.hashCode();
        return n4 + n5;
    }

    public boolean equals(Object object) {
        if (algorithmParameterSpec2 == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (algorithmParameterSpec2.getClass() != object.getClass()) {
            return false;
        }
        object = (PACEMappingResult)object;
        AlgorithmParameterSpec algorithmParameterSpec = ((PACEMappingResult)((Object)algorithmParameterSpec2)).ephemeralParameters;
        if (algorithmParameterSpec == null ? ((PACEMappingResult)object).ephemeralParameters != null : !algorithmParameterSpec.equals(((PACEMappingResult)object).ephemeralParameters)) {
            return false;
        }
        if (!Arrays.equals(((PACEMappingResult)((Object)algorithmParameterSpec2)).piccNonce, ((PACEMappingResult)object).piccNonce)) {
            return false;
        }
        AlgorithmParameterSpec algorithmParameterSpec2 = ((PACEMappingResult)((Object)algorithmParameterSpec2)).staticParameters;
        return !(algorithmParameterSpec2 == null ? ((PACEMappingResult)object).staticParameters != null : !algorithmParameterSpec2.equals(((PACEMappingResult)object).staticParameters));
    }
}

