/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.protocol;

import java.io.Serializable;
import java.util.logging.Logger;
import net.sf.scuba.smartcards.APDUEvent;
import net.sf.scuba.smartcards.APDUListener;
import net.sf.scuba.smartcards.APDUWrapper;
import net.sf.scuba.smartcards.CardService;
import net.sf.scuba.smartcards.CardServiceException;
import net.sf.scuba.smartcards.CommandAPDU;
import net.sf.scuba.smartcards.ResponseAPDU;
import net.sf.scuba.util.Hex;
import org.jmrtd.WrappedAPDUEvent;

public class SecureMessagingAPDUSender {
    public static final Logger LOGGER = Logger.getLogger("org.jmrtd.protocol");
    public CardService service;
    public int apduCount;

    public SecureMessagingAPDUSender(CardService cardService) {
        SecureMessagingAPDUSender secureMessagingAPDUSender = this;
        secureMessagingAPDUSender.service = cardService;
        secureMessagingAPDUSender.apduCount = 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResponseAPDU transmit(APDUWrapper aPDUWrapper, CommandAPDU commandAPDU) {
        int n2;
        CommandAPDU commandAPDU2 = aPDUWrapper != null ? aPDUWrapper.wrap(commandAPDU) : commandAPDU;
        ResponseAPDU responseAPDU = this.service.transmit(commandAPDU2);
        short s2 = (short)responseAPDU.getSW();
        if (aPDUWrapper == null) {
            int n3;
            SecureMessagingAPDUSender secureMessagingAPDUSender = this;
            secureMessagingAPDUSender.apduCount = n3 = secureMessagingAPDUSender.apduCount + 1;
            this.notifyExchangedAPDU(new APDUEvent((Object)secureMessagingAPDUSender, (Serializable)((Object)"PLAIN"), n3, commandAPDU2, responseAPDU));
            return responseAPDU;
        }
        try {
            int n4;
            if (responseAPDU.getBytes().length <= 2) throw new CardServiceException("Exception during transmission of wrapped APDU, C=" + Hex.bytesToHexString((byte[])commandAPDU.getBytes()), (int)s2);
            ResponseAPDU responseAPDU2 = aPDUWrapper.unwrap(responseAPDU);
            this.apduCount = n4 = this.apduCount + 1;
            this.notifyExchangedAPDU(new WrappedAPDUEvent(this, (Serializable)((Object)aPDUWrapper.getType()), n4, commandAPDU, responseAPDU2, commandAPDU2, responseAPDU));
            return responseAPDU2;
        }
        catch (Throwable throwable) {
        }
        catch (Exception exception) {
            throw new CardServiceException("Exception during transmission of wrapped APDU, C=" + Hex.bytesToHexString((byte[])commandAPDU.getBytes()), (Throwable)exception, (int)s2);
        }
        catch (CardServiceException cardServiceException) {
            throw cardServiceException;
        }
        this.apduCount = n2 = this.apduCount + 1;
        this.notifyExchangedAPDU(new WrappedAPDUEvent(this, (Serializable)((Object)aPDUWrapper.getType()), n2, commandAPDU, responseAPDU, commandAPDU2, responseAPDU));
        throw throwable;
    }

    public void addAPDUListener(APDUListener aPDUListener) {
        this.service.addAPDUListener(aPDUListener);
    }

    public void removeAPDUListener(APDUListener aPDUListener) {
        this.service.removeAPDUListener(aPDUListener);
    }

    public void notifyExchangedAPDU(APDUEvent aPDUEvent) {
        Object object = ((SecureMessagingAPDUSender)object).service.getAPDUListeners();
        if (object != null && !object.isEmpty()) {
            object = object.iterator();
            while (object.hasNext()) {
                ((APDUListener)object.next()).exchangedAPDU(aPDUEvent);
            }
        }
    }
}

