/*
 * Decompiled with CFR 0.152.
 */
package net.sf.scuba.smartcards;

import net.sf.scuba.smartcards.APDUWrapper;
import net.sf.scuba.smartcards.CardService;
import net.sf.scuba.smartcards.CardServiceException;
import net.sf.scuba.smartcards.CommandAPDU;
import net.sf.scuba.smartcards.ResponseAPDU;

public class WrappingCardService
extends CardService {
    private CardService service;
    private APDUWrapper wrapper;
    private boolean enabled;

    public WrappingCardService(CardService service, APDUWrapper wrapper) {
        this.service = service;
        this.wrapper = wrapper;
    }

    @Override
    public void open() throws CardServiceException {
        this.service.open();
    }

    @Override
    public boolean isOpen() {
        return this.service.isOpen();
    }

    @Override
    public ResponseAPDU transmit(CommandAPDU capdu) throws CardServiceException {
        if (this.isEnabled()) {
            ResponseAPDU rapdu = this.service.transmit(this.wrapper.wrap(capdu));
            return this.wrapper.unwrap(rapdu);
        }
        return this.service.transmit(capdu);
    }

    @Override
    public byte[] getATR() throws CardServiceException {
        return this.service.getATR();
    }

    @Override
    public void close() {
        this.service.close();
    }

    public void enable() {
        this.enabled = true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void disable() {
        this.enabled = false;
    }

    @Override
    public boolean isConnectionLost(Exception e) {
        return this.service.isConnectionLost(e);
    }
}

