/*
 * Decompiled with CFR 0.152.
 */
package org.eid_bc.bouncycastle.asn1.pkcs;

import org.eid_bc.bouncycastle.asn1.ASN1EncodableVector;
import org.eid_bc.bouncycastle.asn1.ASN1Object;
import org.eid_bc.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.eid_bc.bouncycastle.asn1.ASN1Primitive;
import org.eid_bc.bouncycastle.asn1.ASN1Sequence;
import org.eid_bc.bouncycastle.asn1.ASN1Set;
import org.eid_bc.bouncycastle.asn1.DERSequence;

public class Attribute
extends ASN1Object {
    private ASN1ObjectIdentifier attrType;
    private ASN1Set attrValues;

    public static Attribute getInstance(Object o) {
        if (o == null || o instanceof Attribute) {
            return (Attribute)o;
        }
        if (o instanceof ASN1Sequence) {
            return new Attribute((ASN1Sequence)o);
        }
        throw new IllegalArgumentException("unknown object in factory: " + o.getClass().getName());
    }

    public Attribute(ASN1Sequence seq) {
        this.attrType = (ASN1ObjectIdentifier)seq.getObjectAt(0);
        this.attrValues = (ASN1Set)seq.getObjectAt(1);
    }

    public ASN1ObjectIdentifier getAttrType() {
        return this.attrType;
    }

    public ASN1Set getAttrValues() {
        return this.attrValues;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.attrType);
        v.add(this.attrValues);
        return new DERSequence(v);
    }
}

