/*
 * Decompiled with CFR 0.152.
 */
package org.eid_bc.bouncycastle.jcajce.provider.asymmetric.ec;

import java.math.BigInteger;
import java.security.spec.ECParameterSpec;
import org.eid_bc.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.eid_bc.bouncycastle.asn1.DERNull;
import org.eid_bc.bouncycastle.asn1.x9.X962Parameters;
import org.eid_bc.bouncycastle.asn1.x9.X9ECParameters;
import org.eid_bc.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import org.eid_bc.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import org.eid_bc.bouncycastle.jce.spec.ECNamedCurveSpec;
import org.eid_bc.bouncycastle.math.ec.ECCurve;

class ECUtils {
    ECUtils() {
    }

    static X962Parameters getDomainParametersFromName(ECParameterSpec ecSpec, boolean withCompression) {
        X962Parameters params;
        if (ecSpec instanceof ECNamedCurveSpec) {
            ASN1ObjectIdentifier curveOid = ECUtil.getNamedCurveOid(((ECNamedCurveSpec)ecSpec).getName());
            if (curveOid == null) {
                curveOid = new ASN1ObjectIdentifier(((ECNamedCurveSpec)ecSpec).getName());
            }
            params = new X962Parameters(curveOid);
        } else if (ecSpec == null) {
            params = new X962Parameters(DERNull.INSTANCE);
        } else {
            ECCurve curve = EC5Util.convertCurve(ecSpec.getCurve());
            X9ECParameters ecP = new X9ECParameters(curve, EC5Util.convertPoint(curve, ecSpec.getGenerator(), withCompression), ecSpec.getOrder(), BigInteger.valueOf(ecSpec.getCofactor()), ecSpec.getCurve().getSeed());
            params = new X962Parameters(ecP);
        }
        return params;
    }
}

