/*
 * Decompiled with CFR 0.152.
 */
package com.dtf.face.nfc.ui;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.nfc.NfcAdapter;
import android.os.Build;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.dtf.face.ToygerConfig;
import com.dtf.face.ToygerConst;
import com.dtf.face.log.RecordLevel;
import com.dtf.face.log.RecordService;
import com.dtf.face.nfc.DTFNfcManager;
import com.dtf.face.nfc.NFCConst;
import com.dtf.face.nfc.R;
import com.dtf.face.nfc.ui.NfcReadActivity;
import com.dtf.face.nfc.ui.dialog.DatePickerDialog;
import com.dtf.face.ui.FaceBaseActivity;
import com.dtf.face.ui.overlay.CommAlertOverlay;
import com.dtf.face.utils.StringUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class NfcInfoInputActivity
extends FaceBaseActivity
implements View.OnClickListener,
TextWatcher {
    private DatePickerDialog datePickerDialog;
    private EditText txtPassportNum;
    private TextView txtBirthday;
    private Button btnNextStep;
    private TextView txtValidity;
    private LinearLayout llBirthday;
    private LinearLayout llValidity;
    private CommAlertOverlay commAlertOverlay;
    NfcAdapter mNfcAdapter;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.dtf_activity_nfc_input);
        this.setViewEnable((View)this.getNextStepBtn(), false);
        this.setViewClickListener(new View[]{this.getNextStepBtn(), this.getBirthdayLayout(), this.getValidityLayout(), this.findViewById(R.id.close_nfc_btn)});
        this.getTxtPassportNum().addTextChangedListener((TextWatcher)this);
        RecordService.getInstance().recordEvent(RecordLevel.LOG_INFO, "NfcInfoInputActivityOnCreate", new String[0]);
    }

    private CommAlertOverlay getCommAlertOverlay() {
        if (null == this.commAlertOverlay) {
            this.commAlertOverlay = (CommAlertOverlay)this.findViewById(R.id.message_box_overlay);
        }
        return this.commAlertOverlay;
    }

    private void setViewEnable(View view, boolean enable) {
        if (null != view) {
            view.setEnabled(enable);
        }
    }

    private void setViewClickListener(View ... views) {
        for (View view : views) {
            if (null == view) continue;
            view.setOnClickListener((View.OnClickListener)this);
        }
    }

    public String getTrimText(TextView textView) {
        if (null == textView) {
            return "";
        }
        return textView.getText().toString().trim();
    }

    public boolean isEmpty(String str) {
        return null == str || str.equals("");
    }

    private EditText getTxtPassportNum() {
        if (null == this.txtPassportNum) {
            this.txtPassportNum = (EditText)this.findViewById(R.id.txt_passport_num);
        }
        return this.txtPassportNum;
    }

    private DatePickerDialog getDatePickerDialog(boolean isBirthDayPicker) {
        this.datePickerDialog = new DatePickerDialog((Context)this, isBirthDayPicker);
        return this.datePickerDialog;
    }

    private LinearLayout getBirthdayLayout() {
        if (null == this.llBirthday) {
            this.llBirthday = (LinearLayout)this.findViewById(R.id.ll_birthday);
        }
        return this.llBirthday;
    }

    private LinearLayout getValidityLayout() {
        if (null == this.llValidity) {
            this.llValidity = (LinearLayout)this.findViewById(R.id.ll_validity);
        }
        return this.llValidity;
    }

    private TextView getBirthday() {
        if (null == this.txtBirthday) {
            this.txtBirthday = (TextView)this.findViewById(R.id.txt_birthday);
        }
        return this.txtBirthday;
    }

    private TextView getValidity() {
        if (null == this.txtValidity) {
            this.txtValidity = (TextView)this.findViewById(R.id.txt_valid_date);
        }
        return this.txtValidity;
    }

    private Button getNextStepBtn() {
        if (null == this.btnNextStep) {
            this.btnNextStep = (Button)this.findViewById(R.id.nfc_next_button);
        }
        return this.btnNextStep;
    }

    private void updateDateTextview(TextView tv) {
        if (null != this.datePickerDialog && null != tv) {
            String dateString = this.datePickerDialog.getSelectedDateString();
            if (!StringUtil.isNullorEmpty((String)dateString)) {
                tv.setText((CharSequence)this.datePickerDialog.getSelectedDateString());
            }
            this.checkParams();
        }
    }

    public void checkParams() {
        boolean isEnable = !this.isEmpty(this.getTxtPassportNum().getText().toString().trim()) && !this.isEmpty(this.getBirthday().getText().toString().trim()) && !this.isEmpty(this.getValidity().getText().toString().trim());
        this.setViewEnable((View)this.getNextStepBtn(), isEnable);
    }

    public void showDatePickerDialog(final boolean isBirthDayPiker) {
        this.datePickerDialog = this.getDatePickerDialog(isBirthDayPiker);
        if (null != this.datePickerDialog) {
            String defaultDate = (isBirthDayPiker ? this.getBirthday() : this.getValidity()).getText().toString();
            this.datePickerDialog.setDetaultDate(defaultDate);
            this.datePickerDialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

                public void onDismiss(DialogInterface dialog) {
                    NfcInfoInputActivity.this.updateDateTextview(isBirthDayPiker ? NfcInfoInputActivity.this.getBirthday() : NfcInfoInputActivity.this.getValidity());
                }
            });
            this.datePickerDialog.show();
        }
    }

    public void onClick(View v) {
        int vId = v.getId();
        if (vId == R.id.ll_validity) {
            this.showDatePickerDialog(false);
        } else if (vId == R.id.ll_birthday) {
            this.showDatePickerDialog(true);
        } else if (vId == R.id.nfc_next_button) {
            if (!this.validityCheck()) {
                this.commAlertOverlay = this.getCommAlertOverlay();
                if (null != this.commAlertOverlay) {
                    this.commAlertOverlay.setTitleText(this.getResources().getString(R.string.dtf_nfc_notice));
                    this.commAlertOverlay.setMessageText(this.getResources().getString(R.string.dtf_nfc_input_invalidity_err));
                    this.commAlertOverlay.setCancelText(this.getResources().getString(R.string.dtf_nfc_cancel));
                    this.commAlertOverlay.setConfirmText(this.getResources().getString(R.string.dtf_nfc_sure));
                    this.commAlertOverlay.setCommAlertOverlayListener(new CommAlertOverlay.CommAlertOverlayListener(){

                        public void onCancel() {
                            NfcInfoInputActivity.this.commAlertOverlay.setVisibility(4);
                        }

                        public void onConfirm() {
                            NfcInfoInputActivity.this.commAlertOverlay.setVisibility(4);
                        }
                    });
                    this.commAlertOverlay.setVisibility(0);
                }
                return;
            }
            Intent intent = new Intent((Context)this, NfcReadActivity.class);
            intent.putExtra(NFCConst.INTENT_PARAM_KEY_PASSPORTNUM, this.getTrimText((TextView)this.getTxtPassportNum()));
            intent.putExtra(NFCConst.INTENT_PARAM_KEY_BIRTHDAY, this.getTrimText(this.getBirthday()).replace("-", "").substring(2));
            intent.putExtra(NFCConst.INTENT_PARAM_KEY_VALIDITY, this.getTrimText(this.getValidity()).replace("-", "").substring(2));
            intent.putExtra(NFCConst.INTENT_PARAM_KEY_DOCTYPE, NFCConst.DOC_TYPE_PASSPORT);
            this.startActivityForResult(intent, 0);
        } else if (vId == R.id.close_nfc_btn) {
            this.sendErrorCode(ToygerConst.ZcodeConstants.ZCODE_USER_BACK);
            this.finish();
        }
    }

    public boolean validityCheck() {
        SimpleDateFormat simpledateformat = new SimpleDateFormat("yyyy-MM-dd");
        String birthdayStr = this.getBirthday().getText().toString();
        String validity = this.getValidity().getText().toString();
        try {
            Date dateBirthday = simpledateformat.parse(birthdayStr);
            Date dataValidity = simpledateformat.parse(validity);
            if (dateBirthday.compareTo(dataValidity) < 0) {
                return true;
            }
            RecordService.getInstance().recordEvent(RecordLevel.LOG_INFO, "Validity is wrong", new String[0]);
            return false;
        }
        catch (ParseException parseException) {
            return true;
        }
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
    }

    public void afterTextChanged(Editable s) {
        this.checkParams();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == -1) {
            this.finish();
        }
    }

    private void sendErrorCode(String errCode) {
        ToygerConfig.getInstance().sendResAndExit((Context)this, errCode, "");
    }

    public void onBackPressed() {
        super.onBackPressed();
        this.sendErrorCode(ToygerConst.ZcodeConstants.ZCODE_USER_BACK);
        RecordService.getInstance().recordEvent(RecordLevel.LOG_INFO, "UserActivelyExits", new String[0]);
    }

    public void onResume() {
        super.onResume();
        this.mNfcAdapter = Build.VERSION.SDK_INT >= 19 ? DTFNfcManager.enableReaderMode((Activity)this, null) : DTFNfcManager.enableForegroundDispatch((Activity)this);
    }

    protected void onPause() {
        super.onPause();
        if (Build.VERSION.SDK_INT >= 19) {
            DTFNfcManager.disableReaderMode((Activity)this, this.mNfcAdapter);
        } else {
            DTFNfcManager.disableForegroundDispatch((Activity)this, this.mNfcAdapter);
        }
    }

    public void onDestroy() {
        super.onDestroy();
        RecordService.getInstance().recordEvent(RecordLevel.LOG_INFO, "NfcInfoInputActivityOnDestroy", new String[0]);
    }
}

