/*
 * Decompiled with CFR 0.152.
 */
package com.dtf.face.nfc.ui.anim;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.LinearInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.dtf.face.nfc.R;
import com.dtf.face.nfc.ui.anim.BaseSignalView;
import com.dtf.face.nfc.ui.anim.SignViewGray;
import com.dtf.face.utils.MobileUtil;

public class NfcReadOperationView
extends FrameLayout {
    private final BaseSignalView ivSign1;
    private final BaseSignalView ivSign2;
    private final BaseSignalView ivSign3;
    private final ImageView ivFinger;
    private final LinearLayout ivReadDialog;
    private final ImageView ivCard;
    private final TextView txtHintTime;
    private final View viewGrayBg;
    private final SignViewGray graySignalView;

    public NfcReadOperationView(Context context, AttributeSet attrs) {
        super(context, attrs);
        LayoutInflater.from((Context)context).inflate(R.layout.dtf_layout_anim_read_operation, (ViewGroup)this);
        this.ivSign1 = (BaseSignalView)this.findViewById(R.id.iv_sign_1);
        this.ivSign2 = (BaseSignalView)this.findViewById(R.id.iv_sign_2);
        this.ivSign3 = (BaseSignalView)this.findViewById(R.id.iv_sign_3);
        this.ivFinger = (ImageView)this.findViewById(R.id.iv_finger);
        this.ivReadDialog = (LinearLayout)this.findViewById(R.id.iv_read_dialog);
        this.ivCard = (ImageView)this.findViewById(R.id.iv_card);
        this.txtHintTime = (TextView)this.findViewById(R.id.txt_hint_time);
        this.viewGrayBg = this.findViewById(R.id.view_gray_bg);
        this.graySignalView = (SignViewGray)this.findViewById(R.id.iv_sign_gray);
        this.setAnimator();
    }

    public void setIsPassport(boolean isPassport) {
        if (null != this.ivCard) {
            this.ivCard.setImageDrawable(this.getResources().getDrawable(isPassport ? R.mipmap.dtf_nfc_passport : R.mipmap.dtf_idcard));
        }
        if (null != this.txtHintTime) {
            this.txtHintTime.setText((CharSequence)String.format(this.getResources().getString(R.string.dtf_nfc_put_card_right_here), isPassport ? 10 : 3));
        }
    }

    private void setAnimator() {
        int cardMoveX = MobileUtil.dp2px((Context)this.getContext(), (float)100.0f);
        ObjectAnimator animatorFinger = ObjectAnimator.ofFloat((Object)this.ivFinger, (String)"alpha", (float[])new float[]{0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f});
        ObjectAnimator animatorGrayBg = ObjectAnimator.ofFloat((Object)this.viewGrayBg, (String)"alpha", (float[])new float[]{0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f});
        ObjectAnimator animatorGraySignal = ObjectAnimator.ofFloat((Object)((Object)this.graySignalView), (String)"alpha", (float[])new float[]{0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f});
        ObjectAnimator animatorDialog = ObjectAnimator.ofFloat((Object)this.ivReadDialog, (String)"alpha", (float[])new float[]{0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f});
        ObjectAnimator animatorX = ObjectAnimator.ofFloat((Object)this.ivCard, (String)"translationX", (float[])new float[]{0.0f, 0.0f, 0.0f, -cardMoveX, -cardMoveX, -cardMoveX, -cardMoveX, -cardMoveX});
        ObjectAnimator animatory = ObjectAnimator.ofFloat((Object)this.ivCard, (String)"translationY", (float[])new float[]{0.0f, 0.0f, 0.0f, 200.0f, 200.0f, 200.0f, 200.0f, 200.0f});
        ObjectAnimator animatorA = ObjectAnimator.ofFloat((Object)this.ivCard, (String)"alpha", (float[])new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f});
        ObjectAnimator animatorS1 = ObjectAnimator.ofFloat((Object)((Object)this.ivSign1), (String)"alpha", (float[])new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f});
        ObjectAnimator animatorS2 = ObjectAnimator.ofFloat((Object)((Object)this.ivSign2), (String)"alpha", (float[])new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f});
        ObjectAnimator animatorS3 = ObjectAnimator.ofFloat((Object)((Object)this.ivSign3), (String)"alpha", (float[])new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f});
        this.startAnimator(animatorFinger, animatorDialog, animatorGrayBg, animatorX, animatory, animatorA, animatorS1, animatorS2, animatorS3, animatorGraySignal);
    }

    private void startAnimator(ObjectAnimator ... objectAnimators) {
        for (ObjectAnimator objectAnimator : objectAnimators) {
            objectAnimator.setDuration(3000L);
            objectAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
            objectAnimator.setRepeatCount(-1);
            objectAnimator.start();
        }
    }
}

