/*
 * Decompiled with CFR 0.152.
 */
package com.dtf.face.nfc.ui.widget.wheelpiker;

import android.content.Context;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.dtf.face.nfc.R;
import com.dtf.face.nfc.ui.widget.wheelpiker.IWheelDayPicker;
import com.dtf.face.nfc.ui.widget.wheelpiker.IWheelMonthPicker;
import com.dtf.face.nfc.ui.widget.wheelpiker.IWheelPicker;
import com.dtf.face.nfc.ui.widget.wheelpiker.IWheelYearPicker;
import com.dtf.face.nfc.ui.widget.wheelpiker.WheelDayPicker;
import com.dtf.face.nfc.ui.widget.wheelpiker.WheelMonthPicker;
import com.dtf.face.nfc.ui.widget.wheelpiker.WheelPicker;
import com.dtf.face.nfc.ui.widget.wheelpiker.WheelYearPicker;
import java.util.Calendar;
import java.util.List;

public class WheelDatePicker
extends LinearLayout
implements WheelPicker.OnItemSelectedListener,
IWheelPicker,
IWheelYearPicker,
IWheelMonthPicker,
IWheelDayPicker {
    private final WheelYearPicker mPickerYear;
    private final WheelMonthPicker mPickerMonth;
    private final WheelDayPicker mPickerDay;
    private int mYear;
    private int mMonth;
    private int mDay;
    private int mYearEnd;
    private int mMonthEnd;
    private int mDayEnd;
    protected boolean needCheckEndDate = true;

    public void setNeedCheckEndDate(boolean needCheckEndDate) {
        this.needCheckEndDate = needCheckEndDate;
        this.setEndDataChecker();
    }

    public WheelDatePicker(Context context) {
        this(context, null);
    }

    public WheelDatePicker(Context context, AttributeSet attrs) {
        super(context, attrs);
        LayoutInflater.from((Context)context).inflate(R.layout.dtf_view_wheel_date_picker, (ViewGroup)this);
        this.mPickerYear = (WheelYearPicker)this.findViewById(R.id.wheel_date_picker_year);
        this.mPickerMonth = (WheelMonthPicker)this.findViewById(R.id.wheel_date_picker_month);
        this.mPickerDay = (WheelDayPicker)this.findViewById(R.id.wheel_date_picker_day);
        this.mPickerYear.setOnItemSelectedListener(this);
        this.mPickerMonth.setOnItemSelectedListener(this);
        this.mPickerDay.setOnItemSelectedListener(this);
        this.setMaximumWidthTextYear();
        this.mPickerMonth.setMaximumWidthText("00");
        this.mPickerDay.setMaximumWidthText("00");
        this.mYear = this.mPickerYear.getCurrentYear();
        this.mMonth = this.mPickerMonth.getCurrentMonth();
        this.mDay = this.mPickerDay.getCurrentDay();
    }

    public void setEndDataChecker() {
        if (this.needCheckEndDate) {
            this.mYearEnd = Calendar.getInstance().get(1);
            this.mMonthEnd = Calendar.getInstance().get(2) + 1;
            this.mDayEnd = Calendar.getInstance().get(5);
            this.mPickerYear.setYearEnd(this.mYearEnd);
            this.setOnSelectedChangeListener();
        }
    }

    public void setOnSelectedChangeListener() {
        this.mPickerYear.setOnItemSelectedListener(new WheelPicker.OnItemSelectedListener(){

            @Override
            public void onItemSelected(WheelPicker picker, Object data, int position) {
                if (Integer.parseInt(data.toString()) >= WheelDatePicker.this.mYearEnd) {
                    if (WheelDatePicker.this.mPickerMonth.getCurrentMonth() > WheelDatePicker.this.mMonthEnd) {
                        if (WheelDatePicker.this.mPickerDay.getCurrentDay() > WheelDatePicker.this.mDayEnd) {
                            WheelDatePicker.this.mPickerMonth.setSelectedMonth(WheelDatePicker.this.mMonthEnd - 1);
                        } else {
                            WheelDatePicker.this.mPickerMonth.setSelectedMonth(WheelDatePicker.this.mMonthEnd);
                        }
                    } else if (WheelDatePicker.this.mPickerMonth.getCurrentMonth() == WheelDatePicker.this.mMonthEnd && WheelDatePicker.this.mPickerDay.getCurrentDay() > WheelDatePicker.this.mDayEnd) {
                        WheelDatePicker.this.mPickerDay.setSelectedDay(WheelDatePicker.this.mDayEnd);
                    }
                } else if (WheelDatePicker.this.mPickerMonth.getCurrentMonth() == 2) {
                    WheelDatePicker.this.setSelectedMonth(2);
                }
            }
        });
        this.mPickerMonth.setOnItemSelectedListener(new WheelPicker.OnItemSelectedListener(){

            @Override
            public void onItemSelected(WheelPicker picker, Object data, int position) {
                if (WheelDatePicker.this.mPickerYear.getCurrentYear() >= WheelDatePicker.this.mYearEnd) {
                    if (WheelDatePicker.this.mPickerMonth.getCurrentMonth() > WheelDatePicker.this.mMonthEnd) {
                        WheelDatePicker.this.mPickerYear.setSelectedYear(WheelDatePicker.this.mYearEnd - 1);
                        WheelDatePicker.this.mPickerMonth.setSelectedMonth(Integer.parseInt(data.toString()));
                    } else if (WheelDatePicker.this.mPickerMonth.getCurrentMonth() == WheelDatePicker.this.mMonthEnd && WheelDatePicker.this.mPickerDay.getCurrentDay() > WheelDatePicker.this.mDayEnd) {
                        WheelDatePicker.this.mPickerDay.setSelectedDay(WheelDatePicker.this.mDayEnd);
                    }
                }
                WheelDatePicker.this.setSelectedMonth(Integer.parseInt(data.toString()));
            }
        });
        this.mPickerDay.setOnItemSelectedListener(new WheelPicker.OnItemSelectedListener(){

            @Override
            public void onItemSelected(WheelPicker picker, Object data, int position) {
                if (WheelDatePicker.this.mPickerYear.getCurrentYear() >= WheelDatePicker.this.mYearEnd) {
                    if (Integer.parseInt(data.toString()) > WheelDatePicker.this.mDayEnd) {
                        if (WheelDatePicker.this.mPickerMonth.getCurrentMonth() + 1 >= WheelDatePicker.this.mMonthEnd) {
                            WheelDatePicker.this.mPickerMonth.setSelectedMonth(WheelDatePicker.this.mMonthEnd - 1);
                        }
                    } else if (Integer.parseInt(data.toString()) == WheelDatePicker.this.mDayEnd && WheelDatePicker.this.mPickerMonth.getCurrentMonth() >= WheelDatePicker.this.mMonthEnd) {
                        WheelDatePicker.this.mPickerMonth.setSelectedMonth(WheelDatePicker.this.mMonthEnd);
                    }
                }
            }
        });
    }

    private void setMaximumWidthTextYear() {
        List years = this.mPickerYear.getData();
        String lastYear = String.valueOf(years.get(years.size() - 1));
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < lastYear.length(); ++i) {
            sb.append("0");
        }
        this.mPickerYear.setMaximumWidthText(sb.toString());
    }

    @Override
    public void onItemSelected(WheelPicker picker, Object data, int position) {
        if (picker.getId() == R.id.wheel_date_picker_year) {
            this.mYear = (Integer)data;
            this.mPickerDay.setYear(this.mYear, this.mPickerMonth.getCurrentMonth());
        } else if (picker.getId() == R.id.wheel_date_picker_month) {
            this.mMonth = (Integer)data;
            this.mPickerDay.setMonth(this.mMonth, this.mYear);
        }
        this.mDay = this.mPickerDay.getCurrentDay();
    }

    @Override
    public int getVisibleItemCount() {
        if (this.mPickerYear.getVisibleItemCount() == this.mPickerMonth.getVisibleItemCount() && this.mPickerMonth.getVisibleItemCount() == this.mPickerDay.getVisibleItemCount()) {
            return this.mPickerYear.getVisibleItemCount();
        }
        throw new ArithmeticException("Can not get visible item count correctly fromWheelDatePicker!");
    }

    @Override
    public void setVisibleItemCount(int count) {
        this.mPickerYear.setVisibleItemCount(count);
        this.mPickerMonth.setVisibleItemCount(count);
        this.mPickerDay.setVisibleItemCount(count);
    }

    @Override
    public boolean isCyclic() {
        return this.mPickerYear.isCyclic() && this.mPickerMonth.isCyclic() && this.mPickerDay.isCyclic();
    }

    @Override
    public void setCyclic(boolean isCyclic) {
        this.mPickerYear.setCyclic(isCyclic);
        this.mPickerMonth.setCyclic(isCyclic);
        this.mPickerDay.setCyclic(isCyclic);
    }

    @Override
    @Deprecated
    public void setOnItemSelectedListener(WheelPicker.OnItemSelectedListener listener) {
    }

    @Override
    @Deprecated
    public void setSelectedItemPosition(int position) {
    }

    @Override
    @Deprecated
    public int getCurrentItemPosition() {
        throw new UnsupportedOperationException("You can not get position of current item fromWheelDatePicker");
    }

    @Override
    @Deprecated
    public List getData() {
        throw new UnsupportedOperationException("You can not get data source from WheelDatePicker");
    }

    @Override
    @Deprecated
    public void setData(List data) {
    }

    @Override
    @Deprecated
    public void setSameWidth(boolean hasSameSize) {
    }

    @Override
    @Deprecated
    public void setMaximumWidthText(String text) {
    }

    @Override
    public int getSelectedItemTextColor() {
        if (this.mPickerYear.getSelectedItemTextColor() == this.mPickerMonth.getSelectedItemTextColor() && this.mPickerMonth.getSelectedItemTextColor() == this.mPickerDay.getSelectedItemTextColor()) {
            return this.mPickerYear.getSelectedItemTextColor();
        }
        throw new RuntimeException("Can not get color of selected item text correctly fromWheelDatePicker!");
    }

    @Override
    public void setSelectedItemTextColor(int color2) {
        this.mPickerYear.setSelectedItemTextColor(color2);
        this.mPickerMonth.setSelectedItemTextColor(color2);
        this.mPickerDay.setSelectedItemTextColor(color2);
    }

    @Override
    public int getItemTextColor() {
        if (this.mPickerYear.getItemTextColor() == this.mPickerMonth.getItemTextColor() && this.mPickerMonth.getItemTextColor() == this.mPickerDay.getItemTextColor()) {
            return this.mPickerYear.getItemTextColor();
        }
        throw new RuntimeException("Can not get color of item text correctly fromWheelDatePicker!");
    }

    @Override
    public void setItemTextColor(int color2) {
        this.mPickerYear.setItemTextColor(color2);
        this.mPickerMonth.setItemTextColor(color2);
        this.mPickerDay.setItemTextColor(color2);
    }

    @Override
    public int getItemTextSize() {
        if (this.mPickerYear.getItemTextSize() == this.mPickerMonth.getItemTextSize() && this.mPickerMonth.getItemTextSize() == this.mPickerDay.getItemTextSize()) {
            return this.mPickerYear.getItemTextSize();
        }
        throw new RuntimeException("Can not get size of item text correctly fromWheelDatePicker!");
    }

    @Override
    public void setItemTextSize(int size) {
        this.mPickerYear.setItemTextSize(size);
        this.mPickerMonth.setItemTextSize(size);
        this.mPickerDay.setItemTextSize(size);
    }

    @Override
    public int getItemSpace() {
        if (this.mPickerYear.getItemSpace() == this.mPickerMonth.getItemSpace() && this.mPickerMonth.getItemSpace() == this.mPickerDay.getItemSpace()) {
            return this.mPickerYear.getItemSpace();
        }
        throw new RuntimeException("Can not get item space correctly from WheelDatePicker!");
    }

    @Override
    public void setItemSpace(int space) {
        this.mPickerYear.setItemSpace(space);
        this.mPickerMonth.setItemSpace(space);
        this.mPickerDay.setItemSpace(space);
    }

    @Override
    public void setIndicator(boolean hasIndicator) {
        this.mPickerYear.setIndicator(hasIndicator);
        this.mPickerMonth.setIndicator(hasIndicator);
        this.mPickerDay.setIndicator(hasIndicator);
    }

    @Override
    public boolean hasIndicator() {
        return this.mPickerYear.hasIndicator() && this.mPickerMonth.hasIndicator() && this.mPickerDay.hasIndicator();
    }

    @Override
    public int getIndicatorSize() {
        if (this.mPickerYear.getIndicatorSize() == this.mPickerMonth.getIndicatorSize() && this.mPickerMonth.getIndicatorSize() == this.mPickerDay.getIndicatorSize()) {
            return this.mPickerYear.getIndicatorSize();
        }
        throw new RuntimeException("Can not get indicator size correctly from WheelDatePicker!");
    }

    @Override
    public void setIndicatorSize(int size) {
        this.mPickerYear.setIndicatorSize(size);
        this.mPickerMonth.setIndicatorSize(size);
        this.mPickerDay.setIndicatorSize(size);
    }

    @Override
    public void setIndicatorColor(int color2) {
        this.mPickerYear.setIndicatorColor(color2);
        this.mPickerMonth.setIndicatorColor(color2);
        this.mPickerDay.setIndicatorColor(color2);
    }

    @Override
    public boolean isCurved() {
        return this.mPickerYear.isCurved() && this.mPickerMonth.isCurved() && this.mPickerDay.isCurved();
    }

    @Override
    public void setCurved(boolean isCurved) {
        this.mPickerYear.setCurved(isCurved);
        this.mPickerMonth.setCurved(isCurved);
        this.mPickerDay.setCurved(isCurved);
    }

    @Override
    @Deprecated
    public void setItemAlign(int align) {
        throw new UnsupportedOperationException("You don't need to set item align forWheelDatePicker");
    }

    @Override
    public Typeface getTypeface() {
        if (this.mPickerYear.getTypeface().equals((Object)this.mPickerMonth.getTypeface()) && this.mPickerMonth.getTypeface().equals((Object)this.mPickerDay.getTypeface())) {
            return this.mPickerYear.getTypeface();
        }
        throw new RuntimeException("Can not get typeface correctly from WheelDatePicker!");
    }

    @Override
    public void setTypeface(Typeface tf) {
        this.mPickerYear.setTypeface(tf);
        this.mPickerMonth.setTypeface(tf);
        this.mPickerDay.setTypeface(tf);
    }

    @Override
    public void setYearFrame(int start, int end) {
        this.mPickerYear.setYearFrame(start, end);
    }

    @Override
    public int getYearStart() {
        return this.mPickerYear.getYearStart();
    }

    @Override
    public void setYearStart(int start) {
        this.mPickerYear.setYearStart(start);
    }

    @Override
    public int getYearEnd() {
        return this.mPickerYear.getYearEnd();
    }

    @Override
    public void setYearEnd(int end) {
        this.mPickerYear.setYearEnd(end);
    }

    @Override
    public int getSelectedYear() {
        return this.mPickerYear.getSelectedYear();
    }

    @Override
    public void setSelectedYear(int year) {
        this.mYear = year;
        this.mPickerYear.setSelectedYear(year);
        this.mPickerDay.setYear(year, this.mPickerMonth.getCurrentMonth());
    }

    @Override
    public int getCurrentYear() {
        return this.mPickerYear.getCurrentYear();
    }

    @Override
    public int getSelectedMonth() {
        return this.mPickerMonth.getSelectedMonth();
    }

    @Override
    public void setSelectedMonth(int month) {
        this.mMonth = month;
        this.mPickerMonth.setSelectedMonth(month);
        this.mPickerDay.setMonth(month, this.mPickerYear.getCurrentYear());
    }

    @Override
    public int getCurrentMonth() {
        return this.mPickerMonth.getCurrentMonth();
    }

    @Override
    public int getSelectedDay() {
        return this.mPickerDay.getSelectedDay();
    }

    @Override
    public void setSelectedDay(int day) {
        this.mDay = day;
        this.mPickerDay.setSelectedDay(day);
    }

    @Override
    public int getCurrentDay() {
        return this.mPickerDay.getCurrentDay();
    }

    @Override
    public void setYearAndMonth(int year, int month) {
        this.mYear = year;
        this.mMonth = month;
        this.mPickerYear.setSelectedYear(year);
        this.mPickerMonth.setSelectedMonth(month);
        this.mPickerDay.setYearAndMonth(year, month);
    }

    @Override
    public void setYear(int year, int mMonth) {
        this.mYear = year;
        this.mPickerYear.setSelectedYear(year);
        this.mPickerDay.setYear(year, this.mPickerMonth.getCurrentMonth());
    }

    @Override
    public void setMonth(int month, int year) {
        this.mMonth = month;
        this.mPickerMonth.setSelectedMonth(month);
        this.mPickerDay.setMonth(month, year);
    }
}

