/*
 * Decompiled with CFR 0.152.
 */
package com.dtf.face.network.upload;

import android.content.Context;
import android.text.TextUtils;
import com.dtf.face.network.APICallback;
import com.dtf.face.network.BizRequestProxy;
import com.dtf.face.network.utils.NetworkPackUtil;
import com.dtf.face.thread.ThreadControl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class FileUploadManager {
    public static FileUploadManager s_Instance = new FileUploadManager();
    public ArrayList<FileItem> uploadItems = new ArrayList();
    public final Object fileLock = new Object();

    public static FileUploadManager getInstance() {
        return s_Instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        Object object = this.fileLock;
        synchronized (object) {
            this.uploadItems = new ArrayList();
            return;
        }
    }

    public void release() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUploadFile(int n, String string2, String string3, byte[] byArray) {
        Object object = this.fileLock;
        synchronized (object) {
            this.uploadItems.add(new FileItem(n, string2, string3, byArray));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUploadFileName(int n) {
        FileUploadManager fileUploadManager = object;
        Object object = fileUploadManager.fileLock;
        synchronized (object) {
            block9: {
                FileItem fileItem;
                Iterator<FileItem> iterator = fileUploadManager.uploadItems.iterator();
                while (true) {
                    if (!iterator.hasNext()) break block9;
                    fileItem = iterator.next();
                    if (fileItem.fileIdx != n) continue;
                    break;
                }
                return fileItem.fileName;
            }
            return "";
        }
    }

    public ArrayList<FileItem> getUploadItems() {
        return this.uploadItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startUploadFiles(Context object, final IUploadListener iUploadListener) {
        object = this.fileLock;
        synchronized (object) {
            ThreadControl.sSingleExecutorService.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 * Converted monitor instructions to comments
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    HashMap hashMap;
                    Object object;
                    final Object object2 = object;
                    object = new Object();
                    final HashMap hashMap2 = hashMap;
                    hashMap = new HashMap();
                    int n = 0;
                    for (FileItem fileItem : FileUploadManager.this.uploadItems) {
                        IUploadListener iUploadListener2;
                        block8: {
                            block7: {
                                hashMap2.clear();
                                Map<String, Object> map = NetworkPackUtil.packageFileUpload(fileItem.fileName, fileItem.fileContent, new APICallback<Map<String, Object>>(){

                                    @Override
                                    public void onSuccess(Map<String, Object> map) {
                                        1 v0 = this;
                                        v0.hashMap2.put("result", true);
                                        v0.notifyContinue();
                                    }

                                    @Override
                                    public void onError(String string2, String string3, String string4) {
                                        hashMap2.put("result", false);
                                        if (!TextUtils.isEmpty((CharSequence)string2)) {
                                            hashMap2.put("msg", string3);
                                        }
                                        this.notifyContinue();
                                    }

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    public void notifyContinue() {
                                        1 v0 = object;
                                        Object object = v0.object2;
                                        synchronized (object) {
                                            try {
                                                v0.object2.notifyAll();
                                            }
                                            catch (Throwable throwable) {}
                                            return;
                                        }
                                    }
                                });
                                BizRequestProxy.getInstance().zimFileUpload(map, (APICallback)map.get("callback"));
                                // MONITORENTER : object2
                                if (hashMap2.size() != 0) break block7;
                                try {
                                    object2.wait(20000L);
                                }
                                catch (Throwable throwable) {}
                            }
                            // MONITOREXIT : object2
                            if (!((Boolean)hashMap2.get("result")).booleanValue()) break block8;
                            ++n;
                            iUploadListener2 = iUploadListener;
                            if (iUploadListener2 == null) continue;
                            iUploadListener2.onUploadSuccess(fileItem.fileIdx, fileItem.bucketName, fileItem.fileName);
                            continue;
                        }
                        iUploadListener2 = iUploadListener;
                        if (iUploadListener2 == null || iUploadListener2.onUploadError(fileItem.fileIdx, fileItem.bucketName, fileItem.fileName, (String)hashMap2.get("msg"))) continue;
                        break;
                    }
                    if ((object2 = iUploadListener) == null) return;
                    object2.onFinish(FileUploadManager.this.uploadItems.size(), n);
                }
            });
            return;
        }
    }

    public static class FileItem {
        public int fileIdx;
        public String bucketName;
        public String fileName;
        public byte[] fileContent;

        public FileItem(int n, String string2, String string3, byte[] byArray) {
            this.fileIdx = n;
            this.bucketName = string2;
            this.fileName = string3;
            this.fileContent = byArray;
        }
    }

    public static interface IUploadListener {
        public boolean onUploadSuccess(int var1, String var2, String var3);

        public boolean onUploadError(int var1, String var2, String var3, String var4);

        public void onFinish(int var1, int var2);
    }
}

