/*
 * Decompiled with CFR 0.152.
 */
package com.dtf.face.api;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.os.Build;
import android.text.TextUtils;
import com.alibaba.fastjson.JSONObject;
import com.alipay.zoloz.toyger.SgomInfoManager;
import com.alipay.zoloz.toyger.blob.FaceDataFrameInfo;
import com.dtf.face.ToygerConfig;
import com.dtf.face.ToygerConst;
import com.dtf.face.api.DTFacadeExt;
import com.dtf.face.api.DTFacadeFaceExt;
import com.dtf.face.api.DTFacadeWishExt;
import com.dtf.face.api.DTResponse;
import com.dtf.face.api.IDTCallback;
import com.dtf.face.facadeverify.R;
import com.dtf.face.log.RecordLevel;
import com.dtf.face.log.RecordService;
import com.dtf.face.network.APICallback;
import com.dtf.face.ui.FaceLoadingActivity;
import com.dtf.face.ui.UICustomParams;
import com.dtf.face.ui.ZimActivityLifeCircle;
import com.dtf.face.utils.LocalPreferencesUtil;
import com.dtf.face.utils.ModelDownloadUtil;
import com.dtf.face.utils.ProguardCheckUtil;
import com.dtf.face.verify.IVerifyResultCallBack;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class DTFacade {
    public static boolean isInited = false;
    public static String deviceToken;
    public Context ctx;
    public WeakReference<Context> startContext;
    public IDTCallback zimCallback = null;

    public DTFacade(Context context) {
        this.startContext = new WeakReference<Context>(context);
        if (context != null) {
            context = context.getApplicationContext();
        }
        this.ctx = context;
    }

    public static int init(Context context, Map<String, Object> object) {
        if (context == null) {
            return -1;
        }
        LocalPreferencesUtil.init((Context)context);
        if (isInited) {
            return 0;
        }
        context = context.getApplicationContext();
        boolean bl = true;
        if (object != null && object.containsKey("isIPv6") && (object = object.get("isIPv6")) instanceof Boolean) {
            bl = (Boolean)object;
        }
        Context context2 = context;
        DTFacadeExt.initNetwork(bl);
        DTFacadeExt.initNetworkProxy(context2);
        object = context2.getPackageName();
        RecordService.getInstance().initSDK(context, (String)object);
        if (!TextUtils.isEmpty((CharSequence)ProguardCheckUtil.getInitClassCheckError())) {
            return -3;
        }
        if (!TextUtils.isEmpty((CharSequence)DTFacadeExt.validateSdk())) {
            return -2;
        }
        Context context3 = context;
        isInited = true;
        SgomInfoManager.setContext((Context)context3, (SgomInfoManager.IReport)new SgomInfoManager.IReport(){

            public void onException(Throwable throwable) {
                RecordService.getInstance().recordException(throwable);
            }

            public void onReport(String string, String ... stringArray) {
                RecordService.getInstance().recordEvent(RecordLevel.LOG_ERROR, string, stringArray);
            }
        });
        SgomInfoManager.initEnv();
        deviceToken = DTFacadeExt.initApdid(context3, new APICallback<String>(){

            public void onSuccess(String string) {
                deviceToken = string;
            }

            public void onError(String string, String string2, String string3) {
                deviceToken = "";
            }
        });
        DTFacadeFaceExt.initOthers(context, bl);
        return 0;
    }

    public static String getMetaInfo(Context object, Map<String, Object> jSONObject) {
        JSONObject jSONObject2;
        if (object != null && !isInited) {
            DTFacade.init(object, jSONObject);
        }
        if (object != null) {
            object = object.getApplicationContext();
        }
        jSONObject = jSONObject2;
        jSONObject2 = new JSONObject();
        if (TextUtils.isEmpty((CharSequence)deviceToken)) {
            deviceToken = SgomInfoManager.getTokenResult((Context)object);
        }
        jSONObject.put("apdidToken", (Object)deviceToken);
        String string = object == null ? "" : object.getPackageName();
        jSONObject.put("appName", (Object)string);
        string = "";
        try {
            string = object.getPackageManager().getPackageInfo((String)object.getPackageName(), (int)0).versionName;
        }
        catch (Throwable throwable) {}
        Context context = object;
        JSONObject jSONObject3 = jSONObject;
        jSONObject3.put("appVersion", (Object)string);
        jSONObject3.put("deviceModel", (Object)Build.MODEL);
        jSONObject3.put("deviceType", (Object)"android");
        jSONObject3.put("osVersion", (Object)Build.VERSION.RELEASE);
        jSONObject3.put("bioMetaInfo", (Object)"7.0.0:393216,0");
        jSONObject3.put("zimVer", (Object)"1.0.0");
        jSONObject3.put("sdkVersion", (Object)"2.2.8.1");
        object = "nfcSupport";
        string = context.getPackageManager().hasSystemFeature("android.hardware.nfc") ? "Y" : "N";
        JSONObject jSONObject4 = jSONObject;
        jSONObject4.put((String)object, (Object)string);
        try {
            jSONObject4.put("voiceSdkVersion", (Object)"1.0.0");
        }
        catch (Throwable throwable) {
            RecordService.getInstance().recordException(throwable);
        }
        object = SgomInfoManager.initEnv();
        if (!TextUtils.isEmpty((CharSequence)object)) {
            jSONObject.put("securityVersion", object);
        }
        String string2 = jSONObject.toJSONString();
        ToygerConfig.getInstance().setMetaInfo(string2);
        return string2;
    }

    public static void preload(Context context, Map<String, Object> object, APICallback<String> aPICallback) {
        ArrayList<String> arrayList;
        if (context == null) {
            if (aPICallback != null) {
                aPICallback.onError("NULL-PARAMS", null, null);
            }
            return;
        }
        LocalPreferencesUtil.init((Context)context);
        object = object != null ? object.get("modelURL") : null;
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>();
        if (object != null && object instanceof String) {
            arrayList2.add((String)object);
        }
        ModelDownloadUtil.downloadFaceModelAsync((Context)context, arrayList2, (boolean)true, aPICallback);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateContext(Context context) {
        try {
            if (this.startContext != null) {
                this.startContext.clear();
            }
            this.startContext = new WeakReference<Context>(context);
            return;
        }
        catch (Throwable throwable) {}
    }

    public void verify(String string2, boolean bl, HashMap<String, String> hashMap, IDTCallback object) {
        stringArray3.zimCallback = object;
        if (stringArray3.ctx == null) {
            stringArray3.sendResponse(string2, ToygerConst.ZcodeConstants.ZCODE_NO_CONTEXT);
            return;
        }
        RecordService.getInstance().init(stringArray3.ctx, string2);
        object = ProguardCheckUtil.getClassFoundError();
        if (TextUtils.isEmpty((CharSequence)object)) {
            object = DTFacadeExt.checkClass();
        }
        if (!TextUtils.isEmpty((CharSequence)object)) {
            String[] stringArray = stringArray3;
            String[] stringArray2 = new String[2];
            String[] stringArray3 = stringArray2;
            stringArray2[0] = "classNotFoundException";
            stringArray2[1] = object;
            RecordService.getInstance().recordEvent(RecordLevel.LOG_INFO, "proguardCheck", stringArray3);
            stringArray.sendResponse(string2, "Z1038");
            return;
        }
        object = DTFacadeExt.validateSdk();
        if (!TextUtils.isEmpty((CharSequence)object)) {
            stringArray3.sendResponse(string2, (String)object);
            return;
        }
        if (!isInited) {
            stringArray3.sendResponse(string2, ToygerConst.ZcodeConstants.ZCODE_NO_INSTALLED);
            return;
        }
        if (string2 != null && !string2.isEmpty()) {
            Intent intent;
            deviceToken = DTFacadeExt.initApdid(stringArray3.ctx, new APICallback<String>(){

                public void onSuccess(String string) {
                    deviceToken = string;
                }

                public void onError(String string, String string2, String string3) {
                    deviceToken = "";
                }
            });
            DTFacadeFaceExt.init();
            DTFacadeWishExt.init();
            if (ZimActivityLifeCircle.getInstance().hasVerifyActivity()) {
                stringArray3.sendResponse(string2, ToygerConst.ZcodeConstants.ZCODE_ZIM_IS_BUSY);
                ZimActivityLifeCircle.getInstance().finishActivity();
                DTFacadeFaceExt.initWorkState();
                return;
            }
            DTFacadeExt.initNetworkProxy(stringArray3.ctx);
            DTFacadeFaceExt.initWorkState();
            FaceDataFrameInfo.info_cache = string2;
            object = deviceToken;
            if (TextUtils.isEmpty((CharSequence)object)) {
                String[] stringArray = new String[4];
                String[] stringArray4 = stringArray;
                stringArray[0] = "status";
                stringArray[1] = "false";
                stringArray[2] = "token";
                stringArray[3] = object;
                RecordService.getInstance().recordEvent(RecordLevel.LOG_INFO, "verifyGetSession", stringArray4);
            } else {
                String[] stringArray = new String[4];
                String[] stringArray5 = stringArray;
                stringArray[0] = "status";
                stringArray[1] = "true";
                stringArray[2] = "token";
                stringArray[3] = object;
                RecordService.getInstance().recordEvent(RecordLevel.LOG_INFO, "verifyGetSession", stringArray5);
            }
            ToygerConfig.getInstance().setAndroidClientProtocol(null);
            ToygerConfig.getInstance().setZimId(string2);
            ToygerConfig.getInstance().setContext(stringArray3.ctx);
            SgomInfoManager.updateSgomInfo((int)1544293176, null);
            FaceDataFrameInfo.info_got = false;
            ToygerConfig.getInstance().setUseMsgBox(bl);
            if (hashMap != null) {
                if (hashMap.containsKey("ext_params_key_ocr_bottom_button_color")) {
                    string2 = hashMap.get("ext_params_key_ocr_bottom_button_color");
                    if (!TextUtils.isEmpty((CharSequence)string2)) {
                        String string3 = string2;
                        String string4 = string3;
                        Color.parseColor((String)string3);
                        try {
                            UICustomParams.OCR_BOTTOM_COLOR = string4;
                        }
                        catch (Exception exception) {
                            UICustomParams.OCR_BOTTOM_COLOR = null;
                        }
                    } else {
                        UICustomParams.OCR_BOTTOM_COLOR = null;
                    }
                }
                if (hashMap.containsKey("ext_params_key_face_progress_color")) {
                    string2 = hashMap.get("ext_params_key_face_progress_color");
                    if (!TextUtils.isEmpty((CharSequence)string2)) {
                        String string5 = string2;
                        String string6 = string5;
                        Color.parseColor((String)string5);
                        try {
                            UICustomParams.FACE_PROGRESS_COLOR = string6;
                        }
                        catch (Exception exception) {
                            UICustomParams.FACE_PROGRESS_COLOR = null;
                        }
                    } else {
                        UICustomParams.FACE_PROGRESS_COLOR = null;
                    }
                }
                if (hashMap.containsKey("ext_params_key_top_tip_index") && !TextUtils.isEmpty((CharSequence)(string2 = hashMap.get("ext_params_key_top_tip_index"))) && string2 != null && string2.equalsIgnoreCase("ext_params_key_tip_index_tt")) {
                    UICustomParams.TOP_TIP_TEXT = stringArray3.ctx.getString(R.string.dtf_tantan_top_tip_text);
                }
                UICustomParams.OPEN_WEBVIEW_RENDER = hashMap.containsKey("ext_params_key_open_webview_render") ? "true".equalsIgnoreCase(hashMap.get("ext_params_key_open_webview_render")) : false;
            }
            string2 = DTFacade.getMetaInfo(stringArray3.ctx, null);
            Context context = stringArray3.startContext;
            context = context == null ? stringArray3.ctx : (Context)context.get();
            if (context == null) {
                context = stringArray3.ctx;
            }
            object = intent;
            new Intent(context, FaceLoadingActivity.class).putExtra("toyger_meta_info", string2);
            if (hashMap != null && hashMap.containsKey("ext_params_key_screen_orientation")) {
                object.putExtra("ext_params_key_screen_orientation", hashMap.get("ext_params_key_screen_orientation"));
            }
            if (!(context instanceof Activity)) {
                object.addFlags(0x10000000);
            }
            Object object2 = object;
            object2.putExtra("comeFrom", DTFacade.class.getName());
            ToygerConfig.getInstance().setResultCallBack(new IVerifyResultCallBack(){

                public void sendResAndExit(String string, String string2) {
                    DTFacade.this.sendResponse(ToygerConfig.getInstance().getZimId(), string);
                }
            });
            DTFacadeFaceExt.initCallBack((DTFacade)stringArray3, hashMap, (Intent)object2);
            context.startActivity((Intent)object);
            return;
        }
        stringArray3.sendResponse(string2, ToygerConst.ZcodeConstants.ZCODE_CERTIFYID_ERROR);
    }

    public void sendResponse(String stringArray, String object) {
        if (TextUtils.isEmpty((CharSequence)object)) {
            object = ToygerConst.ZcodeConstants.ZCODE_SYSTEM_EXC;
        }
        if (this.zimCallback != null) {
            ArrayList arrayList;
            DTResponse dTResponse;
            DTResponse dTResponse2 = dTResponse;
            dTResponse2();
            dTResponse2.reason = object;
            dTResponse.msg = stringArray;
            dTResponse.deviceToken = ToygerConfig.getInstance().getApdidDeviceToken();
            DTFacadeFaceExt.updateResult(dTResponse);
            if (((String)object).equalsIgnoreCase(ToygerConst.ZcodeConstants.ZCODE_NET_VERIFY_SUCCESS)) {
                dTResponse2.code = 1000;
            } else if (((String)object).startsWith(ToygerConst.ZcodeConstants.ZCODE_VERIFY_FAIL_PREFIX)) {
                stringArray = ((String)object).split("\\|");
                if (2 == stringArray.length) {
                    dTResponse2.reason = stringArray[1];
                }
                dTResponse2.code = 2006;
            } else {
                dTResponse2.code = !(((String)object).equalsIgnoreCase(ToygerConst.ZcodeConstants.ZCODE_NET_INIT_ERROR) || ((String)object).equalsIgnoreCase(ToygerConst.ZcodeConstants.ZCODE_NET_UPLOAD_IMAGE_ERROR) || ((String)object).equalsIgnoreCase(ToygerConst.ZcodeConstants.ZCODE_NET_VERIFY_ERROR) || ((String)object).equalsIgnoreCase(ToygerConst.ZcodeConstants.ZCODE_NETWORK_TIMEOUT) || ((String)object).equalsIgnoreCase(ToygerConst.ZcodeConstants.ZCODE_NETWORK_ERROR) || ((String)object).equalsIgnoreCase(ToygerConst.ZcodeConstants.ZCODE_OSS_TOKEN_INVALID) || ((String)object).equalsIgnoreCase(ToygerConst.ZcodeConstants.ZCODE_NET_OVER_RATE_LIMIT) || ((String)object).equalsIgnoreCase(Integer.toString(2002)) || ((String)object).equalsIgnoreCase(ToygerConst.ZcodeConstants.ZCODE_NET_MODEL_DOWNLOAD_FAILED)) ? (!((String)object).equalsIgnoreCase(ToygerConst.ZcodeConstants.ZCODE_USER_BACK) && !((String)object).equalsIgnoreCase(ToygerConst.ZcodeConstants.ZCODE_USER_NOT_AUTH) ? (((String)object).equalsIgnoreCase(String.valueOf(2003)) ? 2003 : 1001) : 1003) : 2002;
            }
            stringArray = arrayList;
            stringArray();
            stringArray.add("code");
            stringArray.add(String.valueOf(dTResponse2.code));
            stringArray.add("reason");
            stringArray.add(dTResponse2.reason);
            stringArray.add("msg");
            arrayList.add(dTResponse2.msg);
            if (!ModelDownloadUtil.hasAssetFaceModel((Context)this.ctx)) {
                object = LocalPreferencesUtil.getString((String)"modelUrl", null);
                if (object == null) {
                    object = ModelDownloadUtil.chooseValidFaceModel((Context)this.ctx);
                    object = object != null ? ((File)object).getAbsolutePath() : "modelUrl";
                }
                stringArray.add("modelUrl");
                stringArray.add(object);
            }
            RecordService.getInstance().recordEvent(RecordLevel.LOG_INFO, "finalResult", stringArray.toArray(new String[stringArray.size()]));
            this.zimCallback.response(dTResponse2);
        }
        RecordService.getInstance().zimEnd();
        SgomInfoManager.release();
        DTFacadeFaceExt.release();
        ToygerConfig.getInstance().setResultCallBack(null);
        ToygerConfig.getInstance().setUiCustomListener(null);
        this.zimCallback = null;
    }

    public void release() {
        block3: {
            try {
                if (this.startContext == null) break block3;
            }
            catch (Throwable throwable) {}
            this.startContext.clear();
        }
    }
}

