/*
 * Decompiled with CFR 0.152.
 */
package com.dtf.toyger.base;

public abstract class ToygerLogger {
    public static final int VERBOSE = 2;
    public static final int DEBUG = 3;
    public static final int INFO = 4;
    public static final int WARN = 5;
    public static final int ERROR = 6;
    public static final int ASSERT = 7;
    public int LOG_LEVEL = 2;

    public void setLogLevel(int n2) {
        if (n2 >= 2 && n2 <= 7) {
            this.LOG_LEVEL = n2;
            return;
        }
        throw new RuntimeException("The level value should between [2 , 7]");
    }

    public abstract int verbose(String var1, String var2);

    public int v(String string, String string2) {
        if (this.LOG_LEVEL <= 2) {
            return this.verbose(string, string2);
        }
        return -1;
    }

    public int v(String string, String string2, Throwable throwable) {
        if (this.LOG_LEVEL <= 2) {
            return this.verbose(string, string2 + '\n' + this.getStackTraceString(throwable));
        }
        return -1;
    }

    public int v(String string, Throwable throwable) {
        if (this.LOG_LEVEL <= 2) {
            return this.verbose(string, this.getStackTraceString(throwable));
        }
        return -1;
    }

    public abstract int debug(String var1, String var2);

    public int d(String string, String string2) {
        if (this.LOG_LEVEL <= 3) {
            return this.debug(string, string2);
        }
        return -1;
    }

    public int d(String string, String string2, Throwable throwable) {
        if (this.LOG_LEVEL <= 3) {
            return this.debug(string, string2 + '\n' + this.getStackTraceString(throwable));
        }
        return -1;
    }

    public int d(String string, Throwable throwable) {
        if (this.LOG_LEVEL <= 3) {
            return this.debug(string, this.getStackTraceString(throwable));
        }
        return -1;
    }

    public abstract int info(String var1, String var2);

    public int i(String string, String string2) {
        if (this.LOG_LEVEL <= 4) {
            return this.info(string, string2);
        }
        return -1;
    }

    public int i(String string, String string2, Throwable throwable) {
        if (this.LOG_LEVEL <= 4) {
            return this.info(string, string2 + '\n' + this.getStackTraceString(throwable));
        }
        return -1;
    }

    public int i(String string, Throwable throwable) {
        if (this.LOG_LEVEL <= 4) {
            return this.info(string, this.getStackTraceString(throwable));
        }
        return -1;
    }

    public abstract int warn(String var1, String var2);

    public int w(String string, String string2) {
        if (this.LOG_LEVEL <= 5) {
            return this.warn(string, string2);
        }
        return -1;
    }

    public int w(String string, String string2, Throwable throwable) {
        if (this.LOG_LEVEL <= 5) {
            return this.warn(string, string2 + '\n' + this.getStackTraceString(throwable));
        }
        return -1;
    }

    public int w(String string, Throwable throwable) {
        if (this.LOG_LEVEL <= 5) {
            return this.warn(string, this.getStackTraceString(throwable));
        }
        return -1;
    }

    public abstract int error(String var1, String var2);

    public int e(String string, String string2) {
        if (this.LOG_LEVEL <= 6) {
            return this.error(string, string2);
        }
        return -1;
    }

    public int e(String string, String string2, Throwable throwable) {
        if (this.LOG_LEVEL <= 6) {
            return this.error(string, string2 + '\n' + this.getStackTraceString(throwable));
        }
        return -1;
    }

    public int e(String string, Throwable throwable) {
        if (this.LOG_LEVEL <= 6) {
            return this.error(string, this.getStackTraceString(throwable));
        }
        return -1;
    }

    public abstract String getStackTraceString(Throwable var1);
}

