/*
 * Decompiled with CFR 0.152.
 */
package org.ejbca.cvc;

import org.ejbca.cvc.AbstractDataField;
import org.ejbca.cvc.AccessRightAuthTerm;
import org.ejbca.cvc.AccessRightEnum;
import org.ejbca.cvc.AccessRightSignTermEnum;
import org.ejbca.cvc.AccessRights;
import org.ejbca.cvc.AccessRightsRawValue;
import org.ejbca.cvc.AuthorizationRole;
import org.ejbca.cvc.AuthorizationRoleAuthTermEnum;
import org.ejbca.cvc.AuthorizationRoleEnum;
import org.ejbca.cvc.AuthorizationRoleRawValue;
import org.ejbca.cvc.AuthorizationRoleSignTermEnum;
import org.ejbca.cvc.CVCObjectIdentifiers;
import org.ejbca.cvc.CVCTagEnum;
import org.ejbca.cvc.OIDField;
import org.ejbca.cvc.util.StringConverter;

public class AuthorizationField
extends AbstractDataField {
    public static final long serialVersionUID = -5478250843535697147L;
    public AuthorizationRole role;
    public AccessRights rights;

    public AuthorizationField() {
        super(CVCTagEnum.ROLE_AND_ACCESS_RIGHTS);
    }

    public AuthorizationField(AuthorizationRole authorizationRole, AccessRights accessRights) {
        this();
        this.role = authorizationRole;
        this.rights = accessRights;
    }

    public AuthorizationField(AuthorizationRoleEnum authorizationRoleEnum, AccessRightEnum accessRightEnum) {
        this((AuthorizationRole)authorizationRoleEnum, (AccessRights)accessRightEnum);
    }

    public AuthorizationField(byte[] byArray) {
        this();
        if (byArray.length >= 1) {
            AuthorizationField authorizationField = this;
            authorizationField.role = new AuthorizationRoleRawValue(byArray[0]);
            authorizationField.rights = new AccessRightsRawValue(byArray);
            return;
        }
        throw new IllegalArgumentException("byte array length must be at least 1");
    }

    public static AuthorizationRole getRoleFromByte(OIDField enumArray, byte by) {
        block6: {
            block4: {
                block5: {
                    block3: {
                        by = (byte)(by & 0xC0);
                        if (!CVCObjectIdentifiers.id_EAC_ePassport.equals(enumArray)) break block3;
                        enumArray = AuthorizationRoleEnum.values();
                        break block4;
                    }
                    if (!CVCObjectIdentifiers.id_EAC_roles_ST.equals(enumArray)) break block5;
                    enumArray = AuthorizationRoleSignTermEnum.values();
                    break block4;
                }
                if (!CVCObjectIdentifiers.id_EAC_roles_AT.equals(enumArray)) break block6;
                enumArray = AuthorizationRoleAuthTermEnum.values();
            }
            Enum enum_ = null;
            int n2 = enumArray.length;
            int n3 = 0;
            while (true) {
                block9: {
                    Enum enum_2;
                    block8: {
                        block7: {
                            if (n3 < n2) break block7;
                            enum_2 = enum_;
                            break block8;
                        }
                        enum_2 = enumArray[n3];
                        if (by != enum_2.getValue()) break block9;
                    }
                    return enum_2;
                }
                ++n3;
            }
        }
        throw new IllegalArgumentException("incorrect or unsupported OID");
    }

    public static AccessRights getRightsFromBytes(OIDField oIDField, byte[] byArray) {
        block15: {
            block16: {
                block10: {
                    block11: {
                        if (!CVCObjectIdentifiers.id_EAC_ePassport.equals(oIDField)) break block10;
                        if (byArray.length != 1) break block11;
                        byte by = (byte)(byArray[0] & 3);
                        AccessRightEnum accessRightEnum = null;
                        AccessRightEnum[] accessRightEnumArray = AccessRightEnum.values();
                        int n2 = accessRightEnumArray.length;
                        int n3 = 0;
                        while (true) {
                            block14: {
                                AccessRightEnum accessRightEnum2;
                                block13: {
                                    block12: {
                                        if (n3 < n2) break block12;
                                        accessRightEnum2 = accessRightEnum;
                                        break block13;
                                    }
                                    accessRightEnum2 = accessRightEnumArray[n3];
                                    if (by != accessRightEnum2.getValue()) break block14;
                                }
                                return accessRightEnum2;
                            }
                            ++n3;
                        }
                    }
                    throw new IllegalArgumentException("byte array length must be 1, was " + byArray.length);
                }
                if (!CVCObjectIdentifiers.id_EAC_roles_ST.equals(oIDField)) break block15;
                if (byArray.length != 1) break block16;
                byte by = (byte)(byArray[0] & 3);
                AccessRightSignTermEnum accessRightSignTermEnum = null;
                AccessRightSignTermEnum[] accessRightSignTermEnumArray = AccessRightSignTermEnum.values();
                int n4 = accessRightSignTermEnumArray.length;
                int n5 = 0;
                while (true) {
                    block19: {
                        AccessRightSignTermEnum accessRightSignTermEnum2;
                        block18: {
                            block17: {
                                if (n5 < n4) break block17;
                                accessRightSignTermEnum2 = accessRightSignTermEnum;
                                break block18;
                            }
                            accessRightSignTermEnum2 = accessRightSignTermEnumArray[n5];
                            if (by != accessRightSignTermEnum2.getValue()) break block19;
                        }
                        return accessRightSignTermEnum2;
                    }
                    ++n5;
                }
            }
            throw new IllegalArgumentException("byte array length must be 1, was " + byArray.length);
        }
        if (CVCObjectIdentifiers.id_EAC_roles_AT.equals(oIDField)) {
            if (byArray.length == 5) {
                return new AccessRightAuthTerm(byArray);
            }
            throw new IllegalArgumentException("byte array length must be 5, was " + byArray.length);
        }
        throw new IllegalArgumentException("incorrect or unsupported OID");
    }

    public AuthorizationRoleEnum getRole() {
        AuthorizationRole authorizationRole = ((AuthorizationField)((Object)authorizationRole)).role;
        if (authorizationRole instanceof AuthorizationRoleEnum) {
            return (AuthorizationRoleEnum)authorizationRole;
        }
        throw new UnsupportedOperationException("Attempted to use deprecated getRole method with in an AT or ST certificate chain. It handles IS only.");
    }

    public AuthorizationRole getAuthRole() {
        return this.role;
    }

    public AccessRightEnum getAccessRight() {
        AccessRights accessRights = ((AuthorizationField)((Object)accessRights)).rights;
        if (accessRights instanceof AccessRightEnum) {
            return (AccessRightEnum)accessRights;
        }
        throw new UnsupportedOperationException("Attempted to use deprecated getAccessRight method with an AT or ST certificate chain. It handles IS only.");
    }

    public AccessRights getAccessRights() {
        return this.rights;
    }

    @Override
    public byte[] getEncoded() {
        byte[] byArray = this.rights.getEncoded();
        byArray[0] = (byte)(byArray[0] | this.role.getValue());
        return byArray;
    }

    @Override
    public String valueAsText() {
        return StringConverter.byteToHex(this.getEncoded()) + ": " + this.role + "/" + this.rights;
    }

    public void fixEnumTypes(OIDField oIDField) {
        this.role = AuthorizationField.getRoleFromByte(oIDField, this.role.getValue());
        this.rights = AuthorizationField.getRightsFromBytes(oIDField, this.rights.getEncoded());
    }
}

