/*
 * Decompiled with CFR 0.152.
 */
package org.ejbca.cvc;

import org.ejbca.cvc.AuthorizationRole;

public enum AuthorizationRoleSignTermEnum implements AuthorizationRole
{
    CVCA(192),
    DV_AB(128),
    DV_CSP(64),
    SIGNTERM(0);

    public byte value;

    public AuthorizationRoleSignTermEnum(int n3) {
        this.value = (byte)n3;
    }

    @Override
    public byte getValue() {
        return this.value;
    }

    @Override
    public boolean isCVCA() {
        return this == CVCA;
    }

    public boolean isDV() {
        return this == DV_AB || this == DV_CSP;
    }

    public boolean isDomesticDV() {
        return false;
    }

    public boolean isForeignDV() {
        return false;
    }

    public boolean isAccreditationBodyDV() {
        return this == DV_AB;
    }

    public boolean isCertificationServiceProviderDV() {
        return this == DV_CSP;
    }

    public boolean isIS() {
        return false;
    }

    public boolean isAuthenticationTerminal() {
        return false;
    }

    public boolean isSignatureTerminal() {
        return this == SIGNTERM;
    }

    public String toString() {
        switch (this) {
            default: {
                throw new IllegalStateException("Enum case not handled");
            }
            case SIGNTERM: {
                return "Signature-Terminal";
            }
            case DV_CSP: {
                return "DV-Certification-Service-Provider";
            }
            case DV_AB: {
                return "DV-Accreditation-Body";
            }
            case CVCA: 
        }
        return "CVCA";
    }
}

