/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.protocol;

import java.io.Serializable;
import java.security.PublicKey;
import java.util.Arrays;
import net.sf.scuba.util.Hex;
import org.jmrtd.Util;

public class AAResult
implements Serializable {
    public static final long serialVersionUID = 8800803919646625713L;
    public PublicKey publicKey;
    public String digestAlgorithm;
    public String signatureAlgorithm;
    public byte[] challenge;
    public byte[] response;

    public AAResult(PublicKey publicKey, String string, String string2, byte[] byArray, byte[] byArray2) {
        this.publicKey = publicKey;
        this.digestAlgorithm = string;
        this.signatureAlgorithm = string2;
        this.challenge = byArray;
        this.response = byArray2;
    }

    public byte[] getChallenge() {
        return this.challenge;
    }

    public byte[] getResponse() {
        return this.response;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public String toString() {
        return "AAResult [publicKey: " + Util.getDetailedPublicKeyAlgorithm(this.publicKey) + ", digestAlgorithm: " + this.digestAlgorithm + ", signatureAlgorithm: " + this.signatureAlgorithm + ", challenge: " + Hex.bytesToHexString((byte[])this.challenge) + ", response: " + Hex.bytesToHexString((byte[])this.response);
    }

    public int hashCode() {
        AAResult aAResult = this;
        int n2 = (1303377669 + Arrays.hashCode(aAResult.challenge)) * 1991;
        String string = aAResult.digestAlgorithm;
        int n3 = string == null ? 0 : string.hashCode();
        n2 = (n2 + n3) * 1991;
        PublicKey publicKey = this.publicKey;
        int n4 = publicKey == null ? 0 : publicKey.hashCode();
        int n5 = ((n2 + n4) * 1991 + Arrays.hashCode(this.response)) * 1991;
        String string2 = this.signatureAlgorithm;
        int n6 = string2 == null ? 0 : string2.hashCode();
        return n5 + n6;
    }

    public boolean equals(Object object) {
        if (string == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (AAResult.class != object.getClass()) {
            return false;
        }
        object = (AAResult)object;
        if (!Arrays.equals(((AAResult)((Object)string)).challenge, ((AAResult)object).challenge)) {
            return false;
        }
        Object object2 = ((AAResult)((Object)string)).digestAlgorithm;
        if (object2 == null ? ((AAResult)object).digestAlgorithm != null : !((String)object2).equals(((AAResult)object).digestAlgorithm)) {
            return false;
        }
        object2 = ((AAResult)((Object)string)).publicKey;
        if (object2 == null ? ((AAResult)object).publicKey != null : !object2.equals(((AAResult)object).publicKey)) {
            return false;
        }
        if (!Arrays.equals(((AAResult)((Object)string)).response, ((AAResult)object).response)) {
            return false;
        }
        String string = ((AAResult)((Object)string)).signatureAlgorithm;
        return !(string == null ? ((AAResult)object).signatureAlgorithm != null : !string.equals(((AAResult)object).signatureAlgorithm));
    }
}

