/*
 * Decompiled with CFR 0.152.
 */
package net.sf.scuba.tlv;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.scuba.tlv.ASN1Constants;
import net.sf.scuba.tlv.TLVUtil;
import net.sf.scuba.util.Hex;

public class ASN1Util
implements ASN1Constants {
    private static final Logger LOGGER = Logger.getLogger("net.sf.scuba");
    private static final String SDF = "yyMMddhhmmss'Z'";

    private ASN1Util() {
    }

    static Object interpretPrimitiveValue(int tag, byte[] valueBytes) {
        SimpleDateFormat sdf = new SimpleDateFormat(SDF);
        if (TLVUtil.getTagClass(tag) != 0) {
            return valueBytes;
        }
        switch (tag) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return valueBytes;
            }
            default: {
                return valueBytes;
            }
            case 12: 
            case 19: 
            case 20: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 30: {
                return new String(valueBytes);
            }
            case 23: 
        }
        try {
            return sdf.parse(new String(valueBytes));
        }
        catch (ParseException var4) {
            LOGGER.log(Level.WARNING, "Parse exception parsing UTC time", var4);
            return valueBytes;
        }
    }

    static String tagToString(int tag) {
        block26: {
            block25: {
                if (TLVUtil.getTagClass(tag) != 0) {
                    return "'0x" + Hex.intToHexString(tag) + "'";
                }
                if (!TLVUtil.isPrimitive(tag)) break block25;
                switch (tag & 0x1F) {
                    case 1: {
                        return "BOOLEAN";
                    }
                    case 2: {
                        return "INTEGER";
                    }
                    case 3: {
                        return "BIT_STRING";
                    }
                    case 4: {
                        return "OCTET_STRING";
                    }
                    case 5: {
                        return "NULL";
                    }
                    case 6: {
                        return "OBJECT_IDENTIFIER";
                    }
                    default: {
                        break block26;
                    }
                    case 9: {
                        return "REAL";
                    }
                    case 12: {
                        return "UTF_STRING";
                    }
                    case 19: {
                        return "PRINTABLE_STRING";
                    }
                    case 20: {
                        return "T61_STRING";
                    }
                    case 22: {
                        return "IA5_STRING";
                    }
                    case 23: {
                        return "UTC_TIME";
                    }
                    case 24: {
                        return "GENERAL_TIME";
                    }
                    case 26: {
                        return "VISIBLE_STRING";
                    }
                    case 27: {
                        return "GENERAL_STRING";
                    }
                    case 28: {
                        return "UNIVERSAL_STRING";
                    }
                    case 30: {
                        return "BMP_STRING";
                    }
                }
            }
            switch (tag & 0x1F) {
                case 10: {
                    return "ENUMERATED";
                }
                case 16: {
                    return "SEQUENCE";
                }
                case 17: {
                    return "SET";
                }
            }
        }
        return "'0x" + Hex.intToHexString(tag) + "'";
    }
}

