/*
 * Decompiled with CFR 0.152.
 */
package org.ejbca.cvc;

import org.ejbca.cvc.AbstractSequence;
import org.ejbca.cvc.AccessRightAuthTerm;
import org.ejbca.cvc.AccessRightEnum;
import org.ejbca.cvc.AccessRightSignTermEnum;
import org.ejbca.cvc.AccessRights;
import org.ejbca.cvc.AuthorizationField;
import org.ejbca.cvc.AuthorizationRole;
import org.ejbca.cvc.AuthorizationRoleAuthTermEnum;
import org.ejbca.cvc.AuthorizationRoleEnum;
import org.ejbca.cvc.AuthorizationRoleSignTermEnum;
import org.ejbca.cvc.CVCObject;
import org.ejbca.cvc.CVCObjectIdentifiers;
import org.ejbca.cvc.CVCTagEnum;
import org.ejbca.cvc.OIDField;
import org.ejbca.cvc.exception.ConstructionException;

public class CVCAuthorizationTemplate
extends AbstractSequence {
    public static final long serialVersionUID = 1L;
    public static CVCTagEnum[] allowedFields = new CVCTagEnum[]{CVCTagEnum.OID, CVCTagEnum.ROLE_AND_ACCESS_RIGHTS};

    public CVCAuthorizationTemplate() {
        super(CVCTagEnum.HOLDER_AUTH_TEMPLATE);
    }

    public CVCAuthorizationTemplate(AuthorizationRole authorizationRole, AccessRights accessRights) {
        CVCAuthorizationTemplate cVCAuthorizationTemplate = this;
        this();
        cVCAuthorizationTemplate.addSubfield(CVCAuthorizationTemplate.getOIDForEnums(authorizationRole, accessRights));
        cVCAuthorizationTemplate.addSubfield(new AuthorizationField(authorizationRole, accessRights));
    }

    public CVCAuthorizationTemplate(AuthorizationRoleEnum authorizationRoleEnum, AccessRightEnum accessRightEnum) {
        this((AuthorizationRole)authorizationRoleEnum, (AccessRights)accessRightEnum);
    }

    public static OIDField getOIDForEnums(AuthorizationRole authorizationRole, AccessRights accessRights) {
        if (authorizationRole instanceof AuthorizationRoleEnum && accessRights instanceof AccessRightEnum) {
            return CVCObjectIdentifiers.id_EAC_ePassport;
        }
        if (authorizationRole instanceof AuthorizationRoleAuthTermEnum && accessRights instanceof AccessRightAuthTerm) {
            return CVCObjectIdentifiers.id_EAC_roles_AT;
        }
        if (authorizationRole instanceof AuthorizationRoleSignTermEnum && accessRights instanceof AccessRightSignTermEnum) {
            return CVCObjectIdentifiers.id_EAC_roles_ST;
        }
        throw new IllegalArgumentException("Unsupported roles/rights type (or mismatch). Got role of type " + authorizationRole.getClass().getSimpleName() + ", but rights of type " + accessRights.getClass().getSimpleName());
    }

    @Override
    public CVCTagEnum[] getAllowedFields() {
        return allowedFields;
    }

    @Override
    public void addSubfield(CVCObject cVCObject) {
        super.addSubfield(cVCObject);
        if (cVCObject instanceof AuthorizationField) {
            try {
                ((AuthorizationField)cVCObject).fixEnumTypes((OIDField)this.getSubfield(CVCTagEnum.OID));
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new ConstructionException("Tried to add an AuthorizationField without an OID", noSuchFieldException);
            }
        }
    }

    public String getObjectIdentifier() {
        return ((OIDField)this.getSubfield(CVCTagEnum.OID)).getValue();
    }

    public AuthorizationField getAuthorizationField() {
        return (AuthorizationField)this.getSubfield(CVCTagEnum.ROLE_AND_ACCESS_RIGHTS);
    }
}

