/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd;

import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.List;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import net.sf.scuba.smartcards.APDUListener;
import net.sf.scuba.smartcards.CardFileInputStream;
import net.sf.scuba.smartcards.CardService;
import net.sf.scuba.smartcards.CommandAPDU;
import net.sf.scuba.smartcards.FileSystemStructured;
import net.sf.scuba.smartcards.ResponseAPDU;
import org.jmrtd.AbstractMRTDCardService;
import org.jmrtd.AccessKeySpec;
import org.jmrtd.BACKeySpec;
import org.jmrtd.DefaultFileSystem;
import org.jmrtd.cert.CVCPrincipal;
import org.jmrtd.cert.CardVerifiableCertificate;
import org.jmrtd.protocol.AAAPDUSender;
import org.jmrtd.protocol.AAProtocol;
import org.jmrtd.protocol.AAResult;
import org.jmrtd.protocol.BACAPDUSender;
import org.jmrtd.protocol.BACProtocol;
import org.jmrtd.protocol.BACResult;
import org.jmrtd.protocol.EACCAAPDUSender;
import org.jmrtd.protocol.EACCAProtocol;
import org.jmrtd.protocol.EACCAResult;
import org.jmrtd.protocol.EACTAAPDUSender;
import org.jmrtd.protocol.EACTAProtocol;
import org.jmrtd.protocol.EACTAResult;
import org.jmrtd.protocol.PACEAPDUSender;
import org.jmrtd.protocol.PACEProtocol;
import org.jmrtd.protocol.PACEResult;
import org.jmrtd.protocol.ReadBinaryAPDUSender;
import org.jmrtd.protocol.SecureMessagingWrapper;

public class PassportService
extends AbstractMRTDCardService {
    public static final byte NO_PACE_KEY_REFERENCE = 0;
    public static final byte MRZ_PACE_KEY_REFERENCE = 1;
    public static final byte CAN_PACE_KEY_REFERENCE = 2;
    public static final byte PIN_PACE_KEY_REFERENCE = 3;
    public static final byte PUK_PACE_KEY_REFERENCE = 4;
    public static final Logger LOGGER = Logger.getLogger("org.jmrtd");
    public static final short EF_CARD_ACCESS = 284;
    public static final short EF_CARD_SECURITY = 285;
    public static final short EF_DG1 = 257;
    public static final short EF_DG2 = 258;
    public static final short EF_DG3 = 259;
    public static final short EF_DG4 = 260;
    public static final short EF_DG5 = 261;
    public static final short EF_DG6 = 262;
    public static final short EF_DG7 = 263;
    public static final short EF_DG8 = 264;
    public static final short EF_DG9 = 265;
    public static final short EF_DG10 = 266;
    public static final short EF_DG11 = 267;
    public static final short EF_DG12 = 268;
    public static final short EF_DG13 = 269;
    public static final short EF_DG14 = 270;
    public static final short EF_DG15 = 271;
    public static final short EF_DG16 = 272;
    public static final short EF_SOD = 285;
    public static final short EF_COM = 286;
    public static final short EF_CVCA = 284;
    public static final byte SFI_CARD_ACCESS = 28;
    public static final byte SFI_CARD_SECURITY = 29;
    public static final byte SFI_DG1 = 1;
    public static final byte SFI_DG2 = 2;
    public static final byte SFI_DG3 = 3;
    public static final byte SFI_DG4 = 4;
    public static final byte SFI_DG5 = 5;
    public static final byte SFI_DG6 = 6;
    public static final byte SFI_DG7 = 7;
    public static final byte SFI_DG8 = 8;
    public static final byte SFI_DG9 = 9;
    public static final byte SFI_DG10 = 10;
    public static final byte SFI_DG11 = 11;
    public static final byte SFI_DG12 = 12;
    public static final byte SFI_DG13 = 13;
    public static final byte SFI_DG14 = 14;
    public static final byte SFI_DG15 = 15;
    public static final byte SFI_DG16 = 16;
    public static final byte SFI_COM = 30;
    public static final byte SFI_SOD = 29;
    public static final byte SFI_CVCA = 28;
    public static final int DEFAULT_MAX_BLOCKSIZE = 224;
    public static final int NORMAL_MAX_TRANCEIVE_LENGTH = 256;
    public static final int EXTENDED_MAX_TRANCEIVE_LENGTH = 65536;
    public static final byte[] APPLET_AID = new byte[]{-96, 0, 0, 2, 71, 16, 1};
    public int maxBlockSize;
    public boolean isOpen;
    public SecureMessagingWrapper wrapper;
    public int maxTranceiveLength;
    public boolean shouldCheckMAC;
    public boolean isAppletSelected;
    public DefaultFileSystem rootFileSystem;
    public DefaultFileSystem appletFileSystem;
    public BACAPDUSender bacSender;
    public PACEAPDUSender paceSender;
    public AAAPDUSender aaSender;
    public EACCAAPDUSender eacCASender;
    public EACTAAPDUSender eacTASender;
    public ReadBinaryAPDUSender readBinarySender;
    public CardService service;

    public PassportService(CardService cardService, int n2, int n3, boolean bl, boolean bl2) {
        PassportService passportService = this;
        PassportService passportService2 = this;
        passportService2.service = cardService;
        passportService2.bacSender = new BACAPDUSender(cardService);
        passportService2.paceSender = new PACEAPDUSender(cardService);
        passportService2.aaSender = new AAAPDUSender(cardService);
        passportService2.eacCASender = new EACCAAPDUSender(cardService);
        passportService2.eacTASender = new EACTAAPDUSender(cardService);
        passportService2.readBinarySender = new ReadBinaryAPDUSender(cardService);
        this.maxTranceiveLength = n2;
        this.maxBlockSize = n3;
        passportService.shouldCheckMAC = bl2;
        passportService.isAppletSelected = false;
        passportService.isOpen = false;
        passportService.rootFileSystem = new DefaultFileSystem(this.readBinarySender, false);
        passportService.appletFileSystem = new DefaultFileSystem(this.readBinarySender, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() {
        if (!this.isOpen()) {
            PassportService passportService = this;
            synchronized (passportService) {
                passportService.service.open();
                passportService.isOpen = true;
            }
        }
    }

    @Override
    public void sendSelectApplet(boolean bl) {
        if (this.isAppletSelected) {
            LOGGER.info("Re-selecting ICAO applet");
        }
        if (bl) {
            this.readBinarySender.sendSelectApplet(this.wrapper, APPLET_AID);
        } else {
            this.readBinarySender.sendSelectApplet(null, APPLET_AID);
        }
        this.isAppletSelected = true;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public synchronized BACResult doBAC(AccessKeySpec serializable) {
        if (serializable instanceof BACKeySpec) {
            serializable = new BACProtocol(this.bacSender, this.maxTranceiveLength, this.shouldCheckMAC).doBAC((BACKeySpec)serializable);
            this.wrapper = ((BACResult)serializable).getWrapper();
            this.appletFileSystem.setWrapper(this.wrapper);
            return serializable;
        }
        throw new IllegalArgumentException("Unsupported key type");
    }

    @Override
    public synchronized BACResult doBAC(SecretKey serializable, SecretKey secretKey) {
        BACProtocol bACProtocol;
        BACProtocol bACProtocol2 = bACProtocol;
        bACProtocol2(this.bacSender, this.maxTranceiveLength, this.shouldCheckMAC);
        serializable = bACProtocol.doBAC((SecretKey)serializable, secretKey);
        this.wrapper = ((BACResult)serializable).getWrapper();
        this.appletFileSystem.setWrapper(this.wrapper);
        return serializable;
    }

    @Override
    public synchronized PACEResult doPACE(AccessKeySpec serializable, String string, AlgorithmParameterSpec algorithmParameterSpec) {
        PACEProtocol pACEProtocol;
        PACEProtocol pACEProtocol2 = pACEProtocol;
        pACEProtocol2(this.paceSender, this.wrapper, this.maxTranceiveLength, this.shouldCheckMAC);
        serializable = pACEProtocol.doPACE((AccessKeySpec)serializable, string, algorithmParameterSpec);
        this.wrapper = ((PACEResult)serializable).getWrapper();
        this.appletFileSystem.setWrapper(this.wrapper);
        return serializable;
    }

    @Override
    public synchronized EACCAResult doEACCA(BigInteger serializable, String string, String string2, PublicKey publicKey) {
        EACCAProtocol eACCAProtocol;
        EACCAProtocol eACCAProtocol2 = eACCAProtocol;
        eACCAProtocol2(this.eacCASender, this.wrapper, this.maxTranceiveLength, this.shouldCheckMAC);
        serializable = eACCAProtocol.doCA((BigInteger)serializable, string, string2, publicKey);
        this.wrapper = ((EACCAResult)serializable).getWrapper();
        this.appletFileSystem.setWrapper(this.wrapper);
        return serializable;
    }

    @Override
    public synchronized EACTAResult doEACTA(CVCPrincipal cVCPrincipal, List<CardVerifiableCertificate> list, PrivateKey privateKey, String string, EACCAResult eACCAResult, String string2) {
        EACTAProtocol eACTAProtocol;
        EACTAProtocol eACTAProtocol2 = eACTAProtocol;
        eACTAProtocol2(this.eacTASender, this.wrapper);
        return eACTAProtocol.doEACTA(cVCPrincipal, list, privateKey, string, eACCAResult, string2);
    }

    @Override
    public synchronized EACTAResult doEACTA(CVCPrincipal cVCPrincipal, List<CardVerifiableCertificate> list, PrivateKey privateKey, String string, EACCAResult eACCAResult, PACEResult pACEResult) {
        EACTAProtocol eACTAProtocol;
        EACTAProtocol eACTAProtocol2 = eACTAProtocol;
        eACTAProtocol2(this.eacTASender, this.wrapper);
        return eACTAProtocol.doTA(cVCPrincipal, list, privateKey, string, eACCAResult, pACEResult);
    }

    @Override
    public AAResult doAA(PublicKey publicKey, String string, String string2, byte[] byArray) {
        AAProtocol aAProtocol;
        AAProtocol aAProtocol2 = aAProtocol;
        aAProtocol2(this.aaSender, this.wrapper);
        return aAProtocol.doAA(publicKey, string, string2, byArray);
    }

    public void close() {
        try {
            this.service.close();
            this.wrapper = null;
            this.isOpen = false;
            return;
        }
        catch (Throwable throwable) {
            this.isOpen = false;
            throw throwable;
        }
    }

    public int getMaxTranceiveLength() {
        return this.maxTranceiveLength;
    }

    @Override
    public SecureMessagingWrapper getWrapper() {
        return this.wrapper;
    }

    public ResponseAPDU transmit(CommandAPDU commandAPDU) {
        return this.service.transmit(commandAPDU);
    }

    public byte[] getATR() {
        return this.service.getATR();
    }

    public boolean isConnectionLost(Exception exception) {
        return this.service.isConnectionLost(exception);
    }

    public boolean shouldCheckMAC() {
        return this.shouldCheckMAC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized CardFileInputStream getInputStream(short s2) {
        if (!this.isAppletSelected) {
            PassportService passportService = this;
            DefaultFileSystem defaultFileSystem = passportService.rootFileSystem;
            synchronized (defaultFileSystem) {
                passportService.rootFileSystem.selectFile(s2);
                return new CardFileInputStream(this.maxBlockSize, (FileSystemStructured)this.rootFileSystem);
            }
        }
        PassportService passportService = this;
        DefaultFileSystem defaultFileSystem = passportService.appletFileSystem;
        synchronized (defaultFileSystem) {
            passportService.appletFileSystem.selectFile(s2);
            return new CardFileInputStream(this.maxBlockSize, (FileSystemStructured)this.appletFileSystem);
        }
    }

    public void addAPDUListener(APDUListener aPDUListener) {
        this.service.addAPDUListener(aPDUListener);
    }

    public void removeAPDUListener(APDUListener aPDUListener) {
        this.service.removeAPDUListener(aPDUListener);
    }
}

